/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.command.exception.CommandUsageException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Bee;
import org.bukkit.entity.EntityType;

@TraitName(value="beetrait")
public class BeeTrait
extends Trait {
    @Persist
    private int anger;
    @Persist
    private boolean nectar = false;
    @Persist
    private boolean stung = false;

    public BeeTrait() {
        super("beetrait");
    }

    public boolean hasNectar() {
        return this.nectar;
    }

    public boolean hasStung() {
        return this.stung;
    }

    @Override
    public void run() {
        if (this.npc.isSpawned() && this.npc.getEntity() instanceof Bee) {
            Bee bee = (Bee)this.npc.getEntity();
            bee.setHasStung(this.stung);
            bee.setAnger(this.anger);
            bee.setHasNectar(this.nectar);
        }
    }

    public void setAnger(int anger) {
        this.anger = anger;
    }

    public void setNectar(boolean nectar) {
        this.nectar = nectar;
    }

    public void setStung(boolean stung) {
        this.stung = stung;
    }

    @Command(aliases={"npc"}, usage="bee (-s/-n) --anger anger", desc="Sets bee modifiers", modifiers={"bee"}, min=1, max=1, flags="sn", permission="citizens.npc.bee")
    @Requirements(selected=true, ownership=true, types={EntityType.BEE})
    public static void bee(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"anger"}) Integer anger) throws CommandException {
        BeeTrait trait = npc.getOrAddTrait(BeeTrait.class);
        String output = "";
        if (anger != null) {
            if (anger < 0) {
                throw new CommandException("citizens.commands.npc.bee.invalid-anger");
            }
            trait.setAnger(anger);
            output = output + ' ' + Messaging.tr("citizens.commands.npc.bee.anger-set", args.getFlag("anger"));
        }
        if (args.hasFlag('s')) {
            trait.setStung(!trait.hasStung());
            output = output + ' ' + (trait.hasStung() ? Messaging.tr("citizens.commands.npc.bee.bee-stung", npc.getName()) : Messaging.tr("citizens.commands.npc.bee.not-stung", npc.getName()));
        }
        if (args.hasFlag('n')) {
            trait.setNectar(!trait.hasNectar());
            output = output + ' ' + (trait.hasNectar() ? Messaging.tr("citizens.commands.npc.bee.has-nectar", npc.getName()) : Messaging.tr("citizens.commands.npc.bee.no-nectar", npc.getName()));
        }
        if (output.isEmpty()) {
            throw new CommandUsageException();
        }
        Messaging.send(sender, output.trim());
    }
}

