/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.text;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.speech.SpeechContext;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.Paginator;
import net.citizensnpcs.api.util.Placeholders;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.trait.HologramTrait;
import net.citizensnpcs.trait.text.TextBasePrompt;
import net.citizensnpcs.util.Util;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.conversations.ConversationAbandonedListener;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

@TraitName(value="text")
public class Text
extends Trait
implements Runnable,
Listener,
ConversationAbandonedListener {
    private final Map<UUID, Long> cooldowns = Maps.newHashMap();
    private int currentIndex;
    private int delay = -1;
    private String itemInHandPattern = "default";
    private final Plugin plugin;
    private boolean randomTalker = Settings.Setting.DEFAULT_RANDOM_TALKER.asBoolean();
    private double range = Settings.Setting.DEFAULT_TALK_CLOSE_RANGE.asDouble();
    private boolean realisticLooker = Settings.Setting.DEFAULT_REALISTIC_LOOKING.asBoolean();
    private boolean speechBubbles;
    private boolean talkClose = Settings.Setting.DEFAULT_TALK_CLOSE.asBoolean();
    private final List<String> text = new ArrayList<String>();
    private static Random RANDOM = Util.getFastRandom();

    public Text() {
        super("text");
        this.plugin = CitizensAPI.getPlugin();
    }

    public void add(String string) {
        this.text.add(string);
    }

    public void conversationAbandoned(ConversationAbandonedEvent event) {
    }

    public void edit(int index, String newText) {
        this.text.set(index, newText);
    }

    public Editor getEditor(final Player player) {
        final Conversation conversation = new ConversationFactory(this.plugin).addConversationAbandonedListener((ConversationAbandonedListener)this).withLocalEcho(false).withEscapeSequence("/npc text").withEscapeSequence("exit").withModality(false).withFirstPrompt((Prompt)new TextBasePrompt(this)).buildConversation((Conversable)player);
        return new Editor(){

            @Override
            public void begin() {
                Messaging.sendTr((CommandSender)player, "citizens.editors.text.begin", new Object[0]);
                conversation.begin();
            }

            @Override
            public void end() {
                Messaging.sendTr((CommandSender)player, "citizens.editors.text.end", new Object[0]);
                conversation.abandon();
            }
        };
    }

    String getPageText(int page) {
        Paginator paginator = new Paginator().header("Current Texts");
        for (int i = 0; i < this.text.size(); ++i) {
            paginator.addLine("<green>" + i + " <gray>- <yellow>" + this.text.get(i));
        }
        return paginator.getPageText(page);
    }

    public List<String> getTexts() {
        return this.text;
    }

    public boolean hasIndex(int index) {
        return index >= 0 && this.text.size() > index;
    }

    boolean hasPage(int page) {
        return new Paginator(this.text.size()).hasPage(page);
    }

    public boolean isRandomTalker() {
        return this.randomTalker;
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        this.text.clear();
        for (DataKey sub : key.getRelative("text").getIntegerSubKeys()) {
            this.text.add(sub.getString(""));
        }
        if (this.text.isEmpty()) {
            this.populateDefaultText();
        }
        this.talkClose = key.getBoolean("talk-close", this.talkClose);
        this.realisticLooker = key.getBoolean("realistic-looking", this.realisticLooker);
        this.randomTalker = key.getBoolean("random-talker", this.randomTalker);
        this.range = key.getDouble("range", this.range);
        this.delay = key.getInt("delay", this.delay);
        this.speechBubbles = key.getBoolean("speech-bubbles", this.speechBubbles);
        this.itemInHandPattern = key.getString("talkitem", this.itemInHandPattern);
    }

    @EventHandler
    private void onRightClick(NPCRightClickEvent event) {
        String localPattern;
        if (!event.getNPC().equals(this.npc)) {
            return;
        }
        String string = localPattern = this.itemInHandPattern.equals("default") ? Settings.Setting.TALK_ITEM.asString() : this.itemInHandPattern;
        if (Util.matchesItemInHand(event.getClicker(), localPattern) && !this.shouldTalkClose()) {
            this.sendCooldownMessage(event.getClicker());
            event.setCancelled(true);
        }
    }

    private void populateDefaultText() {
        this.text.addAll(Settings.Setting.DEFAULT_TEXT.asList());
    }

    public void remove(int index) {
        this.text.remove(index);
    }

    @Override
    public void run() {
        if (!this.npc.isSpawned()) {
            return;
        }
        if (!this.talkClose) {
            return;
        }
        List nearby = this.npc.getEntity().getNearbyEntities(this.range, this.range, this.range);
        for (Entity search : nearby) {
            if (!(search instanceof Player) || ((Player)search).getGameMode() == GameMode.SPECTATOR) continue;
            this.sendCooldownMessage((Player)search);
        }
    }

    @Override
    public void save(DataKey key) {
        key.setInt("delay", this.delay);
        key.setBoolean("talk-close", this.talkClose);
        key.setBoolean("random-talker", this.randomTalker);
        key.setBoolean("realistic-looking", this.realisticLooker);
        key.setDouble("range", this.range);
        key.setString("talkitem", this.itemInHandPattern);
        key.setBoolean("speech-bubbles", this.speechBubbles);
        key.removeKey("text");
        for (int i = 0; i < this.text.size(); ++i) {
            key.setString("text." + String.valueOf(i), this.text.get(i));
        }
    }

    private void sendCooldownMessage(Player player) {
        int secondsDelta;
        Long cooldown = this.cooldowns.get(player.getUniqueId());
        if (cooldown != null) {
            if (System.currentTimeMillis() < cooldown) {
                return;
            }
            this.cooldowns.remove(player.getUniqueId());
        }
        this.sendText(player);
        int n = secondsDelta = this.delay != -1 ? this.delay : RANDOM.nextInt(Settings.Setting.TALK_CLOSE_MAXIMUM_COOLDOWN.asInt()) + Settings.Setting.TALK_CLOSE_MINIMUM_COOLDOWN.asInt();
        if (secondsDelta <= 0) {
            return;
        }
        long millisecondsDelta = TimeUnit.MILLISECONDS.convert(secondsDelta, TimeUnit.SECONDS);
        this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis() + millisecondsDelta);
    }

    boolean sendPage(CommandSender player, int page) {
        Paginator paginator = new Paginator().header("Current Texts").enablePageSwitcher();
        for (int i = 0; i < this.text.size(); ++i) {
            paginator.addLine(this.text.get(i) + " <green>(<click:suggest_command:edit " + i + " ><yellow>edit</click>) (<hover:show_text:Remove this text><click:run_command:/npc text remove " + i + "><red>-</click></hover>)");
        }
        return paginator.sendPage(player, page);
    }

    private boolean sendText(Player player) {
        if (this.text.size() == 0) {
            return false;
        }
        int index = 0;
        if (this.randomTalker) {
            index = RANDOM.nextInt(this.text.size());
        } else {
            if (this.currentIndex > this.text.size() - 1) {
                this.currentIndex = 0;
            }
            index = this.currentIndex++;
        }
        if (this.speechBubbles) {
            HologramTrait trait = this.npc.getOrAddTrait(HologramTrait.class);
            trait.addTemporaryLine(Placeholders.replace(this.text.get(index), (OfflinePlayer)player), Settings.Setting.DEFAULT_TEXT_SPEECH_BUBBLE_TICKS.asInt());
        } else {
            this.npc.getDefaultSpeechController().speak(new SpeechContext(this.text.get(index), (LivingEntity)player));
        }
        return true;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public void setItemInHandPattern(String pattern) {
        this.itemInHandPattern = pattern;
    }

    public void setRange(double range) {
        this.range = range;
    }

    public boolean shouldTalkClose() {
        return this.talkClose;
    }

    @Deprecated
    public boolean toggle() {
        return this.toggleTalkClose();
    }

    public boolean toggleRandomTalker() {
        this.randomTalker = !this.randomTalker;
        return this.randomTalker;
    }

    public boolean toggleRealisticLooking() {
        this.realisticLooker = !this.realisticLooker;
        return this.realisticLooker;
    }

    public boolean toggleSpeechBubbles() {
        this.speechBubbles = !this.speechBubbles;
        return this.speechBubbles;
    }

    public boolean toggleTalkClose() {
        this.talkClose = !this.talkClose;
        return this.talkClose;
    }

    public boolean useRealisticLooking() {
        return this.realisticLooker;
    }

    public boolean useSpeechBubbles() {
        return this.speechBubbles;
    }
}

