/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.shop;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.citizensnpcs.api.gui.InventoryMenuPage;
import net.citizensnpcs.api.persistence.PersistenceLoader;
import net.citizensnpcs.api.persistence.PersisterRegistry;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;

public abstract class NPCShopAction
implements Cloneable {
    private static final Map<Class<? extends NPCShopAction>, GUI> GUI = new WeakHashMap<Class<? extends NPCShopAction>, GUI>();
    private static final PersisterRegistry<NPCShopAction> REGISTRY = PersistenceLoader.createRegistry(NPCShopAction.class);

    public NPCShopAction clone() {
        try {
            return (NPCShopAction)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public abstract Transaction grant(Entity var1);

    public abstract Transaction take(Entity var1);

    public static Iterable<GUI> getGUIs() {
        return GUI.values();
    }

    public static void register(Class<? extends NPCShopAction> clazz, String type, GUI gui) {
        REGISTRY.register(type, clazz);
        GUI.put(clazz, gui);
    }

    public static class Transaction {
        private final Runnable execute;
        private final Supplier<Boolean> possible;
        private final Runnable rollback;

        public Transaction(Supplier<Boolean> isPossible, Runnable execute, Runnable rollback) {
            this.possible = isPossible;
            this.execute = execute;
            this.rollback = rollback;
        }

        public boolean isPossible() {
            return this.possible.get();
        }

        public void rollback() {
            this.rollback.run();
        }

        public void run() {
            this.execute.run();
        }

        public static Transaction create(Supplier<Boolean> isPossible, Runnable execute, Runnable rollback) {
            return new Transaction(isPossible, execute, rollback);
        }

        public static Transaction fail() {
            return new Transaction(() -> false, () -> {}, () -> {});
        }
    }

    public static interface GUI {
        public InventoryMenuPage createEditor(NPCShopAction var1, Consumer<NPCShopAction> var2);

        public ItemStack createMenuItem(NPCShopAction var1);

        public boolean manages(NPCShopAction var1);
    }
}

