/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.shop;

import com.google.common.base.Function;
import java.util.function.Consumer;
import net.citizensnpcs.api.gui.InputMenus;
import net.citizensnpcs.api.gui.InventoryMenuPage;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.trait.shop.NPCShopAction;
import net.citizensnpcs.util.Util;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;

public class MoneyAction
extends NPCShopAction {
    @Persist
    public double money;

    @Override
    public NPCShopAction.Transaction grant(Entity entity) {
        if (!(entity instanceof OfflinePlayer)) {
            return NPCShopAction.Transaction.fail();
        }
        Economy economy = (Economy)Bukkit.getServicesManager().getRegistration(Economy.class).getProvider();
        OfflinePlayer player = (OfflinePlayer)entity;
        return NPCShopAction.Transaction.create(() -> true, () -> economy.depositPlayer(player, this.money), () -> economy.withdrawPlayer(player, this.money));
    }

    @Override
    public NPCShopAction.Transaction take(Entity entity) {
        if (!(entity instanceof OfflinePlayer)) {
            return NPCShopAction.Transaction.fail();
        }
        Economy economy = (Economy)Bukkit.getServicesManager().getRegistration(Economy.class).getProvider();
        OfflinePlayer player = (OfflinePlayer)entity;
        return NPCShopAction.Transaction.create(() -> economy.has(player, this.money), () -> economy.withdrawPlayer(player, this.money), () -> economy.depositPlayer(player, this.money));
    }

    public static class MoneyActionGUI
    implements NPCShopAction.GUI {
        private Boolean supported;

        @Override
        public InventoryMenuPage createEditor(NPCShopAction previous, Consumer<NPCShopAction> callback) {
            MoneyAction action = previous == null ? new MoneyAction() : (MoneyAction)previous;
            return InputMenus.filteredStringSetter(() -> Double.toString(action.money), (Function<String, Boolean>)((Function)s -> {
                try {
                    double result = Double.parseDouble(s);
                    if (result < 0.0) {
                        return false;
                    }
                    action.money = result;
                }
                catch (NumberFormatException nfe) {
                    return false;
                }
                callback.accept(action);
                return true;
            }));
        }

        @Override
        public ItemStack createMenuItem(NPCShopAction previous) {
            if (this.supported == null) {
                try {
                    this.supported = Bukkit.getServicesManager().getRegistration(Economy.class).getProvider() != null;
                }
                catch (Throwable t) {
                    this.supported = false;
                }
            }
            if (!this.supported.booleanValue()) {
                return null;
            }
            String description = null;
            if (previous != null) {
                Economy economy = (Economy)Bukkit.getServicesManager().getRegistration(Economy.class).getProvider();
                MoneyAction old = (MoneyAction)previous;
                description = old.money + " " + economy.currencyNamePlural();
            }
            return Util.createItem(Material.GOLD_INGOT, "Money", description);
        }

        @Override
        public boolean manages(NPCShopAction action) {
            return action instanceof MoneyAction;
        }
    }
}

