/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.shop;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.citizensnpcs.api.gui.BooleanSlotHandler;
import net.citizensnpcs.api.gui.InventoryMenuPage;
import net.citizensnpcs.api.gui.InventoryMenuSlot;
import net.citizensnpcs.api.gui.Menu;
import net.citizensnpcs.api.gui.MenuContext;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.trait.shop.NPCShopAction;
import net.citizensnpcs.util.Util;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;

public class ItemAction
extends NPCShopAction {
    @Persist
    public List<ItemStack> items = Lists.newArrayList();
    @Persist
    public boolean requireUndamaged = true;

    public ItemAction() {
    }

    public ItemAction(ItemStack ... items) {
        this(Arrays.asList(items));
    }

    public ItemAction(List<ItemStack> items) {
        this.items = items;
    }

    private boolean containsItems(Inventory source, BiFunction<ItemStack, Integer, ItemStack> filter) {
        Map<Material, Integer> required = this.items.stream().collect(Collectors.toMap(k -> k.getType(), v -> v.getAmount()));
        ItemStack[] contents = source.getContents();
        for (int i = 0; i < contents.length; ++i) {
            ItemStack stack = contents[i];
            if (stack == null || stack.getType() == Material.AIR || !required.containsKey(stack.getType()) || this.requireUndamaged && stack.getItemMeta() instanceof Damageable && ((Damageable)stack.getItemMeta()).getDamage() != 0) continue;
            int remaining = required.remove(stack.getType());
            int taken = stack.getAmount() > remaining ? remaining : stack.getAmount();
            ItemStack res = filter.apply(stack, taken);
            if (res == null) {
                source.clear(i);
            } else {
                source.setItem(i, res);
            }
            if (remaining - taken <= 0) continue;
            required.put(stack.getType(), remaining - taken);
        }
        return required.size() == 0;
    }

    @Override
    public NPCShopAction.Transaction grant(Entity entity) {
        if (!(entity instanceof InventoryHolder)) {
            return NPCShopAction.Transaction.fail();
        }
        Inventory source = ((InventoryHolder)entity).getInventory();
        return NPCShopAction.Transaction.create(() -> {
            int free = 0;
            for (ItemStack stack : source.getContents()) {
                if (stack != null && stack.getType() != Material.AIR) continue;
                ++free;
            }
            return free >= this.items.size();
        }, () -> source.addItem(this.items.toArray(new ItemStack[this.items.size()])), () -> source.removeItem(this.items.toArray(new ItemStack[this.items.size()])));
    }

    @Override
    public NPCShopAction.Transaction take(Entity entity) {
        if (!(entity instanceof InventoryHolder)) {
            return NPCShopAction.Transaction.fail();
        }
        Inventory source = ((InventoryHolder)entity).getInventory();
        return NPCShopAction.Transaction.create(() -> {
            boolean contains = this.containsItems(source, (s, t) -> s);
            for (ItemStack item : this.items) {
                if (!item.hasItemMeta() || source.contains(item)) continue;
                contains = false;
            }
            return contains;
        }, () -> this.containsItems(source, (stack, taken) -> {
            if (stack.getAmount() == taken.intValue()) {
                return null;
            }
            stack.setAmount(stack.getAmount() - taken);
            return stack;
        }), () -> source.addItem(this.items.toArray(new ItemStack[this.items.size()])));
    }

    public static class ItemActionGUI
    implements NPCShopAction.GUI {
        @Override
        public InventoryMenuPage createEditor(NPCShopAction previous, Consumer<NPCShopAction> callback) {
            return new ItemActionEditor(previous == null ? new ItemAction() : null, callback);
        }

        @Override
        public ItemStack createMenuItem(NPCShopAction previous) {
            String description = null;
            if (previous != null) {
                ItemAction old = (ItemAction)previous;
                description = old.items.size() + " items";
                for (int i = 0; i < old.items.size(); ++i) {
                    ItemStack item = old.items.get(i);
                    description = description + "\n" + item.getAmount() + " " + Util.prettyEnum(item.getType());
                    if (i != 3) continue;
                    description = description + "...";
                    break;
                }
            }
            return Util.createItem(Material.CHEST, "Item", description);
        }

        @Override
        public boolean manages(NPCShopAction action) {
            return action instanceof ItemAction;
        }
    }

    @Menu(title="Item editor", dimensions={4, 9})
    public static class ItemActionEditor
    extends InventoryMenuPage {
        private ItemAction base;
        private Consumer<NPCShopAction> callback;
        private MenuContext ctx;

        public ItemActionEditor() {
        }

        public ItemActionEditor(ItemAction base, Consumer<NPCShopAction> callback) {
            this.base = base;
            this.callback = callback;
        }

        @Override
        public void initialise(MenuContext ctx) {
            this.ctx = ctx;
            for (int i = 0; i < 27; ++i) {
                InventoryMenuSlot slot = ctx.getSlot(i);
                slot.clear();
                if (this.base != null && i < this.base.items.size()) {
                    slot.setItemStack(this.base.items.get(i).clone());
                }
                slot.setClickHandler(event -> {
                    event.setCancelled(true);
                    event.setCurrentItem(event.getCursorNonNull());
                });
            }
            ctx.getSlot(28).setItemStack(new ItemStack(Material.ANVIL), "Must have no damage");
            ctx.getSlot(28).addClickHandler(new BooleanSlotHandler((Function<Boolean, String>)((Function)res -> {
                this.base.requireUndamaged = res;
                return res != false ? ChatColor.GREEN + "On" : ChatColor.RED + "Off";
            }), this.base == null ? false : this.base.requireUndamaged));
        }

        @Override
        public void onClose(HumanEntity player) {
            ArrayList items = Lists.newArrayList();
            for (int i = 0; i < 27; ++i) {
                if (this.ctx.getSlot(i).getCurrentItem() == null) continue;
                items.add(this.ctx.getSlot(i).getCurrentItem().clone());
            }
            this.callback.accept(items.isEmpty() ? null : new ItemAction(items));
        }
    }
}

