/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import org.bukkit.DyeColor;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Wolf;

@TraitName(value="wolfmodifiers")
public class WolfModifiers
extends Trait {
    @Persist(value="angry")
    private boolean angry;
    @Persist(value="collarColor")
    private DyeColor collarColor = DyeColor.RED;
    @Persist(value="sitting")
    private boolean sitting;
    @Persist(value="tamed")
    private boolean tamed;

    public WolfModifiers() {
        super("wolfmodifiers");
    }

    public DyeColor getCollarColor() {
        return this.collarColor;
    }

    public boolean isAngry() {
        return this.angry;
    }

    public boolean isSitting() {
        return this.sitting;
    }

    public boolean isTamed() {
        return this.tamed;
    }

    @Override
    public void onSpawn() {
        this.updateModifiers();
    }

    public void setAngry(boolean angry) {
        this.angry = angry;
        this.updateModifiers();
    }

    public void setCollarColor(DyeColor color) {
        this.collarColor = color;
        this.updateModifiers();
    }

    public void setSitting(boolean sitting) {
        this.sitting = sitting;
        this.updateModifiers();
    }

    public void setTamed(boolean tamed) {
        this.tamed = tamed;
        this.updateModifiers();
    }

    private void updateModifiers() {
        if (this.npc.getEntity() instanceof Wolf) {
            Wolf wolf = (Wolf)this.npc.getEntity();
            wolf.setCollarColor(this.collarColor);
            wolf.setSitting(this.sitting);
            wolf.setAngry(this.angry);
            if (this.angry) {
                wolf.setTarget((LivingEntity)wolf);
            }
            wolf.setTamed(this.tamed);
        }
    }
}

