/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.persistence.Persistable;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

@TraitName(value="smoothrotationtrait")
public class SmoothRotationTrait
extends Trait {
    @Persist
    private Float defaultPitch;
    @Persist(reify=true)
    private final RotationParams globalParameters = new RotationParams();
    private final SmoothRotationSession globalSession = new SmoothRotationSession(this.globalParameters);

    public SmoothRotationTrait() {
        super("smoothrotationtrait");
    }

    private double getEyeY() {
        return NMS.getHeight(this.npc.getEntity());
    }

    public RotationParams getGlobalParameters() {
        return this.globalParameters;
    }

    private double getX() {
        return this.npc.getStoredLocation().getX();
    }

    private double getY() {
        return this.npc.getStoredLocation().getY();
    }

    private double getZ() {
        return this.npc.getStoredLocation().getZ();
    }

    public void rotateToFace(Entity target) {
        Location loc = target.getLocation();
        loc.setY(loc.getY() + NMS.getHeight(target));
        this.rotateToFace(loc);
    }

    public void rotateToFace(Location target) {
        this.globalSession.setTarget(target);
    }

    public void rotateToHave(float yaw, float pitch) {
        double pitchCos = Math.cos(Math.toRadians(pitch));
        Vector vector = new Vector(Math.sin(Math.toRadians(yaw)) * -pitchCos, -Math.sin(Math.toRadians(pitch)), Math.cos(Math.toRadians(yaw)) * pitchCos).normalize();
        this.rotateToFace(this.npc.getStoredLocation().clone().add(vector));
    }

    @Override
    public void run() {
        if (!this.npc.isSpawned() || this.npc.getNavigator().isNavigating()) {
            return;
        }
        if (!this.globalSession.hasTarget()) {
            return;
        }
        EntityRotation rot = new EntityRotation(this.npc.getEntity());
        this.globalSession.run(rot);
        if (!this.globalSession.hasTarget()) {
            rot.bodyYaw = rot.headYaw;
        }
        rot.apply(this.npc.getEntity());
    }

    public void setDefaultPitch(float pitch) {
        this.defaultPitch = Float.valueOf(pitch);
    }

    private static float clamp(float orig, float min, float max) {
        return Math.max(min, Math.min(max, orig));
    }

    public static class RotationParams
    implements Persistable,
    Cloneable {
        private boolean headOnly = false;
        private boolean immediate = false;
        private float maxPitchPerTick = 10.0f;
        private float maxYawPerTick = 40.0f;
        private float[] pitchRange = new float[]{-180.0f, 180.0f};
        private float[] yawRange = new float[]{-180.0f, 180.0f};

        public RotationParams clone() {
            try {
                return (RotationParams)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        public RotationParams headOnly(boolean headOnly) {
            this.headOnly = headOnly;
            return this;
        }

        public RotationParams immediate(boolean immediate) {
            this.immediate = immediate;
            return this;
        }

        @Override
        public void load(DataKey key) {
            String[] parts;
            if (key.keyExists("headOnly")) {
                this.headOnly = key.getBoolean("headOnly");
            }
            if (key.keyExists("immediate")) {
                this.immediate = key.getBoolean("immediate");
            }
            if (key.keyExists("maxPitchPerTick")) {
                this.maxPitchPerTick = (float)key.getDouble("maxPitchPerTick");
            }
            if (key.keyExists("maxYawPerTick")) {
                this.maxYawPerTick = (float)key.getDouble("maxYawPerTick");
            }
            if (key.keyExists("yawRange")) {
                parts = key.getString("yawRange").split(",");
                this.yawRange = new float[]{Float.parseFloat(parts[0]), Float.parseFloat(parts[1])};
            }
            if (key.keyExists("pitchRange")) {
                parts = key.getString("pitchRange").split(",");
                this.pitchRange = new float[]{Float.parseFloat(parts[0]), Float.parseFloat(parts[1])};
            }
        }

        public RotationParams maxPitchPerTick(float val) {
            this.maxPitchPerTick = val;
            return this;
        }

        public RotationParams maxYawPerTick(float val) {
            this.maxYawPerTick = val;
            return this;
        }

        public RotationParams pitchRange(float[] val) {
            this.pitchRange = val;
            return this;
        }

        public float rotateHeadYawTowards(int t, float yaw, float targetYaw) {
            float out = this.rotateTowards(yaw, targetYaw, this.maxYawPerTick);
            return Util.clamp(out, this.yawRange[0], this.yawRange[1], 360.0f);
        }

        public float rotatePitchTowards(int t, float pitch, float targetPitch) {
            float out = this.rotateTowards(pitch, targetPitch, this.maxPitchPerTick);
            return Util.clamp(out, this.pitchRange[0], this.pitchRange[1], 360.0f);
        }

        private float rotateTowards(float target, float current, float maxRotPerTick) {
            float diff = Util.clamp(current - target);
            return target + SmoothRotationTrait.clamp(diff, -maxRotPerTick, maxRotPerTick);
        }

        @Override
        public void save(DataKey key) {
            if (this.headOnly) {
                key.setBoolean("headOnly", this.headOnly);
            }
            if (this.immediate) {
                key.setBoolean("immediate", this.immediate);
            }
            if (this.maxPitchPerTick != 10.0f) {
                key.setDouble("maxPitchPerTick", this.maxPitchPerTick);
            } else {
                key.removeKey("maxPitchPerTick");
            }
            if (this.maxYawPerTick != 40.0f) {
                key.setDouble("maxYawPerTick", this.maxYawPerTick);
            } else {
                key.removeKey("maxYawPerTick");
            }
            if (this.pitchRange[0] != -180.0f || this.pitchRange[1] != 180.0f) {
                key.setString("pitchRange", this.pitchRange[0] + "," + this.pitchRange[1]);
            } else {
                key.removeKey("pitchRange");
            }
            if (this.yawRange[0] != -180.0f || this.yawRange[1] != 180.0f) {
                key.setString("yawRange", this.yawRange[0] + "," + this.yawRange[1]);
            } else {
                key.removeKey("yawRange");
            }
        }

        public RotationParams yawRange(float[] val) {
            this.yawRange = val;
            return this;
        }
    }

    public class SmoothRotationSession {
        private final RotationParams params;
        private int t = -1;
        private double tx;
        private double ty;
        private double tz;

        public SmoothRotationSession(RotationParams params) {
            this.params = params;
        }

        public float getTargetPitch() {
            double dx = this.tx - SmoothRotationTrait.this.getX();
            double dy = this.ty - (SmoothRotationTrait.this.getY() + SmoothRotationTrait.this.getEyeY());
            double dz = this.tz - SmoothRotationTrait.this.getZ();
            double diag = Math.sqrt((float)(dx * dx + dz * dz));
            return (float)(-Math.toDegrees(Math.atan2(dy, diag)));
        }

        public double getTargetX() {
            return this.tx;
        }

        public double getTargetY() {
            return this.ty;
        }

        public float getTargetYaw() {
            return (float)Math.toDegrees(Math.atan2(this.tz - SmoothRotationTrait.this.getZ(), this.tx - SmoothRotationTrait.this.getX())) - 90.0f;
        }

        public double getTargetZ() {
            return this.tz;
        }

        public boolean hasTarget() {
            return this.t >= 0;
        }

        public void run(EntityRotation rot) {
            if (!this.hasTarget()) {
                return;
            }
            float f = rot.headYaw = this.params.immediate ? this.getTargetYaw() : Util.clamp(this.params.rotateHeadYawTowards(this.t, rot.headYaw, this.getTargetYaw()));
            if (!this.params.headOnly) {
                float d = Util.clamp(rot.headYaw - 35.0f);
                if (d > rot.bodyYaw) {
                    rot.bodyYaw = d;
                }
                if (d != rot.bodyYaw && (d = Util.clamp(rot.headYaw + 35.0f)) < rot.bodyYaw) {
                    rot.bodyYaw = d;
                }
            }
            rot.pitch = this.params.immediate ? this.getTargetPitch() : this.params.rotatePitchTowards(this.t, rot.pitch, this.getTargetPitch());
            ++this.t;
            if ((double)(Math.abs(rot.pitch - this.getTargetPitch()) + Math.abs(rot.headYaw - this.getTargetYaw())) < 0.1) {
                this.t = -1;
            }
        }

        public void setTarget(Location target) {
            this.tx = target.getX();
            this.ty = target.getY();
            this.tz = target.getZ();
            this.t = 0;
        }
    }

    private static class EntityRotation {
        public float bodyYaw;
        public float headYaw;
        public float pitch;

        public EntityRotation(Entity entity) {
            this.bodyYaw = NMS.getYaw(entity);
            this.headYaw = NMS.getHeadYaw(entity);
            this.pitch = entity.getLocation().getPitch();
        }

        public void apply(Entity entity) {
            NMS.setBodyYaw(entity, this.bodyYaw);
            NMS.setHeadYaw(entity, this.headYaw);
            NMS.setPitch(entity, this.pitch);
        }
    }
}

