/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.util.NMS;
import org.bukkit.Location;
import org.bukkit.block.Bed;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.player.PlayerTeleportEvent;

@TraitName(value="sleeptrait")
public class SleepTrait
extends Trait {
    @Persist
    private Location at;
    private boolean sleeping;

    public SleepTrait() {
        super("sleeptrait");
    }

    @Override
    public void onDespawn() {
        this.sleeping = false;
    }

    @Override
    public void run() {
        if (!this.npc.isSpawned()) {
            return;
        }
        if (this.sleeping) {
            if (this.at == null) {
                this.wakeup();
            }
            return;
        }
        if (this.at == null) {
            return;
        }
        this.npc.teleport(this.at, PlayerTeleportEvent.TeleportCause.PLUGIN);
        if (this.npc.getEntity() instanceof Player) {
            Player player = (Player)this.npc.getEntity();
            if (this.at.getBlock().getBlockData() instanceof Bed || this.at.getBlock().getState() instanceof Bed) {
                player.sleep(this.at, true);
            } else {
                NMS.sleep(player, true);
            }
            this.sleeping = true;
        } else if (this.npc.getEntity() instanceof Villager) {
            this.sleeping = ((Villager)this.npc.getEntity()).sleep(this.at);
        }
    }

    public void setSleeping(Location at) {
        this.at = at != null ? at.clone() : null;
        this.wakeup();
    }

    private void wakeup() {
        if (this.npc.getEntity() instanceof Player) {
            NMS.sleep((Player)this.npc.getEntity(), false);
        } else if (this.npc.getEntity() instanceof Villager) {
            ((Villager)this.npc.getEntity()).wakeup();
        }
        this.sleeping = false;
    }
}

