/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.MemoryNPCDataStore;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.trait.ArmorStandTrait;
import net.citizensnpcs.util.NMS;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;

@TraitName(value="sittrait")
public class SitTrait
extends Trait {
    private NPC holder;
    @Persist
    private Location sittingAt;

    public SitTrait() {
        super("sittrait");
    }

    public boolean isSitting() {
        return this.sittingAt != null;
    }

    @Override
    public void onDespawn() {
        if (this.holder != null) {
            this.holder.destroy();
            this.holder = null;
        }
    }

    @Override
    public void run() {
        if (!this.npc.isSpawned() || !this.isSitting()) {
            return;
        }
        if (this.holder == null) {
            NPCRegistry registry = CitizensAPI.getNamedNPCRegistry("PlayerAnimationImpl");
            if (registry == null) {
                registry = CitizensAPI.createNamedNPCRegistry("PlayerAnimationImpl", new MemoryNPCDataStore());
            }
            this.holder = registry.createNPC(EntityType.ARMOR_STAND, "");
            this.holder.getOrAddTrait(ArmorStandTrait.class).setAsHelperEntity(this.npc);
            this.holder.spawn(this.sittingAt);
        }
        if (this.holder.getEntity() != null && !NMS.getPassengers(this.holder.getEntity()).contains(this.npc.getEntity())) {
            NMS.mount(this.holder.getEntity(), this.npc.getEntity());
        }
    }

    public void setSitting(Location at) {
        Location location = this.sittingAt = at != null ? at.clone() : null;
        if (!this.isSitting()) {
            this.onDespawn();
        }
    }
}

