/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.gui.CitizensInventoryClickEvent;
import net.citizensnpcs.api.gui.ClickHandler;
import net.citizensnpcs.api.gui.InputMenus;
import net.citizensnpcs.api.gui.InventoryMenu;
import net.citizensnpcs.api.gui.InventoryMenuPage;
import net.citizensnpcs.api.gui.InventoryMenuPattern;
import net.citizensnpcs.api.gui.InventoryMenuSlot;
import net.citizensnpcs.api.gui.Menu;
import net.citizensnpcs.api.gui.MenuContext;
import net.citizensnpcs.api.gui.MenuPattern;
import net.citizensnpcs.api.gui.MenuSlot;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.persistence.PersistenceLoader;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Colorizer;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Placeholders;
import net.citizensnpcs.trait.shop.ItemAction;
import net.citizensnpcs.trait.shop.MoneyAction;
import net.citizensnpcs.trait.shop.NPCShopAction;
import net.citizensnpcs.trait.shop.PermissionAction;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@TraitName(value="shop")
public class ShopTrait
extends Trait {
    private static StoredShops SAVED = new StoredShops();

    public ShopTrait() {
        super("shop");
    }

    public NPCShop getDefaultShop() {
        return StoredShops.NPC_SHOPS.computeIfAbsent(this.npc.getUniqueId().toString(), x$0 -> new NPCShop((String)x$0));
    }

    public NPCShop getShop(String name) {
        return StoredShops.GLOBAL_SHOPS.computeIfAbsent(name, x$0 -> new NPCShop((String)x$0));
    }

    public void onRightClick(Player player) {
        NPCShop shop = this.getDefaultShop();
        if (shop.openOnRightClick) {
            shop.display(player);
        }
    }

    public static void loadShops(DataKey root) {
        SAVED = (StoredShops)((Object)PersistenceLoader.load(StoredShops.class, root));
    }

    public static void saveShops(DataKey root) {
        PersistenceLoader.save(SAVED, root);
    }

    static {
        NPCShopAction.register(ItemAction.class, "items", new ItemAction.ItemActionGUI());
        NPCShopAction.register(PermissionAction.class, "permissions", new PermissionAction.PermissionActionGUI());
        NPCShopAction.register(MoneyAction.class, "money", new MoneyAction.MoneyActionGUI());
    }

    private static class StoredShops {
        @Persist(value="global", reify=true)
        private static Map<String, NPCShop> GLOBAL_SHOPS = Maps.newHashMap();
        @Persist(value="npc", reify=true)
        private static Map<String, NPCShop> NPC_SHOPS = Maps.newHashMap();

        private StoredShops() {
        }
    }

    public static class NPCShop {
        @Persist(value="")
        private String name;
        @Persist
        private boolean openOnRightClick;
        @Persist(reify=true)
        private final List<NPCShopPage> pages = Lists.newArrayList();
        @Persist
        private String title;
        @Persist
        private ShopType type = ShopType.COMMAND;
        @Persist
        private String viewPermission;

        private NPCShop() {
        }

        private NPCShop(String name) {
            this.name = name;
        }

        public void display(Player sender) {
            if (this.viewPermission != null && !sender.hasPermission(this.viewPermission)) {
                return;
            }
            if (this.pages.size() == 0) {
                sender.sendMessage(ChatColor.RED + "Empty shop");
                return;
            }
            InventoryMenu.createSelfRegistered(new NPCShopViewer(this, sender)).present((HumanEntity)sender);
        }

        public void displayEditor(Player sender) {
            InventoryMenu.createSelfRegistered(new NPCShopSettings(this)).present((HumanEntity)sender);
        }

        public String getName() {
            return this.name;
        }

        public NPCShopPage getOrCreatePage(int page) {
            while (this.pages.size() <= page) {
                this.pages.add(new NPCShopPage(page));
            }
            return this.pages.get(page);
        }

        public String getRequiredPermission() {
            return this.viewPermission;
        }

        public void removePage(int index) {
            for (int i = 0; i < this.pages.size(); ++i) {
                if (this.pages.get(i).index == index) {
                    this.pages.remove(i--);
                    index = -1;
                    continue;
                }
                if (index != -1) continue;
                this.pages.get(i).index--;
            }
        }

        public void setPermission(String permission) {
            this.viewPermission = permission;
            if (this.viewPermission != null && this.viewPermission.isEmpty()) {
                this.viewPermission = null;
            }
        }
    }

    public static enum ShopType {
        BUY,
        COMMAND,
        SELL;

    }

    @Menu(title="Shop", type=InventoryType.CHEST, dimensions={5, 9})
    public static class NPCShopViewer
    extends InventoryMenuPage {
        private MenuContext ctx;
        private int currentPage = 0;
        private final Player player;
        private final NPCShop shop;

        public NPCShopViewer(NPCShop shop, Player player) {
            this.shop = shop;
            this.player = player;
        }

        public void changePage(int newPage) {
            this.currentPage = newPage;
            NPCShopPage page = (NPCShopPage)this.shop.pages.get(this.currentPage);
            if (page.title != null && !page.title.isEmpty()) {
                Bukkit.getScheduler().runTaskLater(CitizensAPI.getPlugin(), () -> this.ctx.setTitle(Placeholders.replace(page.title, (OfflinePlayer)this.player)), 1L);
            }
            for (int i = 0; i < this.ctx.getInventory().getSize(); ++i) {
                this.ctx.getSlot(i).clear();
                NPCShopItem item = page.getItem(i);
                if (item == null) continue;
                this.ctx.getSlot(i).setItemStack(item.getDisplayItem(this.player));
                this.ctx.getSlot(i).setClickHandler(evt -> {
                    evt.setCancelled(true);
                    item.onClick(this.shop, (CitizensInventoryClickEvent)((Object)evt));
                });
            }
            InventoryMenuSlot prev = this.ctx.getSlot(39);
            InventoryMenuSlot next = this.ctx.getSlot(41);
            prev.clear();
            if (this.currentPage > 0) {
                prev.setItemStack(new ItemStack(Material.FEATHER, 1), "Previous page (" + this.currentPage + ")");
                prev.setClickHandler(evt -> {
                    evt.setCancelled(true);
                    this.changePage(this.currentPage - 1);
                });
            }
            next.clear();
            if (this.currentPage + 1 < this.shop.pages.size()) {
                next.setItemStack(new ItemStack(Material.FEATHER, 1), "Next page (" + (this.currentPage + 1) + ")");
                next.setClickHandler(evt -> {
                    evt.setCancelled(true);
                    this.changePage(this.currentPage + 1);
                });
            }
        }

        @Override
        public Inventory createInventory(String title) {
            return Bukkit.createInventory(null, (int)45, (String)(this.shop.title == null || this.shop.title.isEmpty() ? "Shop" : Placeholders.replace(this.shop.title, (OfflinePlayer)this.player)));
        }

        @Override
        public void initialise(MenuContext ctx) {
            this.ctx = ctx;
            this.changePage(this.currentPage);
        }
    }

    @Menu(title="NPC Shop Editor", type=InventoryType.CHEST, dimensions={1, 9})
    public static class NPCShopSettings
    extends InventoryMenuPage {
        private MenuContext ctx;
        private final NPCShop shop;

        public NPCShopSettings(NPCShop shop) {
            this.shop = shop;
        }

        @Override
        public void initialise(MenuContext ctx) {
            this.ctx = ctx;
            ctx.getSlot(2).setDescription("<f>Edit shop view permission<br>" + this.shop.getRequiredPermission());
            ctx.getSlot(6).setDescription("<f>Edit shop title<br>" + this.shop.title);
            ctx.getSlot(8).setDescription("<f>Show shop on right click<br>" + this.shop.openOnRightClick);
        }

        @MenuSlot(slot={0, 4}, material=Material.FEATHER, amount=1, title="<f>Edit shop items")
        public void onEditItems(InventoryMenuSlot slot, CitizensInventoryClickEvent event) {
            event.setCancelled(true);
            this.ctx.getMenu().transition(new NPCShopContentsEditor(this.shop));
        }

        @MenuSlot(slot={0, 2}, material=Material.OAK_SIGN, amount=1)
        public void onPermissionChange(InventoryMenuSlot slot, CitizensInventoryClickEvent event) {
            event.setCancelled(true);
            this.ctx.getMenu().transition(InputMenus.stringSetter(this.shop::getRequiredPermission, this.shop::setPermission));
        }

        @MenuSlot(slot={0, 6}, material=Material.NAME_TAG, amount=1)
        public void onSetTitle(InventoryMenuSlot slot, CitizensInventoryClickEvent event) {
            event.setCancelled(true);
            this.ctx.getMenu().transition(InputMenus.stringSetter(() -> this.shop.title, newTitle -> this.shop.title = newTitle.isEmpty() ? null : newTitle));
        }

        @MenuSlot(slot={0, 0}, material=Material.BOOK, amount=1, title="<f>Edit shop type")
        public void onShopTypeChange(InventoryMenuSlot slot, CitizensInventoryClickEvent event) {
            event.setCancelled(true);
            this.ctx.getMenu().transition(InputMenus.picker("Edit shop type", chosen -> this.shop.type = (ShopType)((Object)((Object)chosen.getValue())), InputMenus.Choice.of(ShopType.BUY, Material.DIAMOND, "Players buy items", this.shop.type == ShopType.BUY), InputMenus.Choice.of(ShopType.SELL, Material.EMERALD, "Players sell items", this.shop.type == ShopType.SELL), InputMenus.Choice.of(ShopType.COMMAND, Material.ENDER_EYE, "Clicks trigger commands only", this.shop.type == ShopType.COMMAND)));
        }

        @MenuSlot(slot={0, 8}, material=Material.COMMAND_BLOCK, amount=1)
        public void onToggleRightClick(InventoryMenuSlot slot, CitizensInventoryClickEvent event) {
            event.setCancelled(true);
            this.shop.openOnRightClick = !this.shop.openOnRightClick;
            this.ctx.getSlot(8).setDescription("<f>Show shop on right click<br>" + this.shop.openOnRightClick);
        }
    }

    @Menu(title="NPC Shop Page Editor", type=InventoryType.CHEST, dimensions={5, 9})
    public static class NPCShopPageSettings
    extends InventoryMenuPage {
        private MenuContext ctx;
        private final NPCShopPage page;

        public NPCShopPageSettings(NPCShopPage page) {
            this.page = page;
        }

        @MenuSlot(slot={0, 4}, material=Material.FEATHER, amount=1)
        public void editPageTitle(InventoryMenuSlot slot, CitizensInventoryClickEvent event) {
            event.setCancelled(true);
            this.ctx.getMenu().transition(InputMenus.stringSetter(() -> this.page.title, newTitle -> this.page.title = newTitle.isEmpty() ? null : newTitle));
        }

        @Override
        public void initialise(MenuContext ctx) {
            this.ctx = ctx;
            ctx.getSlot(4).setDescription("Set page title<br>Currently: " + this.page.title);
        }

        @MenuSlot(slot={4, 4}, material=Material.TNT, amount=1, title="<c>Remove page")
        public void removePage(InventoryMenuSlot slot, CitizensInventoryClickEvent event) {
            event.setCancelled(true);
            this.ctx.data().put("removePage", this.page.index);
            this.ctx.getMenu().transitionBack();
        }
    }

    public static class NPCShopPage {
        @Persist(value="$key")
        private int index;
        @Persist(keyType=Integer.class, reify=true)
        private final Map<Integer, NPCShopItem> items = Maps.newHashMap();
        @Persist
        private String title;

        private NPCShopPage() {
        }

        public NPCShopPage(int page) {
            this.index = page;
        }

        public NPCShopItem getItem(int idx) {
            return this.items.get(idx);
        }

        public void removeItem(int idx) {
            this.items.remove(idx);
        }

        public void setItem(int idx, NPCShopItem modified) {
            this.items.put(idx, modified);
        }
    }

    @Menu(title="NPC Shop Item Editor", type=InventoryType.CHEST, dimensions={6, 9})
    @MenuSlot(slot={3, 4}, material=Material.DISPENSER, amount=1, title="<f>Place display item below")
    public static class NPCShopItemEditor
    extends InventoryMenuPage {
        @MenuPattern(offset={0, 6}, slots={@MenuSlot(pat=120, material=Material.AIR)}, value="x x\n x \nx x")
        private InventoryMenuPattern actionItems;
        private final Consumer<NPCShopItem> callback;
        @MenuPattern(offset={0, 0}, slots={@MenuSlot(pat=120, material=Material.AIR)}, value="x x\n x \nx x")
        private InventoryMenuPattern costItems;
        private MenuContext ctx;
        private final NPCShopItem modified;
        private NPCShopItem original;

        public NPCShopItemEditor(NPCShopItem item, Consumer<NPCShopItem> consumer) {
            this.original = item;
            this.modified = this.original.clone();
            this.callback = consumer;
        }

        @Override
        public void initialise(MenuContext ctx) {
            this.ctx = ctx;
            if (this.modified.display != null) {
                ctx.getSlot(40).setItemStack(this.modified.display);
            }
            int pos = 0;
            for (NPCShopAction.GUI template : NPCShopAction.getGUIs()) {
                if (template.createMenuItem(null) == null) continue;
                NPCShopAction oldCost = this.modified.cost.stream().filter(template::manages).findFirst().orElse(null);
                this.costItems.getSlots().get(pos).setItemStack(Util.editTitle(template.createMenuItem(oldCost), title -> title + " Cost"));
                this.costItems.getSlots().get(pos).setClickHandler(event -> {
                    event.setCancelled(true);
                    ctx.getMenu().transition(template.createEditor(oldCost, cost -> this.modified.changeCost(template::manages, (NPCShopAction)cost)));
                });
                NPCShopAction oldResult = this.modified.result.stream().filter(template::manages).findFirst().orElse(null);
                this.actionItems.getSlots().get(pos).setItemStack(Util.editTitle(template.createMenuItem(oldResult), title -> title + " Result"));
                this.actionItems.getSlots().get(pos).setClickHandler(event -> {
                    event.setCancelled(true);
                    ctx.getMenu().transition(template.createEditor(oldResult, result -> this.modified.changeResult(template::manages, (NPCShopAction)result)));
                });
                ++pos;
            }
        }

        @MenuSlot(slot={5, 3}, material=Material.REDSTONE_BLOCK, amount=1, title="<7>Cancel")
        public void onCancel(InventoryMenuSlot slot, CitizensInventoryClickEvent event) {
            event.setCancelled(true);
            this.ctx.getMenu().transitionBack();
        }

        @Override
        public void onClose(HumanEntity who) {
            if (this.original != null && this.original.display == null) {
                this.original = null;
            }
            this.callback.accept(this.original);
        }

        @MenuSlot(slot={4, 5}, material=Material.BOOK, amount=1, title="<f>Set description")
        public void onEditDescription(InventoryMenuSlot slot, CitizensInventoryClickEvent event) {
            event.setCancelled(true);
            if (this.modified.display == null) {
                return;
            }
            this.ctx.getMenu().transition(InputMenus.stringSetter(() -> this.modified.display.getItemMeta().hasLore() ? Joiner.on((String)"<br>").skipNulls().join((Iterable)this.modified.display.getItemMeta().getLore()) : "", description -> {
                ItemMeta meta = this.modified.display.getItemMeta();
                meta.setLore((List)Lists.newArrayList((Iterable)Splitter.on((String)"<br>").split((CharSequence)Colorizer.parseColors(description))));
                this.modified.display.setItemMeta(meta);
            }));
        }

        @MenuSlot(slot={4, 3}, material=Material.FEATHER, amount=1, title="<f>Set name")
        public void onEditName(InventoryMenuSlot slot, CitizensInventoryClickEvent event) {
            event.setCancelled(true);
            if (this.modified.display == null) {
                return;
            }
            this.ctx.getMenu().transition(InputMenus.stringSetter(() -> ((ItemMeta)this.modified.display.getItemMeta()).getDisplayName(), name -> {
                ItemMeta meta = this.modified.display.getItemMeta();
                meta.setDisplayName(ChatColor.RESET + Colorizer.parseColors(name));
                this.modified.display.setItemMeta(meta);
            }));
        }

        @ClickHandler(slot={4, 4})
        public void onModifyDisplayItem(InventoryMenuSlot slot, CitizensInventoryClickEvent event) {
            event.setCancelled(true);
            if (event.getCursor() != null) {
                event.setCurrentItem(event.getCursor());
                this.modified.display = event.getCursor().clone();
            } else {
                event.setCurrentItem(null);
                this.modified.display = null;
            }
        }

        @MenuSlot(slot={5, 4}, material=Material.TNT, amount=1, title="<c>Remove")
        public void onRemove(InventoryMenuSlot slot, CitizensInventoryClickEvent event) {
            this.original = null;
            event.setCancelled(true);
            this.ctx.getMenu().transitionBack();
        }

        @MenuSlot(slot={5, 5}, material=Material.EMERALD_BLOCK, amount=1, title="<a>Save")
        public void onSave(InventoryMenuSlot slot, CitizensInventoryClickEvent event) {
            this.original = this.modified;
            event.setCancelled(true);
            this.ctx.getMenu().transitionBack();
        }
    }

    public static class NPCShopItem
    implements Cloneable {
        @Persist
        private final List<NPCShopAction> cost = Lists.newArrayList();
        @Persist
        private ItemStack display;
        @Persist
        private final List<NPCShopAction> result = Lists.newArrayList();

        private void changeAction(List<NPCShopAction> source, Function<NPCShopAction, Boolean> filter, NPCShopAction delta) {
            for (int i = 0; i < source.size(); ++i) {
                if (!filter.apply(source.get(i)).booleanValue()) continue;
                if (delta == null) {
                    source.remove(i);
                } else {
                    source.set(i, delta);
                }
                return;
            }
            if (delta != null) {
                source.add(delta);
            }
        }

        public void changeCost(Function<NPCShopAction, Boolean> filter, NPCShopAction cost) {
            this.changeAction(this.cost, filter, cost);
        }

        public void changeResult(Function<NPCShopAction, Boolean> filter, NPCShopAction result) {
            this.changeAction(this.result, filter, result);
        }

        public NPCShopItem clone() {
            try {
                return (NPCShopItem)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new Error(e);
            }
        }

        public List<NPCShopAction.Transaction> execute(List<NPCShopAction> actions, Function<NPCShopAction, NPCShopAction.Transaction> func) {
            ArrayList pending = Lists.newArrayList();
            for (NPCShopAction action : actions) {
                NPCShopAction.Transaction take = func.apply(action);
                if (!take.isPossible()) {
                    pending.forEach(a -> a.rollback());
                    return null;
                }
                take.run();
                pending.add(take);
            }
            return pending;
        }

        public ItemStack getDisplayItem(Player player) {
            if (this.display == null) {
                return null;
            }
            ItemStack stack = this.display.clone();
            ItemMeta meta = stack.getItemMeta();
            if (meta.hasDisplayName()) {
                meta.setDisplayName(Placeholders.replace(meta.getDisplayName(), (OfflinePlayer)player));
            }
            if (meta.hasLore()) {
                meta.setLore(Lists.transform((List)meta.getLore(), line -> Placeholders.replace(line, (OfflinePlayer)player)));
            }
            stack.setItemMeta(meta);
            return stack;
        }

        public void onClick(NPCShop shop, CitizensInventoryClickEvent event) {
            if (shop.type == ShopType.COMMAND) {
                return;
            }
            List<NPCShopAction.Transaction> take = this.execute(this.cost, action -> action.take((Entity)event.getWhoClicked()));
            if (take == null) {
                return;
            }
            if (this.execute(this.result, action -> action.grant((Entity)event.getWhoClicked())) == null) {
                take.forEach(a -> a.rollback());
            }
        }
    }

    @Menu(title="NPC Shop Contents Editor", type=InventoryType.CHEST, dimensions={5, 9})
    public static class NPCShopContentsEditor
    extends InventoryMenuPage {
        private MenuContext ctx;
        private int page = 0;
        private final NPCShop shop;

        public NPCShopContentsEditor(NPCShop shop) {
            this.shop = shop;
        }

        public void changePage(int newPage) {
            this.page = newPage;
            NPCShopPage shopPage = this.shop.getOrCreatePage(this.page);
            int i = 0;
            while (i < this.ctx.getInventory().getSize()) {
                InventoryMenuSlot slot = this.ctx.getSlot(i);
                slot.clear();
                NPCShopItem item = shopPage.getItem(i);
                if (item != null) {
                    slot.setItemStack(item.display);
                }
                int idx = i++;
                slot.setClickHandler(evt -> {
                    evt.setCancelled(true);
                    this.ctx.clearSlots();
                    NPCShopItem display = item;
                    if (display == null) {
                        display = new NPCShopItem();
                        if (evt.getCursor() != null) {
                            display.display = evt.getCursor().clone();
                        }
                    }
                    this.ctx.getMenu().transition(new NPCShopItemEditor(display, modified -> {
                        if (modified == null) {
                            shopPage.removeItem(idx);
                        } else {
                            shopPage.setItem(idx, (NPCShopItem)modified);
                        }
                    }));
                });
            }
            InventoryMenuSlot prev = this.ctx.getSlot(39);
            InventoryMenuSlot edit = this.ctx.getSlot(40);
            InventoryMenuSlot next = this.ctx.getSlot(41);
            prev.clear();
            if (this.page > 0) {
                prev.setItemStack(new ItemStack(Material.FEATHER, 1), "Previous page (" + this.page + ")");
                prev.setClickHandler(evt -> {
                    evt.setCancelled(true);
                    this.changePage(this.page - 1);
                });
            }
            next.setItemStack(new ItemStack(Material.FEATHER, 1), this.page + 1 >= this.shop.pages.size() ? "New page" : "Next page (" + (this.page + 1) + ")");
            next.setClickHandler(evt -> {
                evt.setCancelled(true);
                this.changePage(this.page + 1);
            });
            edit.setItemStack(new ItemStack(Material.BOOK), "Edit page");
            edit.setClickHandler(evt -> {
                evt.setCancelled(true);
                this.ctx.getMenu().transition(new NPCShopPageSettings(this.shop.getOrCreatePage(this.page)));
            });
        }

        @Override
        public void initialise(MenuContext ctx) {
            this.ctx = ctx;
            if (ctx.data().containsKey("removePage")) {
                int index = (Integer)ctx.data().remove("removePage");
                this.shop.removePage(index);
                this.page = Math.max(this.page - 1, 0);
            }
            this.changePage(this.page);
        }
    }
}

