/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.scripting.CompileCallback;
import net.citizensnpcs.api.scripting.Script;
import net.citizensnpcs.api.scripting.ScriptFactory;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.DataKey;
import org.bukkit.Bukkit;
import org.bukkit.plugin.java.JavaPlugin;

@TraitName(value="scripttrait")
public class ScriptTrait
extends Trait {
    @Persist
    private final List<String> files = new ArrayList<String>();
    private final List<RunnableScript> runnableScripts = new ArrayList<RunnableScript>();

    public ScriptTrait() {
        super("scripttrait");
    }

    public void addScripts(List<String> scripts) {
        for (String f : scripts) {
            if (this.files.contains(f) || !this.validateFile(f)) continue;
            this.loadScript(f);
            this.files.add(f);
        }
    }

    public List<String> getScripts() {
        return this.files;
    }

    @Override
    public void load(DataKey key) {
        for (String file : this.files) {
            if (!this.validateFile(file)) continue;
            this.loadScript(file);
        }
    }

    public void loadScript(final String file) {
        File f = new File(((Citizens)JavaPlugin.getPlugin(Citizens.class)).getScriptFolder(), file);
        CitizensAPI.getScriptCompiler().compile(f).cache(true).withCallback(new CompileCallback(){

            @Override
            public void onScriptCompiled(String sourceDescriptor, ScriptFactory compiled) {
                final Script newInstance = compiled.newInstance();
                Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        block2: {
                            try {
                                newInstance.invoke("onLoad", ScriptTrait.this.npc);
                            }
                            catch (RuntimeException e) {
                                if (e.getCause() instanceof NoSuchMethodException) break block2;
                                throw e;
                            }
                        }
                        ScriptTrait.this.runnableScripts.add(new RunnableScript(newInstance, file));
                    }
                });
            }
        }).beginWithFuture();
    }

    public void removeScripts(List<String> scripts) {
        this.files.removeAll(scripts);
        Iterator<RunnableScript> itr = this.runnableScripts.iterator();
        while (itr.hasNext()) {
            if (!scripts.remove(itr.next().file)) continue;
            itr.remove();
        }
    }

    @Override
    public void run() {
        Iterator<RunnableScript> itr = this.runnableScripts.iterator();
        while (itr.hasNext()) {
            try {
                itr.next().script.invoke("run", this.npc);
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof NoSuchMethodException) {
                    itr.remove();
                    continue;
                }
                throw e;
            }
        }
    }

    public boolean validateFile(String file) {
        File f = new File(((Citizens)JavaPlugin.getPlugin(Citizens.class)).getScriptFolder(), file);
        if (!f.exists() || !f.getParentFile().equals(((Citizens)JavaPlugin.getPlugin(Citizens.class)).getScriptFolder())) {
            return false;
        }
        return CitizensAPI.getScriptCompiler().canCompile(f);
    }

    private static class RunnableScript {
        String file;
        Script script;

        public RunnableScript(Script script, String file) {
            this.script = script;
            this.file = file;
        }
    }
}

