/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

@TraitName(value="scoreboardtrait")
public class ScoreboardTrait
extends Trait {
    private boolean changed;
    @Persist
    private ChatColor color;
    private ChatColor previousGlowingColor;
    @Persist
    private final Set<String> tags = new HashSet<String>();
    private static SetMultimap<UUID, String> SENT_TEAMS = HashMultimap.create();
    private static boolean SUPPORT_COLLIDABLE_SETOPTION = true;
    private static boolean SUPPORT_GLOWING_COLOR = true;
    private static boolean SUPPORT_TAGS = true;
    private static boolean SUPPORT_TEAM_SETOPTION = true;

    public ScoreboardTrait() {
        super("scoreboardtrait");
    }

    public void addTag(String tag) {
        this.tags.add(tag);
    }

    public void createTeam(String entityName) {
        String teamName = Util.getTeamName(this.npc.getUniqueId());
        this.npc.data().set("fake-scoreboard-team-name", (Object)teamName);
        Scoreboard scoreboard = Util.getDummyScoreboard();
        Team team = scoreboard.getTeam(teamName);
        if (team == null) {
            team = scoreboard.registerNewTeam(teamName);
        }
        team.addEntry(entityName);
    }

    public ChatColor getColor() {
        return this.color;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    private Team getTeam() {
        String teamName = this.npc.data().get(NPC.Metadata.SCOREBOARD_FAKE_TEAM_NAME, "");
        if (teamName.isEmpty()) {
            return null;
        }
        return Util.getDummyScoreboard().getTeam(teamName);
    }

    @Override
    public void onDespawn() {
        if (this.npc.getEntity() == null) {
            return;
        }
        String name = this.npc.getEntity() instanceof Player ? this.npc.getEntity().getName() : this.npc.getUniqueId().toString();
        String teamName = this.npc.data().get("fake-scoreboard-team-name", "");
        if (teamName.isEmpty()) {
            return;
        }
        Team team = Util.getDummyScoreboard().getTeam(teamName);
        this.npc.data().remove("fake-scoreboard-team-name");
        if (team == null) {
            return;
        }
        if (team.hasEntry(name)) {
            if (team.getSize() == 1) {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    SENT_TEAMS.remove((Object)player.getUniqueId(), (Object)team.getName());
                    NMS.sendTeamPacket(player, team, 1);
                }
                team.unregister();
            } else {
                team.removeEntry(name);
            }
        }
    }

    @Override
    public void onSpawn() {
        this.changed = true;
    }

    public void removeTag(String tag) {
        this.tags.remove(tag);
    }

    public void setColor(ChatColor color) {
        this.color = color;
    }

    public void update() {
        String forceVisible = ((Object)this.npc.data().get(NPC.Metadata.NAMEPLATE_VISIBLE, Boolean.valueOf(true))).toString();
        boolean nameVisibility = !this.npc.requiresNameHologram() && (forceVisible.equals("true") || forceVisible.equals("hover"));
        Team team = this.getTeam();
        if (team == null) {
            return;
        }
        if (!Settings.Setting.USE_SCOREBOARD_TEAMS.asBoolean()) {
            team.unregister();
            this.npc.data().remove("fake-scoreboard-team-name");
            return;
        }
        HashSet<String> newTags = new HashSet<String>(this.tags);
        if (SUPPORT_TAGS) {
            try {
                if (!this.npc.getEntity().getScoreboardTags().equals(this.tags)) {
                    this.changed = true;
                    Iterator iterator = this.npc.getEntity().getScoreboardTags().iterator();
                    while (iterator.hasNext()) {
                        String oldTag = (String)iterator.next();
                        if (newTags.remove(oldTag)) continue;
                        iterator.remove();
                    }
                    for (String tag : newTags) {
                        this.npc.getEntity().addScoreboardTag(tag);
                    }
                }
            }
            catch (NoSuchMethodError e) {
                SUPPORT_TAGS = false;
            }
        }
        if (SUPPORT_TEAM_SETOPTION) {
            try {
                Team.OptionStatus visibility;
                Team.OptionStatus optionStatus = visibility = nameVisibility ? Team.OptionStatus.ALWAYS : Team.OptionStatus.NEVER;
                if (visibility != team.getOption(Team.Option.NAME_TAG_VISIBILITY)) {
                    this.changed = true;
                }
                team.setOption(Team.Option.NAME_TAG_VISIBILITY, visibility);
            }
            catch (NoSuchMethodError e) {
                SUPPORT_TEAM_SETOPTION = false;
            }
            catch (NoClassDefFoundError e) {
                SUPPORT_TEAM_SETOPTION = false;
            }
        }
        if (SUPPORT_COLLIDABLE_SETOPTION && this.npc.data().has("collidable")) {
            try {
                Team.OptionStatus collide;
                Team.OptionStatus optionStatus = collide = (Boolean)this.npc.data().get("collidable") != false ? Team.OptionStatus.ALWAYS : Team.OptionStatus.NEVER;
                if (collide != team.getOption(Team.Option.COLLISION_RULE)) {
                    this.changed = true;
                }
                team.setOption(Team.Option.COLLISION_RULE, collide);
            }
            catch (NoSuchMethodError e) {
                SUPPORT_COLLIDABLE_SETOPTION = false;
            }
            catch (NoClassDefFoundError e) {
                SUPPORT_COLLIDABLE_SETOPTION = false;
            }
        }
        if (!SUPPORT_TEAM_SETOPTION) {
            NMS.setTeamNameTagVisible(team, nameVisibility);
        }
        if (this.npc.data().has("glowing-color")) {
            this.color = ChatColor.valueOf((String)((String)this.npc.data().get("glowing-color")));
            this.npc.data().remove("glowing-color");
        }
        if (this.color != null) {
            if (SUPPORT_GLOWING_COLOR && Util.getMinecraftRevision().contains("1_12_R1")) {
                SUPPORT_GLOWING_COLOR = false;
            }
            if (SUPPORT_GLOWING_COLOR) {
                try {
                    if (team.getColor() == null || this.previousGlowingColor == null || this.previousGlowingColor != null && this.color != this.previousGlowingColor) {
                        team.setColor(this.color);
                        this.previousGlowingColor = this.color;
                        this.changed = true;
                    }
                }
                catch (NoSuchMethodError err) {
                    SUPPORT_GLOWING_COLOR = false;
                }
            } else if (team.getPrefix() == null || team.getPrefix().length() == 0 || this.previousGlowingColor == null || this.previousGlowingColor != null && !team.getPrefix().equals(this.previousGlowingColor.toString())) {
                team.setPrefix(this.color.toString());
                this.previousGlowingColor = this.color;
                this.changed = true;
            }
        }
        if (this.changed) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (player.hasMetadata("NPC")) continue;
                if (SENT_TEAMS.containsEntry((Object)player.getUniqueId(), (Object)team.getName())) {
                    NMS.sendTeamPacket(player, team, 2);
                    continue;
                }
                NMS.sendTeamPacket(player, team, 0);
                SENT_TEAMS.put((Object)player.getUniqueId(), (Object)team.getName());
            }
        }
    }

    public static void onPlayerJoin(PlayerJoinEvent event) {
        for (NPC npc : CitizensAPI.getNPCRegistry()) {
            Team team;
            ScoreboardTrait trait = npc.getTraitNullable(ScoreboardTrait.class);
            if (trait == null || (team = trait.getTeam()) == null || SENT_TEAMS.containsEntry((Object)event.getPlayer().getUniqueId(), (Object)team.getName())) continue;
            NMS.sendTeamPacket(event.getPlayer(), team, 0);
            SENT_TEAMS.put((Object)event.getPlayer().getUniqueId(), (Object)team.getName());
        }
    }

    public static void onPlayerQuit(PlayerQuitEvent event) {
        SENT_TEAMS.removeAll((Object)event.getPlayer().getUniqueId());
    }
}

