/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.trait.Toggleable;
import net.citizensnpcs.util.Util;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Steerable;

@TraitName(value="saddle")
public class Saddle
extends Trait
implements Toggleable {
    @Persist(value="")
    private boolean saddle;
    private boolean steerable;
    private static boolean SUPPORT_STEERABLE = true;

    public Saddle() {
        super("saddle");
    }

    @Override
    public void onSpawn() {
        if (Util.optionalEntitySet("PIG", "STRIDER").contains(this.npc.getEntity().getType())) {
            this.steerable = true;
            this.updateSaddleState();
        } else {
            this.steerable = false;
        }
    }

    @Override
    public boolean toggle() {
        boolean bl = this.saddle = !this.saddle;
        if (this.steerable) {
            this.updateSaddleState();
        }
        return this.saddle;
    }

    public String toString() {
        return "Saddle{" + this.saddle + "}";
    }

    private void updateSaddleState() {
        if (SUPPORT_STEERABLE) {
            try {
                ((Steerable)this.npc.getEntity()).setSaddle(this.saddle);
            }
            catch (Throwable t) {
                SUPPORT_STEERABLE = false;
                ((Pig)this.npc.getEntity()).setSaddle(this.saddle);
            }
        } else {
            ((Pig)this.npc.getEntity()).setSaddle(this.saddle);
        }
    }

    public boolean useSaddle() {
        return this.saddle;
    }
}

