/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import java.util.UUID;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import org.bukkit.entity.Entity;

@TraitName(value="mounttrait")
public class MountTrait
extends Trait {
    private UUID mountedOn;
    private boolean triggered = false;
    @Persist(value="mountedon")
    private String uuid;

    public MountTrait() {
        super("mounttrait");
    }

    public void checkMounted(Entity mounted) {
        if (this.mountedOn == null || mounted != null && mounted.getUniqueId().equals(this.mountedOn)) {
            return;
        }
        NPC other = CitizensAPI.getNPCRegistry().getByUniqueId(this.mountedOn);
        if (other != null && other.isSpawned()) {
            NMS.mount(other.getEntity(), this.npc.getEntity());
            this.triggered = true;
        }
    }

    public UUID getMountedOn() {
        return this.mountedOn;
    }

    @Override
    public void onDespawn() {
        if (NMS.getVehicle(this.npc.getEntity()) != null) {
            this.npc.getEntity().leaveVehicle();
        }
    }

    @Override
    public void onSpawn() {
        this.checkMounted(null);
    }

    @Override
    public void run() {
        Entity vehicle;
        if (!this.npc.isSpawned()) {
            return;
        }
        if (!this.triggered && this.uuid != null) {
            try {
                this.mountedOn = UUID.fromString(this.uuid);
            }
            catch (IllegalArgumentException e) {
                this.mountedOn = null;
            }
            this.checkMounted(null);
        }
        if ((vehicle = NMS.getVehicle(this.npc.getEntity())) == null && !this.triggered) {
            this.mountedOn = null;
        } else if (vehicle instanceof NPCHolder) {
            this.setMountedOn(((NPCHolder)vehicle).getNPC().getUniqueId());
        }
        this.checkMounted(vehicle);
    }

    public void setMountedOn(UUID uuid) {
        this.mountedOn = uuid;
        this.uuid = uuid.toString();
    }

    public void unmount() {
        if (this.mountedOn == null) {
            return;
        }
        if (NMS.getVehicle(this.npc.getEntity()) != null) {
            this.npc.getEntity().leaveVehicle();
        }
        this.uuid = null;
        this.mountedOn = null;
    }
}

