/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Random;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.command.CommandConfigurable;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.event.NPCLookCloseChangeTargetEvent;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.trait.Toggleable;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.potion.PotionEffectType;

@TraitName(value="lookclose")
public class LookClose
extends Trait
implements Toggleable,
CommandConfigurable {
    @Persist(value="disablewhilenavigating")
    private boolean disableWhileNavigating = Settings.Setting.DISABLE_LOOKCLOSE_WHILE_NAVIGATING.asBoolean();
    @Persist(value="enabled")
    private boolean enabled = Settings.Setting.DEFAULT_LOOK_CLOSE.asBoolean();
    @Persist
    private boolean enableRandomLook = Settings.Setting.DEFAULT_RANDOM_LOOK_CLOSE.asBoolean();
    private Player lookingAt;
    @Persist
    private int randomLookDelay = Settings.Setting.DEFAULT_RANDOM_LOOK_DELAY.asInt();
    @Persist
    private float[] randomPitchRange = new float[]{0.0f, 0.0f};
    @Persist
    private boolean randomSwitchTargets;
    @Persist
    private float[] randomYawRange = new float[]{0.0f, 360.0f};
    private double range = Settings.Setting.DEFAULT_LOOK_CLOSE_RANGE.asDouble();
    @Persist(value="realisticlooking")
    private boolean realisticLooking = Settings.Setting.DEFAULT_REALISTIC_LOOKING.asBoolean();
    private int t;
    private static final Location CACHE_LOCATION = new Location(null, 0.0, 0.0, 0.0);
    private static final Location NPC_LOCATION = new Location(null, 0.0, 0.0, 0.0);
    private static final Location PLAYER_LOCATION = new Location(null, 0.0, 0.0, 0.0);

    public LookClose() {
        super("lookclose");
    }

    private boolean canSee(Player player) {
        if (player == null || !player.isValid()) {
            return false;
        }
        return this.realisticLooking && this.npc.getEntity() instanceof LivingEntity ? ((LivingEntity)this.npc.getEntity()).hasLineOfSight((Entity)player) : true;
    }

    public boolean canSeeTarget() {
        return this.canSee(this.lookingAt);
    }

    @Override
    public void configure(CommandContext args) throws CommandException {
        try {
            this.range = args.getFlagDouble("range", args.getFlagDouble("r", this.range));
        }
        catch (NumberFormatException ex) {
            throw new CommandException("citizens.commands.invalid-number");
        }
        this.realisticLooking = args.hasFlag('r');
    }

    public boolean disableWhileNavigating() {
        return this.disableWhileNavigating;
    }

    public void findNewTarget() {
        Player old;
        block6: {
            block5: {
                if (this.lookingAt != null && !this.isValid(this.lookingAt)) {
                    NPCLookCloseChangeTargetEvent event = new NPCLookCloseChangeTargetEvent(this.npc, this.lookingAt, null);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    this.lookingAt = event.getNewTarget() != null && this.isValid(event.getNewTarget()) ? event.getNewTarget() : null;
                }
                old = this.lookingAt;
                if (this.lookingAt == null) break block5;
                if (!this.randomSwitchTargets || this.t > 0) break block6;
                ArrayList options = Lists.newArrayList();
                for (Entity entity : this.npc.getEntity().getNearbyEntities(this.range, this.range, this.range)) {
                    Player player;
                    if (entity == this.lookingAt || !(entity instanceof Player) || CitizensAPI.getNPCRegistry().getNPC(entity) != null || (player = (Player)entity).getLocation().getWorld() != NPC_LOCATION.getWorld() || this.isInvisible(player)) continue;
                    options.add(player);
                }
                if (options.size() <= 0) break block6;
                this.lookingAt = (Player)options.get(Util.getFastRandom().nextInt(options.size()));
                this.t = this.randomLookDelay;
                break block6;
            }
            double min = this.range;
            for (Entity entity : this.npc.getEntity().getNearbyEntities(this.range, this.range, this.range)) {
                double dist;
                Player player;
                Location location;
                if (!(entity instanceof Player) || (location = (player = (Player)entity).getLocation(CACHE_LOCATION)).getWorld() != NPC_LOCATION.getWorld() || (dist = location.distance(NPC_LOCATION)) > min || CitizensAPI.getNPCRegistry().getNPC(entity) != null || this.isInvisible(player)) continue;
                min = dist;
                this.lookingAt = player;
            }
        }
        if (old != this.lookingAt) {
            NPCLookCloseChangeTargetEvent event = new NPCLookCloseChangeTargetEvent(this.npc, old, this.lookingAt);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (this.lookingAt != event.getNewTarget() && event.getNewTarget() != null && !this.isValid(event.getNewTarget())) {
                return;
            }
            this.lookingAt = event.getNewTarget();
        }
    }

    public int getRandomLookDelay() {
        return this.randomLookDelay;
    }

    public float[] getRandomLookPitchRange() {
        return this.randomPitchRange;
    }

    public float[] getRandomLookYawRange() {
        return this.randomYawRange;
    }

    public double getRange() {
        return this.range;
    }

    public Player getTarget() {
        return this.lookingAt;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private boolean isInvisible(Player player) {
        return player.getGameMode() == GameMode.SPECTATOR || player.hasPotionEffect(PotionEffectType.INVISIBILITY) || this.isPluginVanished(player) || !this.canSee(player);
    }

    private boolean isPluginVanished(Player player) {
        for (MetadataValue meta : player.getMetadata("vanished")) {
            if (!meta.asBoolean()) continue;
            return true;
        }
        return false;
    }

    public boolean isRandomLook() {
        return this.enableRandomLook;
    }

    private boolean isValid(Player entity) {
        return entity.isOnline() && entity.isValid() && entity.getWorld() == this.npc.getEntity().getWorld() && entity.getLocation(PLAYER_LOCATION).distanceSquared(NPC_LOCATION) < this.range * this.range && !this.isInvisible(entity);
    }

    @Override
    public void load(DataKey key) {
        this.range = key.getDouble("range");
    }

    public void lookClose(boolean lookClose) {
        this.enabled = lookClose;
    }

    @Override
    public void onDespawn() {
        NPCLookCloseChangeTargetEvent event = new NPCLookCloseChangeTargetEvent(this.npc, this.lookingAt, null);
        Bukkit.getPluginManager().callEvent((Event)event);
        this.lookingAt = event.getNewTarget() != null && this.isValid(event.getNewTarget()) ? event.getNewTarget() : null;
    }

    private void randomLook() {
        Random rand = new Random();
        float pitch = LookClose.isEqual(this.randomPitchRange) ? this.randomPitchRange[0] : rand.doubles(this.randomPitchRange[0], this.randomPitchRange[1]).iterator().next().floatValue();
        float yaw = LookClose.isEqual(this.randomYawRange) ? this.randomYawRange[0] : rand.doubles(this.randomYawRange[0], this.randomYawRange[1]).iterator().next().floatValue();
        Util.face(this.npc.getEntity(), yaw, pitch);
    }

    @Override
    public void run() {
        if (!this.npc.isSpawned()) {
            return;
        }
        if (this.enableRandomLook && !this.npc.getNavigator().isNavigating() && this.lookingAt == null && this.t <= 0) {
            this.randomLook();
            this.t = this.randomLookDelay;
        }
        --this.t;
        if (!this.enabled) {
            return;
        }
        if (this.npc.getNavigator().isNavigating() && this.disableWhileNavigating()) {
            return;
        }
        this.npc.getEntity().getLocation(NPC_LOCATION);
        this.findNewTarget();
        if (this.npc.getNavigator().isNavigating()) {
            this.npc.getNavigator().setPaused(this.lookingAt != null);
        }
        if (this.lookingAt == null) {
            return;
        }
        Util.faceEntity(this.npc.getEntity(), (Entity)this.lookingAt);
        if (this.npc.getEntity().getType().name().equals("SHULKER")) {
            boolean wasSilent = this.npc.getEntity().isSilent();
            this.npc.getEntity().setSilent(true);
            NMS.setPeekShulker(this.npc.getEntity(), 100 - 4 * (int)Math.floor(this.npc.getStoredLocation().distanceSquared(this.lookingAt.getLocation(PLAYER_LOCATION))));
            this.npc.getEntity().setSilent(wasSilent);
        }
    }

    @Override
    public void save(DataKey key) {
        key.setDouble("range", this.range);
    }

    public void setDisableWhileNavigating(boolean set) {
        this.disableWhileNavigating = set;
    }

    public void setRandomLook(boolean enableRandomLook) {
        this.enableRandomLook = enableRandomLook;
    }

    public void setRandomLookDelay(int delay) {
        this.randomLookDelay = delay;
    }

    public void setRandomLookPitchRange(float min, float max) {
        this.randomPitchRange = new float[]{min, max};
    }

    public void setRandomLookYawRange(float min, float max) {
        this.randomYawRange = new float[]{min, max};
    }

    public void setRandomlySwitchTargets(boolean randomSwitchTargets) {
        this.randomSwitchTargets = randomSwitchTargets;
    }

    public void setRange(double d) {
        this.range = d;
    }

    public void setRealisticLooking(boolean realistic) {
        this.realisticLooking = realistic;
    }

    @Override
    public boolean toggle() {
        this.enabled = !this.enabled;
        return this.enabled;
    }

    public String toString() {
        return "LookClose{" + this.enabled + "}";
    }

    public boolean useRealisticLooking() {
        return this.realisticLooking;
    }

    private static boolean isEqual(float[] array) {
        return (double)Math.abs(array[0] - array[1]) < 0.001;
    }
}

