/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import java.lang.invoke.MethodHandle;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.util.NMS;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.inventory.ItemStack;

@TraitName(value="horsemodifiers")
public class HorseModifiers
extends Trait {
    @Persist(value="armor")
    private ItemStack armor = null;
    @Persist(value="carryingChest")
    private boolean carryingChest;
    @Persist(value="color")
    private Horse.Color color = Horse.Color.CREAMY;
    @Persist(value="saddle")
    private ItemStack saddle = null;
    @Persist(value="style")
    private Horse.Style style = Horse.Style.NONE;
    private static MethodHandle CARRYING_CHEST_METHOD;

    public HorseModifiers() {
        super("horsemodifiers");
    }

    public ItemStack getArmor() {
        return this.armor;
    }

    public Horse.Color getColor() {
        return this.color;
    }

    public ItemStack getSaddle() {
        return this.saddle;
    }

    public Horse.Style getStyle() {
        return this.style;
    }

    @Override
    public void onSpawn() {
        this.updateModifiers();
    }

    @Override
    public void run() {
        if (this.npc.getEntity() instanceof Horse) {
            Horse horse = (Horse)this.npc.getEntity();
            this.saddle = horse.getInventory().getSaddle();
            this.armor = horse.getInventory().getArmor();
        }
    }

    public void setArmor(ItemStack armor) {
        this.armor = armor;
    }

    public void setCarryingChest(boolean carryingChest) {
        this.carryingChest = carryingChest;
        this.updateModifiers();
    }

    public void setColor(Horse.Color color) {
        this.color = color;
        this.updateModifiers();
    }

    public void setSaddle(ItemStack saddle) {
        this.saddle = saddle;
    }

    public void setStyle(Horse.Style style) {
        this.style = style;
        this.updateModifiers();
    }

    private void updateModifiers() {
        if (this.npc.getEntity() instanceof Horse) {
            Horse horse = (Horse)this.npc.getEntity();
            horse.setColor(this.color);
            horse.setStyle(this.style);
            horse.getInventory().setArmor(this.armor);
            horse.getInventory().setSaddle(this.saddle);
        }
        if (CARRYING_CHEST_METHOD == null) {
            return;
        }
        EntityType type = this.npc.getEntity().getType();
        if (type.name().equals("LLAMA") || type.name().equals("TRADER_LLAMA") || type.name().equals("DONKEY") || type.name().equals("MULE")) {
            try {
                CARRYING_CHEST_METHOD.invoke(this.npc.getEntity(), this.carryingChest);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static {
        try {
            CARRYING_CHEST_METHOD = NMS.getMethodHandle(Class.forName("org.bukkit.entity.ChestedHorse"), "setCarryingChest", false, Boolean.TYPE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

