/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.MemoryNPCDataStore;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Colorizer;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Placeholders;
import net.citizensnpcs.api.util.SpigotUtil;
import net.citizensnpcs.trait.ArmorStandTrait;
import net.citizensnpcs.trait.ScoreboardTrait;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;

@TraitName(value="hologramtrait")
public class HologramTrait
extends Trait {
    private Location currentLoc;
    @Persist
    private HologramDirection direction = HologramDirection.BOTTOM_UP;
    private double lastEntityHeight = 0.0;
    private boolean lastNameplateVisible;
    @Persist
    private double lineHeight = -1.0;
    private final List<HologramLine> lines = Lists.newArrayList();
    private NPC nameNPC;
    private final NPCRegistry registry = CitizensAPI.createCitizensBackedNPCRegistry(new MemoryNPCDataStore());
    private static final Pattern ITEM_MATCHER = Pattern.compile("<item:(.*?)>|<item:(.*?):(.*?)>");

    public HologramTrait() {
        super("hologramtrait");
    }

    public void addLine(String text) {
        this.lines.add(new HologramLine(text, true));
        this.reloadLineHolograms();
    }

    public void addTemporaryLine(String text, int ticks) {
        this.lines.add(new HologramLine(text, false, ticks));
        this.reloadLineHolograms();
    }

    public void clear() {
        for (HologramLine line : this.lines) {
            line.removeNPC();
        }
        this.lines.clear();
    }

    private NPC createHologram(String line, double heightOffset) {
        NPC hologramNPC = this.registry.createNPC(EntityType.ARMOR_STAND, line);
        hologramNPC.getOrAddTrait(ArmorStandTrait.class).setAsHelperEntityWithName(this.npc);
        hologramNPC.spawn(this.currentLoc.clone().add(0.0, this.getEntityHeight() + (this.direction == HologramDirection.BOTTOM_UP ? heightOffset : this.getMaxHeight() - heightOffset), 0.0));
        Matcher itemMatcher = ITEM_MATCHER.matcher(line);
        if (itemMatcher.matches()) {
            Material item = SpigotUtil.isUsing1_13API() ? Material.matchMaterial((String)itemMatcher.group(1), (boolean)false) : Material.matchMaterial((String)itemMatcher.group(1));
            final NPC itemNPC = this.registry.createNPCUsingItem(EntityType.DROPPED_ITEM, "", new ItemStack(item, 1));
            if (itemMatcher.groupCount() > 1) {
                itemNPC.getOrAddTrait(ScoreboardTrait.class).setColor((ChatColor)Util.matchEnum((Enum[])ChatColor.values(), (String)itemMatcher.group(2)));
            }
            itemNPC.spawn(this.currentLoc);
            ((ArmorStand)hologramNPC.getEntity()).addPassenger(itemNPC.getEntity());
            itemNPC.addRunnable(new Runnable(){

                @Override
                public void run() {
                    if (!itemNPC.isSpawned() || !itemNPC.getEntity().isInsideVehicle()) {
                        itemNPC.destroy();
                    }
                }
            });
        }
        this.lastEntityHeight = this.getEntityHeight();
        return hologramNPC;
    }

    public HologramDirection getDirection() {
        return this.direction;
    }

    private double getEntityHeight() {
        return NMS.getHeight(this.npc.getEntity());
    }

    private double getHeight(int lineNumber) {
        return this.getLineHeight() * (double)(this.lastNameplateVisible ? lineNumber + 1 : lineNumber);
    }

    public Collection<ArmorStand> getHologramEntities() {
        return this.lines.stream().filter(l -> l.hologram != null && l.hologram.getEntity() != null).map(l -> (ArmorStand)l.hologram.getEntity()).collect(Collectors.toList());
    }

    public double getLineHeight() {
        return this.lineHeight == -1.0 ? Settings.Setting.DEFAULT_NPC_HOLOGRAM_LINE_HEIGHT.asDouble() : this.lineHeight;
    }

    public List<String> getLines() {
        return Lists.transform(this.lines, l -> l.text);
    }

    private double getMaxHeight() {
        return this.getLineHeight() * (double)(this.lines.size() + (this.lastNameplateVisible ? 1 : -1));
    }

    public ArmorStand getNameEntity() {
        return this.nameNPC != null && this.nameNPC.isSpawned() ? (ArmorStand)this.nameNPC.getEntity() : null;
    }

    @Override
    public void load(DataKey root) {
        this.clear();
        for (DataKey key : root.getRelative("lines").getIntegerSubKeys()) {
            this.lines.add(new HologramLine(key.getString(""), true));
        }
    }

    @Override
    public void onDespawn() {
        if (this.nameNPC != null) {
            this.nameNPC.destroy();
            this.nameNPC = null;
        }
        for (HologramLine line : this.lines) {
            line.removeNPC();
        }
    }

    @Override
    public void onRemove() {
        this.onDespawn();
    }

    @Override
    public void onSpawn() {
        if (!this.npc.isSpawned()) {
            return;
        }
        this.lastNameplateVisible = Boolean.parseBoolean(((Object)this.npc.data().get(NPC.Metadata.NAMEPLATE_VISIBLE, Boolean.valueOf(true))).toString());
        this.currentLoc = this.npc.getStoredLocation();
        if (this.npc.requiresNameHologram() && this.lastNameplateVisible) {
            this.nameNPC = this.createHologram(this.npc.getFullName(), 0.0);
        }
        for (int i = 0; i < this.lines.size(); ++i) {
            this.lines.get(i).spawnNPC(this.getHeight(i));
        }
    }

    private void reloadLineHolograms() {
        for (HologramLine line : this.lines) {
            line.removeNPC();
        }
        if (!this.npc.isSpawned()) {
            return;
        }
        for (int i = 0; i < this.lines.size(); ++i) {
            this.lines.get(i).spawnNPC(this.getHeight(i));
        }
    }

    public void removeLine(int idx) {
        if (idx < 0 || idx >= this.lines.size()) {
            return;
        }
        this.lines.remove(idx).removeNPC();
        this.reloadLineHolograms();
    }

    @Override
    public void run() {
        if (!this.npc.isSpawned()) {
            this.onDespawn();
            return;
        }
        if (this.currentLoc == null) {
            this.currentLoc = this.npc.getStoredLocation();
        }
        boolean nameplateVisible = Boolean.parseBoolean(((Object)this.npc.data().get(NPC.Metadata.NAMEPLATE_VISIBLE, Boolean.valueOf(true))).toString());
        if (this.npc.requiresNameHologram()) {
            if (this.nameNPC != null && !nameplateVisible) {
                this.nameNPC.destroy();
                this.nameNPC = null;
            } else if (this.nameNPC == null && nameplateVisible) {
                this.nameNPC = this.createHologram(this.npc.getFullName(), 0.0);
            }
        }
        boolean updatePosition = this.currentLoc.getWorld() != this.npc.getStoredLocation().getWorld() || this.currentLoc.distance(this.npc.getStoredLocation()) >= 0.001 || this.lastNameplateVisible != nameplateVisible || Math.abs(this.lastEntityHeight - this.getEntityHeight()) >= 0.05;
        this.lastNameplateVisible = nameplateVisible;
        if (updatePosition) {
            this.currentLoc = this.npc.getStoredLocation();
            this.lastEntityHeight = this.getEntityHeight();
        }
        if (this.nameNPC != null && this.nameNPC.isSpawned()) {
            if (updatePosition) {
                this.nameNPC.teleport(this.currentLoc.clone().add(0.0, this.getEntityHeight(), 0.0), PlayerTeleportEvent.TeleportCause.PLUGIN);
            }
            this.nameNPC.setName(this.npc.getFullName());
        }
        for (int i = 0; i < this.lines.size(); ++i) {
            HologramLine line = this.lines.get(i);
            NPC hologramNPC = line.hologram;
            if (hologramNPC == null || !hologramNPC.isSpawned()) continue;
            if (updatePosition) {
                hologramNPC.teleport(this.currentLoc.clone().add(0.0, this.lastEntityHeight + (this.direction == HologramDirection.BOTTOM_UP ? this.getHeight(i) : this.getMaxHeight() - this.getHeight(i)), 0.0), PlayerTeleportEvent.TeleportCause.PLUGIN);
            }
            if (line.ticks > 0 && --line.ticks == 0) {
                line.removeNPC();
                this.lines.remove(i--);
                continue;
            }
            String text = line.text;
            if (ITEM_MATCHER.matcher(text).matches()) {
                text = null;
            }
            if (text != null && !ChatColor.stripColor((String)Colorizer.parseColors(text)).isEmpty()) {
                hologramNPC.setName(Placeholders.replace(text, null, this.npc));
                hologramNPC.data().set(NPC.Metadata.NAMEPLATE_VISIBLE, (Object)true);
                continue;
            }
            hologramNPC.setName("");
            hologramNPC.data().set(NPC.Metadata.NAMEPLATE_VISIBLE, (Object)"hover");
        }
    }

    @Override
    public void save(DataKey root) {
        root.removeKey("lines");
        int i = 0;
        for (HologramLine line : this.lines) {
            if (!line.persist) continue;
            root.setString("lines." + i, line.text);
            ++i;
        }
    }

    public void setDirection(HologramDirection direction) {
        this.direction = direction;
        this.reloadLineHolograms();
    }

    public void setLine(int idx, String text) {
        if (idx == this.lines.size()) {
            this.addLine(text);
            return;
        }
        HologramLine line = this.lines.get(idx);
        line.setText(text);
        if (line.hologram == null) {
            this.reloadLineHolograms();
        }
    }

    public void setLineHeight(double height) {
        this.lineHeight = height;
        this.reloadLineHolograms();
    }

    public static enum HologramDirection {
        BOTTOM_UP,
        TOP_DOWN;

    }

    private class HologramLine {
        NPC hologram;
        boolean persist;
        String text;
        int ticks;

        public HologramLine(String text, boolean persist) {
            this(text, persist, -1);
        }

        public HologramLine(String text, boolean persist, int ticks) {
            this.text = text;
            this.persist = persist;
            this.ticks = ticks;
        }

        public void removeNPC() {
            if (this.hologram == null) {
                return;
            }
            this.hologram.destroy();
            this.hologram = null;
        }

        public void setText(String text) {
            this.text = text;
            if (this.hologram != null) {
                this.hologram.setName(Placeholders.replace(text, null, HologramTrait.this.npc));
            }
        }

        public void spawnNPC(double height) {
            this.hologram = HologramTrait.this.createHologram(Placeholders.replace(this.text, null, HologramTrait.this.npc), height);
        }
    }
}

