/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.citizensnpcs.api.event.NPCDeathEvent;
import net.citizensnpcs.api.gui.InventoryMenu;
import net.citizensnpcs.api.gui.InventoryMenuPage;
import net.citizensnpcs.api.gui.InventoryMenuSlot;
import net.citizensnpcs.api.gui.Menu;
import net.citizensnpcs.api.gui.MenuContext;
import net.citizensnpcs.api.gui.PercentageSlotHandler;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.util.Util;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

@TraitName(value="dropstrait")
public class DropsTrait
extends Trait {
    @Persist(reify=true)
    private List<ItemDrop> drops = Lists.newArrayList();

    public DropsTrait() {
        super("dropstrait");
    }

    public void displayEditor(Player sender) {
        InventoryMenu.createSelfRegistered(new DropsGUI(this)).present((HumanEntity)sender);
    }

    @EventHandler
    public void onNPCDeath(NPCDeathEvent event) {
        if (!event.getNPC().equals(this.npc)) {
            return;
        }
        Random random = Util.getFastRandom();
        for (ItemDrop drop : this.drops) {
            if (!(random.nextDouble() < drop.chance)) continue;
            event.getDrops().add(drop.drop);
        }
    }

    @Menu(title="Add items for drops", type=InventoryType.CHEST, dimensions={5, 9})
    public static class DropsGUI
    extends InventoryMenuPage {
        private final Map<Integer, Double> chances = Maps.newHashMap();
        private Inventory inventory;
        private DropsTrait trait;

        private DropsGUI() {
            throw new UnsupportedOperationException();
        }

        public DropsGUI(DropsTrait trait) {
            this.trait = trait;
        }

        @Override
        public void initialise(MenuContext ctx) {
            this.inventory = ctx.getInventory();
            int k = 0;
            for (int i = 1; i < 5; i += 2) {
                for (int j = 0; j < 9; ++j) {
                    int islot = (i - 1) * 9 + j;
                    int chance = 100;
                    if (k < this.trait.drops.size()) {
                        ItemDrop drop = (ItemDrop)this.trait.drops.get(k++);
                        chance = (int)Math.floor(drop.chance * 100.0);
                        this.chances.put(islot, drop.chance);
                        ctx.getInventory().setItem(islot, drop.drop.clone());
                    }
                    InventoryMenuSlot slot = ctx.getSlot(i * 9 + j);
                    slot.setItemStack(new ItemStack(Util.getFallbackMaterial("BARRIER", "FIRE")), "Drop chance <e>" + chance + "%");
                    slot.setClickHandler(new PercentageSlotHandler((Function<Integer, String>)((Function)pct -> {
                        if (this.chances.containsKey(islot)) {
                            this.chances.put(islot, (double)pct.intValue() / 100.0);
                        }
                        return "Drop chance <e>" + pct + "%";
                    }), chance));
                }
            }
        }

        @Override
        public void onClick(InventoryMenuSlot slot, InventoryClickEvent event) {
            if (slot.getCurrentItem() != null && slot.getCurrentItem().getType().name().equals("BARRIER")) {
                return;
            }
            event.setCancelled(false);
            if (event.getAction().name().contains("PICKUP")) {
                this.chances.remove(event.getSlot());
            } else if (event.getAction().name().contains("PLACE")) {
                this.chances.putIfAbsent(event.getSlot(), 1.0);
            }
        }

        @Override
        public void onClose(HumanEntity player) {
            ArrayList drops = Lists.newArrayList();
            for (int i = 0; i < 5; i += 2) {
                for (int j = 0; j < 9; ++j) {
                    int slot = i * 9 + j;
                    ItemStack stack = this.inventory.getItem(slot);
                    if (stack == null || stack.getType() == Material.AIR) continue;
                    drops.add(new ItemDrop(stack, this.chances.getOrDefault(slot, 1.0)));
                }
            }
            this.trait.drops = drops;
        }
    }

    private static class ItemDrop {
        @Persist
        double chance;
        @Persist
        ItemStack drop;

        public ItemDrop() {
        }

        public ItemDrop(ItemStack drop, double chance) {
            this.drop = drop;
            this.chance = chance;
        }
    }
}

