/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import com.google.common.collect.Maps;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.command.CommandConfigurable;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.trait.Toggleable;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.util.Vector;

@TraitName(value="controllable")
public class Controllable
extends Trait
implements Toggleable,
CommandConfigurable {
    private MovementController controller = new GroundController();
    @Persist
    private boolean enabled = true;
    private EntityType explicitType;
    @Persist(value="owner_required")
    private boolean ownerRequired;
    private static final Map<EntityType, Constructor<? extends MovementController>> CONTROLLER_TYPES = Maps.newEnumMap(EntityType.class);

    public Controllable() {
        super("controllable");
    }

    public Controllable(boolean enabled) {
        this();
        this.enabled = enabled;
    }

    @Override
    public void configure(CommandContext args) {
        if (args.hasFlag('f')) {
            this.explicitType = EntityType.BLAZE;
        } else if (args.hasFlag('g')) {
            this.explicitType = EntityType.OCELOT;
        } else if (args.hasFlag('o')) {
            this.explicitType = EntityType.UNKNOWN;
        } else if (args.hasFlag('r')) {
            this.explicitType = null;
        } else if (args.hasValueFlag("explicittype")) {
            this.explicitType = (EntityType)Util.matchEnum((Enum[])EntityType.values(), (String)args.getFlag("explicittype"));
        }
        if (this.npc.isSpawned()) {
            this.loadController();
        }
    }

    private void enterOrLeaveVehicle(Player player) {
        List<Entity> passengers = NMS.getPassengers((Entity)player);
        if (passengers.size() > 0) {
            if (passengers.contains(player)) {
                player.leaveVehicle();
            }
            return;
        }
        if (this.ownerRequired && !this.npc.getOrAddTrait(Owner.class).isOwnedBy((CommandSender)player)) {
            return;
        }
        NMS.mount(this.npc.getEntity(), (Entity)player);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        if (key.keyExists("explicittype")) {
            this.explicitType = (EntityType)Util.matchEnum((Enum[])EntityType.values(), (String)key.getString("explicittype"));
        }
    }

    private void loadController() {
        EntityType type = this.npc.getEntity().getType();
        if (this.explicitType != null) {
            type = this.explicitType;
        }
        if (!(this.npc.getEntity() instanceof LivingEntity || this.npc.getEntity() instanceof Vehicle || this.explicitType != null && this.explicitType != EntityType.UNKNOWN && this.npc.getEntity().getType() != this.explicitType)) {
            this.controller = new LookAirController();
            return;
        }
        Constructor<? extends MovementController> innerConstructor = CONTROLLER_TYPES.get(type);
        if (innerConstructor == null) {
            this.controller = new GroundController();
            return;
        }
        try {
            this.controller = innerConstructor.getParameterCount() == 0 ? innerConstructor.newInstance(new Object[0]) : innerConstructor.newInstance(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.controller = new GroundController();
        }
    }

    public boolean mount(Player toMount) {
        List<Entity> passengers = NMS.getPassengers(this.npc.getEntity());
        if (passengers.size() != 0) {
            return false;
        }
        boolean found = false;
        for (Entity passenger : passengers) {
            if (passenger == null || passenger != toMount) continue;
            found = true;
            break;
        }
        if (found) {
            return false;
        }
        this.enterOrLeaveVehicle(toMount);
        return true;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    private void onPlayerInteract(PlayerInteractEvent event) {
        if (!this.npc.isSpawned() || !this.enabled) {
            return;
        }
        Action performed = event.getAction();
        if (NMS.getPassengers(this.npc.getEntity()).contains(this.npc.getEntity())) {
            return;
        }
        switch (performed) {
            case RIGHT_CLICK_BLOCK: 
            case RIGHT_CLICK_AIR: {
                this.controller.rightClick(event);
                break;
            }
            case LEFT_CLICK_BLOCK: 
            case LEFT_CLICK_AIR: {
                this.controller.leftClick(event);
                break;
            }
        }
    }

    @EventHandler
    private void onRightClick(NPCRightClickEvent event) {
        if (!(this.enabled && this.npc.isSpawned() && event.getNPC().equals(this.npc))) {
            return;
        }
        this.controller.rightClickEntity(event);
    }

    @Override
    public void onSpawn() {
        this.loadController();
    }

    @Override
    public void run() {
        if (!this.enabled || !this.npc.isSpawned()) {
            return;
        }
        List<Entity> passengers = NMS.getPassengers(this.npc.getEntity());
        if (passengers.size() == 0 || !(passengers.get(0) instanceof Player) || this.npc.getNavigator().isNavigating()) {
            return;
        }
        this.controller.run((Player)passengers.get(0));
    }

    @Override
    public void save(DataKey key) {
        if (this.explicitType == null) {
            key.removeKey("explicittype");
        } else {
            key.setString("explicittype", this.explicitType.name());
        }
    }

    public boolean setEnabled(boolean enabled) {
        this.enabled = enabled;
        return enabled;
    }

    public void setExplicitType(EntityType type) {
        this.explicitType = type;
    }

    private void setMountedYaw(Entity entity) {
        if (entity instanceof EnderDragon || !Settings.Setting.USE_BOAT_CONTROLS.asBoolean()) {
            return;
        }
        Location loc = entity.getLocation();
        Vector vel = entity.getVelocity();
        if (vel.lengthSquared() == 0.0) {
            return;
        }
        double tX = loc.getX() + vel.getX();
        double tZ = loc.getZ() + vel.getZ();
        if (loc.getZ() > tZ) {
            loc.setYaw((float)(-Math.toDegrees(Math.atan((loc.getX() - tX) / (loc.getZ() - tZ)))) + 180.0f);
        } else if (loc.getZ() < tZ) {
            loc.setYaw((float)(-Math.toDegrees(Math.atan((loc.getX() - tX) / (loc.getZ() - tZ)))));
        }
        NMS.look(entity, loc.getYaw(), loc.getPitch());
    }

    public void setOwnerRequired(boolean ownerRequired) {
        this.ownerRequired = ownerRequired;
    }

    @Override
    public boolean toggle() {
        boolean bl = this.enabled = !this.enabled;
        if (!this.enabled && NMS.getPassengers(this.npc.getEntity()).size() > 0) {
            NMS.getPassengers(this.npc.getEntity()).get(0).leaveVehicle();
        }
        return this.enabled;
    }

    private double updateHorizontalSpeed(Entity handle, Entity passenger, double speed, float speedMod) {
        double newSpeed;
        double maxSpeed = Settings.Setting.MAX_CONTROLLABLE_GROUND_SPEED.asDouble();
        Vector vel = handle.getVelocity();
        double oldSpeed = Math.sqrt(vel.getX() * vel.getX() + vel.getZ() * vel.getZ());
        double horizontal = NMS.getHorizontalMovement(passenger);
        double yaw = passenger.getLocation().getYaw();
        if (horizontal > 0.0) {
            double dXcos = -Math.sin(yaw * Math.PI / 180.0);
            double dXsin = Math.cos(yaw * Math.PI / 180.0);
            vel = vel.setX(dXcos * speed * (double)speedMod).setZ(dXsin * speed * (double)speedMod);
        }
        if ((newSpeed = Math.sqrt((vel = vel.add(new Vector(passenger.getVelocity().getX() * (double)speedMod * Settings.Setting.CONTROLLABLE_GROUND_DIRECTION_MODIFIER.asDouble(), 0.0, passenger.getVelocity().getZ() * (double)speedMod * Settings.Setting.CONTROLLABLE_GROUND_DIRECTION_MODIFIER.asDouble())).multiply(0.98)).getX() * vel.getX() + vel.getZ() * vel.getZ())) > maxSpeed) {
            vel = vel.multiply(new Vector(maxSpeed / newSpeed, 1.0, maxSpeed / newSpeed));
            newSpeed = maxSpeed;
        }
        handle.setVelocity(vel);
        if (newSpeed > oldSpeed && speed < maxSpeed) {
            return (float)Math.min(maxSpeed, speed + (maxSpeed - speed) / 50.0);
        }
        return (float)Math.max(0.0, speed - speed / 50.0);
    }

    public static void registerControllerType(EntityType type, Class<? extends MovementController> clazz) {
        try {
            Constructor<? extends MovementController> constructor = clazz.getConstructor(Controllable.class);
            constructor.setAccessible(true);
            CONTROLLER_TYPES.put(type, constructor);
            return;
        }
        catch (Exception e) {
            try {
                Constructor<? extends MovementController> constructor = clazz.getConstructor(new Class[0]);
                constructor.setAccessible(true);
                CONTROLLER_TYPES.put(type, constructor);
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
            return;
        }
    }

    static {
        Controllable.registerControllerType(EntityType.BAT, PlayerInputAirController.class);
        Controllable.registerControllerType(EntityType.BLAZE, PlayerInputAirController.class);
        Controllable.registerControllerType(EntityType.ENDER_DRAGON, PlayerInputAirController.class);
        Controllable.registerControllerType(EntityType.GHAST, PlayerInputAirController.class);
        Controllable.registerControllerType(EntityType.WITHER, PlayerInputAirController.class);
        try {
            Controllable.registerControllerType(EntityType.valueOf((String)"PARROT"), PlayerInputAirController.class);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Controllable.registerControllerType(EntityType.UNKNOWN, LookAirController.class);
    }

    public class GroundController
    implements MovementController {
        private int jumpTicks = 0;
        private double speed = 0.07;
        private static final float AIR_SPEED = 0.5f;
        private static final float GROUND_SPEED = 0.5f;
        private static final float JUMP_VELOCITY = 0.5f;

        @Override
        public void leftClick(PlayerInteractEvent event) {
        }

        @Override
        public void rightClick(PlayerInteractEvent event) {
        }

        @Override
        public void rightClickEntity(NPCRightClickEvent event) {
            Controllable.this.enterOrLeaveVehicle(event.getClicker());
        }

        @Override
        public void run(Player rider) {
            boolean shouldJump;
            boolean onGround = NMS.isOnGround(Controllable.this.npc.getEntity());
            float speedMod = Controllable.this.npc.getNavigator().getDefaultParameters().modifiedSpeed(onGround ? 0.5f : 0.5f);
            if (!Util.isHorse(Controllable.this.npc.getEntity().getType())) {
                this.speed = Controllable.this.updateHorizontalSpeed(Controllable.this.npc.getEntity(), (Entity)rider, this.speed, speedMod);
            }
            if (shouldJump = NMS.shouldJump((Entity)rider)) {
                if (onGround && this.jumpTicks == 0) {
                    Controllable.this.npc.getEntity().setVelocity(Controllable.this.npc.getEntity().getVelocity().setY(0.5f));
                    this.jumpTicks = 10;
                }
            } else {
                this.jumpTicks = 0;
            }
            this.jumpTicks = Math.max(0, this.jumpTicks - 1);
            Controllable.this.setMountedYaw(Controllable.this.npc.getEntity());
        }
    }

    public static interface MovementController {
        public void leftClick(PlayerInteractEvent var1);

        public void rightClick(PlayerInteractEvent var1);

        public void rightClickEntity(NPCRightClickEvent var1);

        public void run(Player var1);
    }

    public class LookAirController
    implements MovementController {
        private boolean paused = false;

        @Override
        public void leftClick(PlayerInteractEvent event) {
            this.paused = !this.paused;
        }

        @Override
        public void rightClick(PlayerInteractEvent event) {
            this.paused = !this.paused;
        }

        @Override
        public void rightClickEntity(NPCRightClickEvent event) {
            Controllable.this.enterOrLeaveVehicle(event.getClicker());
        }

        @Override
        public void run(Player rider) {
            if (this.paused) {
                Controllable.this.npc.getEntity().setVelocity(Controllable.this.npc.getEntity().getVelocity().setY(0.001));
                return;
            }
            Vector dir = rider.getEyeLocation().getDirection();
            dir.multiply(Controllable.this.npc.getNavigator().getDefaultParameters().speedModifier());
            Controllable.this.npc.getEntity().setVelocity(dir);
            Controllable.this.setMountedYaw(Controllable.this.npc.getEntity());
        }
    }

    public class PlayerInputAirController
    implements MovementController {
        private boolean paused = false;
        private double speed;

        @Override
        public void leftClick(PlayerInteractEvent event) {
            this.paused = !this.paused;
        }

        @Override
        public void rightClick(PlayerInteractEvent event) {
            Controllable.this.npc.getEntity().setVelocity(Controllable.this.npc.getEntity().getVelocity().setY(-0.3f));
        }

        @Override
        public void rightClickEntity(NPCRightClickEvent event) {
            Controllable.this.enterOrLeaveVehicle(event.getClicker());
        }

        @Override
        public void run(Player rider) {
            if (this.paused) {
                Controllable.this.npc.getEntity().setVelocity(Controllable.this.npc.getEntity().getVelocity().setY(0.001f));
                return;
            }
            this.speed = Controllable.this.updateHorizontalSpeed(Controllable.this.npc.getEntity(), (Entity)rider, this.speed, 1.0f);
            boolean shouldJump = NMS.shouldJump((Entity)rider);
            if (shouldJump) {
                Controllable.this.npc.getEntity().setVelocity(Controllable.this.npc.getEntity().getVelocity().setY(0.3f));
            }
            Controllable.this.npc.getEntity().setVelocity(Controllable.this.npc.getEntity().getVelocity().multiply(new Vector(1.0, 0.98, 1.0)));
        }
    }
}

