/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.NPCCommandDispatchEvent;
import net.citizensnpcs.api.gui.InventoryMenuPage;
import net.citizensnpcs.api.gui.InventoryMenuSlot;
import net.citizensnpcs.api.gui.Menu;
import net.citizensnpcs.api.gui.MenuContext;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.DelegatePersistence;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.persistence.Persister;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.Placeholders;
import net.citizensnpcs.api.util.Translator;
import net.citizensnpcs.util.StringHelper;
import net.citizensnpcs.util.Util;
import net.milkbowl.vault.economy.Economy;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.plugin.RegisteredServiceProvider;

@TraitName(value="commandtrait")
public class CommandTrait
extends Trait {
    @Persist(keyType=Integer.class)
    @DelegatePersistence(value=NPCCommandPersister.class)
    private final Map<Integer, NPCCommand> commands = Maps.newHashMap();
    @Persist
    private double cost = -1.0;
    @Persist
    private final Map<CommandTraitError, String> customErrorMessages = Maps.newEnumMap(CommandTraitError.class);
    private final Map<String, Set<CommandTraitError>> executionErrors = Maps.newHashMap();
    @Persist
    private ExecutionMode executionMode = ExecutionMode.LINEAR;
    @Persist
    private float experienceCost = -1.0f;
    @Persist(valueType=Long.class)
    private final Map<String, Long> globalCooldowns = Maps.newHashMap();
    @Persist
    private boolean hideErrorMessages;
    @Persist
    private final List<ItemStack> itemRequirements = Lists.newArrayList();
    @Persist(keyType=UUID.class, reify=true, value="cooldowns")
    private final Map<UUID, PlayerNPCCommand> playerTracking = Maps.newHashMap();
    @Persist
    private final List<String> temporaryPermissions = Lists.newArrayList();

    public CommandTrait() {
        super("commandtrait");
    }

    public int addCommand(NPCCommandBuilder builder) {
        int id = this.getNewId();
        this.commands.put(id, builder.build(id));
        return id;
    }

    private boolean chargeCommandCosts(Player player, Hand hand) {
        if (this.cost > 0.0) {
            try {
                RegisteredServiceProvider provider = Bukkit.getServicesManager().getRegistration(Economy.class);
                if (provider != null && provider.getProvider() != null) {
                    Economy economy = (Economy)provider.getProvider();
                    if (!economy.has((OfflinePlayer)player, this.cost)) {
                        this.sendErrorMessage(player, CommandTraitError.MISSING_MONEY, null, this.cost);
                        return false;
                    }
                    economy.withdrawPlayer((OfflinePlayer)player, this.cost);
                }
            }
            catch (NoClassDefFoundError e) {
                Messaging.severe("Unable to find Vault when checking command cost - is it installed?");
            }
        }
        if (this.experienceCost > 0.0f) {
            if ((float)player.getLevel() < this.experienceCost) {
                this.sendErrorMessage(player, CommandTraitError.MISSING_EXPERIENCE, null, Float.valueOf(this.experienceCost));
                return false;
            }
            player.setLevel((int)((float)player.getLevel() - this.experienceCost));
        }
        if (this.itemRequirements.size() > 0) {
            ArrayList req = Lists.newArrayList(this.itemRequirements);
            Inventory tempInventory = Bukkit.createInventory(null, (int)54);
            for (int i = 0; i < player.getInventory().getSize(); ++i) {
                tempInventory.setItem(i, player.getInventory().getItem(i));
            }
            for (ItemStack stack : req) {
                if (tempInventory.containsAtLeast(stack, stack.getAmount())) {
                    tempInventory.removeItem(new ItemStack[]{stack});
                    continue;
                }
                this.sendErrorMessage(player, CommandTraitError.MISSING_ITEM, null, Util.prettyEnum(stack.getType()), stack.getAmount());
                return false;
            }
            for (int i = 0; i < player.getInventory().getSize(); ++i) {
                player.getInventory().setItem(i, tempInventory.getItem(i));
            }
        }
        return true;
    }

    public void clearHistory(CommandTraitError which, Player who) {
        ArrayList toClear = Lists.newArrayList();
        if (who != null) {
            toClear.add(this.playerTracking.get(who.getUniqueId()));
        } else {
            toClear.addAll(this.playerTracking.values());
        }
        switch (which) {
            case MAXIMUM_TIMES_USED: {
                for (PlayerNPCCommand tracked : toClear) {
                    tracked.nUsed.clear();
                }
                break;
            }
            case ON_COOLDOWN: {
                for (PlayerNPCCommand tracked : toClear) {
                    tracked.lastUsed.clear();
                }
                break;
            }
            case ON_GLOBAL_COOLDOWN: {
                this.globalCooldowns.clear();
                break;
            }
            default: {
                return;
            }
        }
    }

    public void describe(CommandSender sender) {
        ArrayList left = Lists.newArrayList();
        ArrayList right = Lists.newArrayList();
        for (NPCCommand command : this.commands.values()) {
            if (command.hand == Hand.LEFT || command.hand == Hand.BOTH) {
                left.add(command);
            }
            if (command.hand != Hand.RIGHT && command.hand != Hand.BOTH) continue;
            right.add(command);
        }
        String output = "";
        if (this.cost > 0.0) {
            output = output + "Cost: " + StringHelper.wrap(this.cost);
        }
        if (this.experienceCost > 0.0f) {
            output = output + " XP cost: " + StringHelper.wrap(Float.valueOf(this.experienceCost));
        }
        if (left.size() > 0) {
            output = output + Messaging.tr("citizens.commands.npc.command.left-hand-header", new Object[0]);
            for (NPCCommand command : left) {
                output = output + this.describe(command);
            }
        }
        if (right.size() > 0) {
            output = output + Messaging.tr("citizens.commands.npc.command.right-hand-header", new Object[0]);
            for (NPCCommand command : right) {
                output = output + this.describe(command);
            }
        }
        output = output.isEmpty() ? Messaging.tr("citizens.commands.npc.command.none-added", new Object[0]) : (Object)((Object)this.executionMode) + " " + output;
        Messaging.send(sender, output);
    }

    private String describe(NPCCommand command) {
        String output = "<br>    - " + command.command + " [" + StringHelper.wrap(command.cooldown) + "s] [<click:run_command:/npc cmd remove " + command.id + "><hover:show_text:Remove this command><red>-</hover></click>]";
        if (command.globalCooldown > 0) {
            output = output + "[global " + StringHelper.wrap(command.globalCooldown) + "s]";
        }
        if (command.op) {
            output = output + " -o";
        }
        if (command.player) {
            output = output + " -p";
        }
        return output;
    }

    public void dispatch(final Player player, final Hand hand) {
        NPCCommandDispatchEvent event = new NPCCommandDispatchEvent(this.npc, player);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        Runnable task = new Runnable(){
            Boolean charged = null;

            @Override
            public void run() {
                ArrayList commandList = Lists.newArrayList((Iterable)Iterables.filter(CommandTrait.this.commands.values(), (Predicate)new Predicate<NPCCommand>(){

                    public boolean apply(NPCCommand command) {
                        return command.hand == hand || command.hand == Hand.BOTH;
                    }
                }));
                if (CommandTrait.this.executionMode == ExecutionMode.RANDOM) {
                    if (commandList.size() > 0) {
                        this.runCommand(player, (NPCCommand)commandList.get(Util.getFastRandom().nextInt(commandList.size())));
                    }
                    return;
                }
                int max = -1;
                if (CommandTrait.this.executionMode == ExecutionMode.SEQUENTIAL) {
                    Collections.sort(commandList, new Comparator<NPCCommand>(){

                        @Override
                        public int compare(NPCCommand o1, NPCCommand o2) {
                            return Integer.compare(o1.id, o2.id);
                        }
                    });
                    int n = max = commandList.size() > 0 ? ((NPCCommand)commandList.get((int)(commandList.size() - 1))).id : -1;
                }
                if (CommandTrait.this.executionMode == ExecutionMode.LINEAR) {
                    CommandTrait.this.executionErrors.put(player.getUniqueId().toString(), EnumSet.noneOf(CommandTraitError.class));
                }
                for (NPCCommand command : commandList) {
                    if (CommandTrait.this.executionMode == ExecutionMode.SEQUENTIAL) {
                        PlayerNPCCommand info = (PlayerNPCCommand)CommandTrait.this.playerTracking.get(player.getUniqueId());
                        if (info != null && info.lastUsedHand != hand) {
                            info.lastUsedHand = hand;
                            info.lastUsedId = -1;
                        }
                        if (info != null && command.id <= info.lastUsedId) {
                            if (info.lastUsedId != max) continue;
                            info.lastUsedId = -1;
                        }
                    }
                    this.runCommand(player, command);
                    if (CommandTrait.this.executionMode != ExecutionMode.SEQUENTIAL && (this.charged == null || this.charged.booleanValue())) continue;
                    break;
                }
            }

            private void runCommand(final Player player2, final NPCCommand command) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        PlayerNPCCommand info = (PlayerNPCCommand)CommandTrait.this.playerTracking.get(player2.getUniqueId());
                        if (info == null && (CommandTrait.this.executionMode == ExecutionMode.SEQUENTIAL || PlayerNPCCommand.requiresTracking(command))) {
                            info = new PlayerNPCCommand();
                            CommandTrait.this.playerTracking.put(player2.getUniqueId(), info);
                        }
                        if (info != null && !info.canUse(CommandTrait.this, player2, command)) {
                            return;
                        }
                        if (charged == null) {
                            if (!CommandTrait.this.chargeCommandCosts(player2, hand)) {
                                charged = false;
                                return;
                            }
                            charged = true;
                        }
                        PermissionAttachment attachment = player2.addAttachment(CitizensAPI.getPlugin());
                        if (CommandTrait.this.temporaryPermissions.size() > 0) {
                            for (String permission : CommandTrait.this.temporaryPermissions) {
                                attachment.setPermission(permission, true);
                            }
                        }
                        command.run(CommandTrait.this.npc, player2);
                        attachment.remove();
                    }
                };
                if (command.delay <= 0) {
                    runnable.run();
                } else {
                    Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), runnable, (long)command.delay);
                }
            }
        };
        if (Bukkit.isPrimaryThread()) {
            task.run();
        } else {
            Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), task);
        }
    }

    public double getCost() {
        return this.cost;
    }

    public ExecutionMode getExecutionMode() {
        return this.executionMode;
    }

    public float getExperienceCost() {
        return this.experienceCost;
    }

    private int getNewId() {
        int i = 0;
        while (this.commands.containsKey(i)) {
            ++i;
        }
        return i;
    }

    public boolean hasCommandId(int id) {
        return this.commands.containsKey(id);
    }

    public boolean isHideErrorMessages() {
        return this.hideErrorMessages;
    }

    public void removeCommandById(int id) {
        this.commands.remove(id);
    }

    @Override
    public void save(DataKey key) {
        Collection<NPCCommand> commands = this.commands.values();
        for (PlayerNPCCommand playerCommand : this.playerTracking.values()) {
            playerCommand.prune(this.globalCooldowns, commands);
        }
    }

    private void sendErrorMessage(Player player, CommandTraitError msg, Function<String, String> transform, Object ... objects) {
        if (this.hideErrorMessages) {
            return;
        }
        Set<CommandTraitError> sent = this.executionErrors.get(player.getUniqueId().toString());
        if (sent != null) {
            if (sent.contains((Object)msg)) {
                return;
            }
            sent.add(msg);
        }
        String messageRaw = this.customErrorMessages.getOrDefault((Object)msg, msg.setting.asString());
        if (transform != null) {
            messageRaw = transform.apply(messageRaw);
        }
        if (messageRaw != null && messageRaw.trim().length() > 0) {
            Messaging.send((CommandSender)player, Translator.format(messageRaw, objects));
        }
    }

    public void setCost(double cost) {
        this.cost = cost;
    }

    public void setCustomErrorMessage(CommandTraitError which, String message) {
        this.customErrorMessages.put(which, message);
    }

    public void setExecutionMode(ExecutionMode mode) {
        this.executionMode = mode;
    }

    public void setExperienceCost(float experienceCost) {
        this.experienceCost = experienceCost;
    }

    public void setHideErrorMessages(boolean hide) {
        this.hideErrorMessages = hide;
    }

    public void setTemporaryPermissions(List<String> permissions) {
        this.temporaryPermissions.clear();
        this.temporaryPermissions.addAll(permissions);
    }

    public static enum CommandTraitError {
        MAXIMUM_TIMES_USED(Settings.Setting.NPC_COMMAND_MAXIMUM_TIMES_USED_MESSAGE),
        MISSING_EXPERIENCE(Settings.Setting.NPC_COMMAND_NOT_ENOUGH_EXPERIENCE_MESSAGE),
        MISSING_ITEM(Settings.Setting.NPC_COMMAND_MISSING_ITEM_MESSAGE),
        MISSING_MONEY(Settings.Setting.NPC_COMMAND_NOT_ENOUGH_MONEY_MESSAGE),
        NO_PERMISSION(Settings.Setting.NPC_COMMAND_NO_PERMISSION_MESSAGE),
        ON_COOLDOWN(Settings.Setting.NPC_COMMAND_ON_COOLDOWN_MESSAGE),
        ON_GLOBAL_COOLDOWN(Settings.Setting.NPC_COMMAND_ON_GLOBAL_COOLDOWN_MESSAGE);

        private final Settings.Setting setting;

        private CommandTraitError(Settings.Setting setting) {
            this.setting = setting;
        }
    }

    public static enum Hand {
        BOTH,
        LEFT,
        RIGHT;

    }

    public static enum ExecutionMode {
        LINEAR,
        RANDOM,
        SEQUENTIAL;


        public String toString() {
            return this.name().charAt(0) + this.name().substring(1).toLowerCase();
        }
    }

    public static class NPCCommandBuilder {
        String command;
        int cooldown;
        int delay;
        int globalCooldown;
        Hand hand;
        int n = -1;
        boolean op;
        List<String> perms = Lists.newArrayList();
        boolean player;

        public NPCCommandBuilder(String command, Hand hand) {
            this.command = command;
            this.hand = hand;
        }

        public NPCCommandBuilder addPerm(String permission) {
            this.perms.add(permission);
            return this;
        }

        public NPCCommandBuilder addPerms(List<String> perms) {
            this.perms.addAll(perms);
            return this;
        }

        private NPCCommand build(int id) {
            return new NPCCommand(id, this.command, this.hand, this.player, this.op, this.cooldown, this.perms, this.n, this.delay, this.globalCooldown);
        }

        public NPCCommandBuilder command(String command) {
            this.command = command;
            return this;
        }

        public NPCCommandBuilder cooldown(int cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        public NPCCommandBuilder delay(int delay) {
            this.delay = delay;
            return this;
        }

        public NPCCommandBuilder globalCooldown(int cooldown) {
            this.globalCooldown = cooldown;
            return this;
        }

        public NPCCommandBuilder n(int n) {
            this.n = n;
            return this;
        }

        public NPCCommandBuilder op(boolean op) {
            this.op = op;
            return this;
        }

        public NPCCommandBuilder player(boolean player) {
            this.player = player;
            return this;
        }
    }

    private static class NPCCommand {
        String bungeeServer;
        String command;
        int cooldown;
        int delay;
        int globalCooldown;
        Hand hand;
        int id;
        String key;
        int n;
        boolean op;
        List<String> perms;
        boolean player;

        public NPCCommand(int id, String command, Hand hand, boolean player, boolean op, int cooldown, List<String> perms, int n, int delay, int globalCooldown) {
            this.id = id;
            this.command = command;
            this.hand = hand;
            this.player = player;
            this.op = op;
            this.cooldown = cooldown;
            this.perms = perms;
            this.n = n;
            this.delay = delay;
            this.globalCooldown = globalCooldown;
            List split = Splitter.on((char)' ').omitEmptyStrings().trimResults().limit(2).splitToList((CharSequence)command);
            this.bungeeServer = split.size() == 2 && ((String)split.get(0)).equalsIgnoreCase("server") ? (String)split.get(1) : null;
        }

        public String getEncodedKey() {
            if (this.key != null) {
                return this.key;
            }
            this.key = BaseEncoding.base64().encode(this.command.getBytes());
            return this.key;
        }

        public void run(NPC npc, Player clicker) {
            String cmd = this.command;
            if (this.command.startsWith("say")) {
                cmd = "npc speak " + this.command.replaceFirst("say", "").trim() + " --target <p>";
            }
            if ((cmd.startsWith("npc ") || cmd.startsWith("waypoints ") || cmd.startsWith("wp ")) && !cmd.contains("--id ")) {
                cmd = cmd + " --id <id>";
            }
            String interpolatedCommand = Placeholders.replace(cmd, (CommandSender)clicker, npc);
            if (Messaging.isDebugging()) {
                Messaging.debug("Running command " + interpolatedCommand + " on NPC " + npc.getId() + " clicker " + clicker);
            }
            if (!this.player) {
                Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), interpolatedCommand);
                return;
            }
            boolean wasOp = clicker.isOp();
            if (this.op) {
                clicker.setOp(true);
            }
            if (this.bungeeServer != null) {
                ByteArrayDataOutput out = ByteStreams.newDataOutput();
                out.writeUTF("Connect");
                out.writeUTF(this.bungeeServer);
                clicker.sendPluginMessage(CitizensAPI.getPlugin(), "BungeeCord", out.toByteArray());
            } else {
                try {
                    clicker.chat("/" + interpolatedCommand);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            if (this.op) {
                clicker.setOp(wasOp);
            }
        }
    }

    private static class PlayerNPCCommand {
        @Persist(valueType=Long.class)
        Map<String, Long> lastUsed = Maps.newHashMap();
        @Persist
        Hand lastUsedHand;
        @Persist
        int lastUsedId = -1;
        @Persist
        Map<String, Integer> nUsed = Maps.newHashMap();

        public boolean canUse(CommandTrait trait, Player player, NPCCommand command) {
            long deadline;
            for (String perm : command.perms) {
                if (player.hasPermission(perm)) continue;
                trait.sendErrorMessage(player, CommandTraitError.NO_PERMISSION, null, new Object[0]);
                return false;
            }
            long globalDelay = Settings.Setting.NPC_COMMAND_GLOBAL_COMMAND_DELAY.asLong();
            long currentTimeSec = System.currentTimeMillis() / 1000L;
            String commandKey = command.getEncodedKey();
            if (this.lastUsed.containsKey(commandKey)) {
                deadline = ((Number)this.lastUsed.get(commandKey)).longValue() + (long)command.cooldown + globalDelay;
                if (currentTimeSec < deadline) {
                    long seconds = deadline - currentTimeSec;
                    trait.sendErrorMessage(player, CommandTraitError.ON_COOLDOWN, new TimeVariableFormatter(seconds, TimeUnit.SECONDS), new Object[]{seconds});
                    return false;
                }
                this.lastUsed.remove(commandKey);
            }
            if (command.globalCooldown > 0 && trait.globalCooldowns.containsKey(commandKey)) {
                deadline = ((Number)trait.globalCooldowns.get(commandKey)).longValue() + (long)command.globalCooldown;
                if (currentTimeSec < deadline) {
                    long seconds = deadline - currentTimeSec;
                    trait.sendErrorMessage(player, CommandTraitError.ON_GLOBAL_COOLDOWN, new TimeVariableFormatter(seconds, TimeUnit.SECONDS), new Object[]{seconds});
                    return false;
                }
                trait.globalCooldowns.remove(commandKey);
            }
            int previouslyUsed = this.nUsed.getOrDefault(commandKey, 0);
            if (command.n > 0 && command.n <= previouslyUsed) {
                trait.sendErrorMessage(player, CommandTraitError.MAXIMUM_TIMES_USED, null, new Object[]{command.n});
                return false;
            }
            if (command.cooldown > 0 || globalDelay > 0L) {
                this.lastUsed.put(commandKey, currentTimeSec);
            }
            if (command.globalCooldown > 0) {
                trait.globalCooldowns.put(commandKey, currentTimeSec);
            }
            if (command.n > 0) {
                this.nUsed.put(commandKey, previouslyUsed + 1);
            }
            this.lastUsedId = command.id;
            return true;
        }

        public void prune(Map<String, Long> globalCooldowns, Collection<NPCCommand> commands) {
            long currentTimeSec = System.currentTimeMillis() / 1000L;
            HashSet commandKeys = Sets.newHashSet();
            for (NPCCommand command : commands) {
                String commandKey = command.getEncodedKey();
                commandKeys.add(commandKey);
                Number number = this.lastUsed.get(commandKey);
                if (number != null && number.longValue() + (long)command.cooldown + Settings.Setting.NPC_COMMAND_GLOBAL_COMMAND_DELAY.asLong() <= currentTimeSec) {
                    this.lastUsed.remove(commandKey);
                }
                if (globalCooldowns == null || (number = (Number)globalCooldowns.get(commandKey)) == null || number.longValue() + (long)command.globalCooldown > currentTimeSec) continue;
                globalCooldowns.remove(commandKey);
            }
            HashSet diff = Sets.newHashSet(this.lastUsed.keySet());
            diff.removeAll(commandKeys);
            for (String key : diff) {
                this.lastUsed.remove(key);
                this.nUsed.remove(key);
            }
            if (globalCooldowns != null) {
                diff = Sets.newHashSet(globalCooldowns.keySet());
                diff.removeAll(commandKeys);
                for (String key : diff) {
                    globalCooldowns.remove(key);
                }
            }
        }

        public static boolean requiresTracking(NPCCommand command) {
            return command.globalCooldown > 0 || command.cooldown > 0 || command.n > 0 || command.perms != null && command.perms.size() > 0 || Settings.Setting.NPC_COMMAND_GLOBAL_COMMAND_DELAY.asLong() > 0L;
        }
    }

    private static class TimeVariableFormatter
    implements Function<String, String> {
        private final Map<String, String> map = Maps.newHashMapWithExpectedSize((int)5);

        public TimeVariableFormatter(long source, TimeUnit unit) {
            long seconds = TimeUnit.SECONDS.convert(source, unit);
            long minutes = TimeUnit.MINUTES.convert(source, unit);
            long hours = TimeUnit.HOURS.convert(source, unit);
            long days = TimeUnit.DAYS.convert(source, unit);
            this.map.put("seconds", "" + seconds);
            this.map.put("seconds_over", "" + (seconds - TimeUnit.SECONDS.convert(minutes, TimeUnit.MINUTES)));
            this.map.put("minutes", "" + minutes);
            this.map.put("minutes_over", "" + (minutes - TimeUnit.MINUTES.convert(hours, TimeUnit.HOURS)));
            this.map.put("hours", "" + hours);
            this.map.put("hours_over", "" + (hours - TimeUnit.HOURS.convert(days, TimeUnit.DAYS)));
            this.map.put("days", "" + days);
        }

        @Override
        public String apply(String t) {
            return StrSubstitutor.replace((Object)t, this.map, (String)"{", (String)"}");
        }
    }

    private static class NPCCommandPersister
    implements Persister<NPCCommand> {
        @Override
        public NPCCommand create(DataKey root) {
            ArrayList perms = Lists.newArrayList();
            for (DataKey key : root.getRelative("permissions").getIntegerSubKeys()) {
                perms.add(key.getString(""));
            }
            return new NPCCommand(Integer.parseInt(root.name()), root.getString("command"), Hand.valueOf(root.getString("hand")), Boolean.valueOf(root.getString("player")), Boolean.valueOf(root.getString("op")), root.getInt("cooldown"), perms, root.getInt("n"), root.getInt("delay"), root.getInt("globalcooldown"));
        }

        @Override
        public void save(NPCCommand instance, DataKey root) {
            root.setString("command", instance.command);
            root.setString("hand", instance.hand.name());
            root.setBoolean("player", instance.player);
            root.setBoolean("op", instance.op);
            root.setInt("cooldown", instance.cooldown);
            root.setInt("globalcooldown", instance.globalCooldown);
            root.setInt("n", instance.n);
            root.setInt("delay", instance.delay);
            for (int i = 0; i < instance.perms.size(); ++i) {
                root.setString("permissions." + i, instance.perms.get(i));
            }
        }
    }

    @Menu(title="Drag items for requirements", type=InventoryType.CHEST, dimensions={5, 9})
    public static class ItemRequirementGUI
    extends InventoryMenuPage {
        private Inventory inventory;
        private CommandTrait trait;

        private ItemRequirementGUI() {
            throw new UnsupportedOperationException();
        }

        public ItemRequirementGUI(CommandTrait trait) {
            this.trait = trait;
        }

        @Override
        public void initialise(MenuContext ctx) {
            this.inventory = ctx.getInventory();
            for (ItemStack stack : this.trait.itemRequirements) {
                this.inventory.addItem(new ItemStack[]{stack.clone()});
            }
        }

        @Override
        public void onClick(InventoryMenuSlot slot, InventoryClickEvent event) {
            event.setCancelled(false);
        }

        @Override
        public void onClose(HumanEntity player) {
            ArrayList requirements = Lists.newArrayList();
            for (ItemStack stack : this.inventory.getContents()) {
                if (stack == null || stack.getType() == Material.AIR) continue;
                requirements.add(stack);
            }
            this.trait.itemRequirements.clear();
            this.trait.itemRequirements.addAll(requirements);
        }
    }
}

