/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.trait.ClickRedirectTrait;
import org.bukkit.entity.ArmorStand;
import org.bukkit.util.EulerAngle;

@TraitName(value="armorstandtrait")
public class ArmorStandTrait
extends Trait {
    @Persist
    private EulerAngle body;
    @Persist
    private boolean gravity = true;
    @Persist
    private boolean hasarms = true;
    @Persist
    private boolean hasbaseplate = true;
    @Persist
    private EulerAngle head;
    @Persist
    private EulerAngle leftArm;
    @Persist
    private EulerAngle leftLeg;
    @Persist
    private boolean marker;
    @Persist
    private EulerAngle rightArm;
    @Persist
    private EulerAngle rightLeg;
    @Persist
    private boolean small;
    @Persist
    private boolean visible = true;

    public ArmorStandTrait() {
        super("armorstandtrait");
    }

    public boolean getGravity() {
        return this.gravity;
    }

    public boolean getHasArms() {
        return this.hasarms;
    }

    public boolean getHasBaseplate() {
        return this.hasbaseplate;
    }

    public boolean isMarker() {
        return this.marker;
    }

    public boolean isSmall() {
        return this.small;
    }

    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void onPreSpawn() {
        this.onSpawn();
    }

    @Override
    public void onSpawn() {
        if (!(this.npc.getEntity() instanceof ArmorStand)) {
            return;
        }
        ArmorStand entity = (ArmorStand)this.npc.getEntity();
        if (this.leftArm != null) {
            entity.setLeftArmPose(this.leftArm);
        }
        if (this.leftLeg != null) {
            entity.setLeftLegPose(this.leftLeg);
        }
        if (this.rightArm != null) {
            entity.setRightArmPose(this.rightArm);
        }
        if (this.rightLeg != null) {
            entity.setRightLegPose(this.rightLeg);
        }
        if (this.body != null) {
            entity.setBodyPose(this.body);
        }
        if (this.head != null) {
            entity.setHeadPose(this.head);
        }
        entity.setVisible(this.visible);
        entity.setGravity(this.gravity);
        entity.setArms(this.hasarms);
        entity.setBasePlate(this.hasbaseplate);
        entity.setSmall(this.small);
        entity.setMarker(this.marker);
    }

    @Override
    public void run() {
        if (!(this.npc.getEntity() instanceof ArmorStand)) {
            return;
        }
        ArmorStand entity = (ArmorStand)this.npc.getEntity();
        this.body = entity.getBodyPose();
        this.leftArm = entity.getLeftArmPose();
        this.leftLeg = entity.getLeftLegPose();
        this.rightArm = entity.getRightArmPose();
        this.rightLeg = entity.getRightLegPose();
        this.head = entity.getHeadPose();
        entity.setVisible(this.visible);
        entity.setGravity(this.gravity);
        entity.setArms(this.hasarms);
        entity.setBasePlate(this.hasbaseplate);
        entity.setSmall(this.small);
        entity.setMarker(this.marker);
    }

    public void setAsHelperEntity(NPC parent) {
        this.npc.addTrait(new ClickRedirectTrait(this.npc));
        this.setAsPointEntity();
    }

    public void setAsHelperEntityWithName(NPC parent) {
        this.npc.addTrait(new ClickRedirectTrait(this.npc));
        this.setAsPointEntityWithName();
    }

    public void setAsPointEntity() {
        this.setGravity(false);
        this.setHasArms(false);
        this.setHasBaseplate(false);
        this.setSmall(true);
        this.setMarker(true);
        this.setVisible(false);
        this.npc.setProtected(true);
        this.npc.data().set("nameplate-visible", (Object)false);
    }

    public void setAsPointEntityWithName() {
        this.setAsPointEntity();
        this.npc.data().set("nameplate-visible", (Object)true);
    }

    public void setGravity(boolean gravity) {
        this.gravity = gravity;
    }

    public void setHasArms(boolean arms) {
        this.hasarms = arms;
    }

    public void setHasBaseplate(boolean baseplate) {
        this.hasbaseplate = baseplate;
    }

    public void setMarker(boolean marker) {
        this.marker = marker;
    }

    public void setSmall(boolean small) {
        this.small = small;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }
}

