/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import java.util.ArrayList;
import java.util.List;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.util.Anchor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.event.EventHandler;
import org.bukkit.event.world.WorldLoadEvent;

@TraitName(value="anchors")
public class Anchors
extends Trait {
    private final List<Anchor> anchors = new ArrayList<Anchor>();

    public Anchors() {
        super("anchors");
    }

    public boolean addAnchor(String name, Location location) {
        Anchor newAnchor = new Anchor(name, location);
        if (this.anchors.contains(newAnchor)) {
            return false;
        }
        this.anchors.add(newAnchor);
        return true;
    }

    @EventHandler
    private void checkWorld(WorldLoadEvent event) {
        for (Anchor anchor : this.anchors) {
            if (anchor.isLoaded()) continue;
            anchor.load();
        }
    }

    public Anchor getAnchor(String name) {
        for (Anchor anchor : this.anchors) {
            if (!anchor.getName().equalsIgnoreCase(name)) continue;
            return anchor;
        }
        return null;
    }

    public List<Anchor> getAnchors() {
        return this.anchors;
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        for (DataKey sub : key.getRelative("list").getIntegerSubKeys()) {
            String[] parts = sub.getString("").split(";");
            try {
                Location location = new Location(Bukkit.getServer().getWorld(parts[1]), Double.valueOf(parts[2]).doubleValue(), Double.valueOf(parts[3]).doubleValue(), Double.valueOf(parts[4]).doubleValue());
                this.anchors.add(new Anchor(parts[0], location));
            }
            catch (NumberFormatException e) {
                Messaging.logTr("citizens.notifications.skipping-invalid-anchor", sub.name(), e.getMessage());
            }
            catch (NullPointerException e) {
                this.anchors.add(new Anchor(parts[0], sub.getString("").split(";", 2)[1]));
            }
        }
    }

    public boolean removeAnchor(Anchor anchor) {
        if (this.anchors.contains(anchor)) {
            this.anchors.remove(anchor);
            return true;
        }
        return false;
    }

    @Override
    public void save(DataKey key) {
        key.removeKey("list");
        for (int i = 0; i < this.anchors.size(); ++i) {
            key.setString("list." + String.valueOf(i), this.anchors.get(i).stringValue());
        }
    }
}

