/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.skin;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.util.NMS;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class TabListRemover {
    private final Map<UUID, PlayerEntry> pending = new HashMap<UUID, PlayerEntry>(Math.max(128, Math.min(1024, Bukkit.getMaxPlayers() / 2)));

    TabListRemover() {
        Bukkit.getScheduler().runTaskTimer(CitizensAPI.getPlugin(), (Runnable)new Sender(), 2L, 2L);
    }

    public void cancelPackets(Player player) {
        Preconditions.checkNotNull((Object)player);
        PlayerEntry entry = this.pending.remove(player.getUniqueId());
        if (entry == null) {
            return;
        }
        for (SkinnableEntity entity : entry.toRemove) {
            entity.getSkinTracker().notifyRemovePacketCancelled(player.getUniqueId());
        }
    }

    public void cancelPackets(Player player, SkinnableEntity skinnable) {
        Preconditions.checkNotNull((Object)player);
        Preconditions.checkNotNull((Object)skinnable);
        PlayerEntry entry = this.pending.get(player.getUniqueId());
        if (entry == null) {
            return;
        }
        if (entry.toRemove.remove(skinnable)) {
            skinnable.getSkinTracker().notifyRemovePacketCancelled(player.getUniqueId());
        }
        if (entry.toRemove.isEmpty()) {
            this.pending.remove(player.getUniqueId());
        }
    }

    private PlayerEntry getEntry(Player player) {
        PlayerEntry entry = this.pending.get(player.getUniqueId());
        if (entry == null) {
            entry = new PlayerEntry(player);
            this.pending.put(player.getUniqueId(), entry);
        }
        return entry;
    }

    public void sendPacket(Player player, SkinnableEntity entity) {
        Preconditions.checkNotNull((Object)player);
        Preconditions.checkNotNull((Object)entity);
        PlayerEntry entry = this.getEntry(player);
        entry.toRemove.add(entity);
    }

    private class Sender
    implements Runnable {
        private Sender() {
        }

        @Override
        public void run() {
            int maxPacketEntries = Settings.Setting.MAX_PACKET_ENTRIES.asInt();
            Iterator entryIterator = TabListRemover.this.pending.entrySet().iterator();
            while (entryIterator.hasNext()) {
                Map.Entry mapEntry = entryIterator.next();
                PlayerEntry entry = (PlayerEntry)mapEntry.getValue();
                int listSize = Math.min(maxPacketEntries, entry.toRemove.size());
                boolean sendAll = listSize == entry.toRemove.size();
                ArrayList<SkinnableEntity> skinnableList = new ArrayList<SkinnableEntity>(listSize);
                Iterator<SkinnableEntity> skinIterator = entry.toRemove.iterator();
                for (int i = 0; skinIterator.hasNext() && i < maxPacketEntries; ++i) {
                    SkinnableEntity skinnable = skinIterator.next();
                    skinnableList.add(skinnable);
                    skinIterator.remove();
                }
                if (entry.player.isOnline()) {
                    NMS.sendTabListRemove(entry.player, skinnableList);
                }
                for (SkinnableEntity entity : skinnableList) {
                    entity.getSkinTracker().notifyRemovePacketSent(entry.player.getUniqueId());
                }
                if (!sendAll) continue;
                entryIterator.remove();
            }
        }
    }

    private class PlayerEntry {
        Player player;
        Set<SkinnableEntity> toRemove = new HashSet<SkinnableEntity>(30);

        PlayerEntry(Player player) {
            this.player = player;
        }
    }
}

