/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.skin;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.npc.skin.Skin;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.npc.skin.TabListRemover;
import net.citizensnpcs.util.NMS;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class SkinPacketTracker {
    private final SkinnableEntity entity;
    private final Map<UUID, PlayerEntry> inProgress = new HashMap<UUID, PlayerEntry>(Math.max(128, Math.min(1024, Bukkit.getMaxPlayers() / 2)));
    private boolean isRemoved;
    private Skin skin;
    private static final Location CACHE_LOCATION = new Location(null, 0.0, 0.0, 0.0);
    private static PlayerListener LISTENER;
    private static final int PACKET_DELAY_REMOVE = 2;
    private static final TabListRemover TAB_LIST_REMOVER;

    public SkinPacketTracker(SkinnableEntity entity) {
        Preconditions.checkNotNull((Object)entity);
        this.entity = entity;
        this.skin = Skin.get(entity);
        if (LISTENER == null) {
            LISTENER = new PlayerListener();
            Bukkit.getPluginManager().registerEvents((Listener)LISTENER, CitizensAPI.getPlugin());
        }
    }

    public Skin getSkin() {
        return this.skin;
    }

    void notifyRemovePacketCancelled(UUID playerId) {
        this.inProgress.remove(playerId);
    }

    void notifyRemovePacketSent(UUID playerId) {
        PlayerEntry entry = this.inProgress.get(playerId);
        if (entry == null) {
            return;
        }
        if (entry.removeCount == 0) {
            return;
        }
        --entry.removeCount;
        if (entry.removeCount == 0) {
            this.inProgress.remove(playerId);
        } else {
            this.scheduleRemovePacket(entry);
        }
    }

    public void notifySkinChange(boolean forceUpdate) {
        this.skin = Skin.get(this.entity, forceUpdate);
        this.skin.applyAndRespawn(this.entity);
    }

    public void onRemoveNPC() {
        this.isRemoved = true;
        Collection players = Bukkit.getOnlinePlayers();
        for (Player player : players) {
            if (player.hasMetadata("NPC")) continue;
            NMS.sendTabListRemove(player, this.entity.getBukkitEntity());
            TAB_LIST_REMOVER.sendPacket(player, this.entity);
        }
    }

    public void onSpawnNPC() {
        this.isRemoved = false;
        new BukkitRunnable(){

            public void run() {
                if (!SkinPacketTracker.this.entity.getNPC().isSpawned()) {
                    return;
                }
                double viewDistance = Settings.Setting.NPC_SKIN_VIEW_DISTANCE.asDouble();
                SkinPacketTracker.this.updateNearbyViewers(viewDistance);
            }
        }.runTaskLater(CitizensAPI.getPlugin(), 15L);
    }

    private void scheduleRemovePacket(final PlayerEntry entry) {
        if (this.isRemoved || !CitizensAPI.hasImplementation() || !CitizensAPI.getPlugin().isEnabled()) {
            return;
        }
        entry.removeTask = Bukkit.getScheduler().runTaskLater(CitizensAPI.getPlugin(), new Runnable(){

            @Override
            public void run() {
                if (SkinPacketTracker.this.shouldRemoveFromTabList()) {
                    TAB_LIST_REMOVER.sendPacket(entry.player, SkinPacketTracker.this.entity);
                }
            }
        }, 2L);
    }

    private void scheduleRemovePacket(PlayerEntry entry, int count) {
        if (!this.shouldRemoveFromTabList()) {
            return;
        }
        entry.removeCount = count;
        this.scheduleRemovePacket(entry);
    }

    private boolean shouldRemoveFromTabList() {
        return this.entity.getNPC().data().get("removefromtablist", Boolean.valueOf(Settings.Setting.DISABLE_TABLIST.asBoolean()));
    }

    public void updateNearbyViewers(double radius) {
        World world = this.entity.getBukkitEntity().getWorld();
        Player from = this.entity.getBukkitEntity();
        Location location = from.getLocation();
        for (Player player : world.getPlayers()) {
            if (player == null || player.hasMetadata("NPC") || !location.getWorld().equals(player.getLocation(CACHE_LOCATION).getWorld()) || !player.canSee(from) || location.distance(CACHE_LOCATION) > radius) continue;
            this.updateViewer(player);
        }
    }

    public void updateViewer(Player player) {
        Preconditions.checkNotNull((Object)player);
        if (this.isRemoved || player.hasMetadata("NPC")) {
            return;
        }
        PlayerEntry entry = this.inProgress.get(player.getUniqueId());
        if (entry != null) {
            entry.cancel();
        } else {
            entry = new PlayerEntry(player);
        }
        TAB_LIST_REMOVER.cancelPackets(player, this.entity);
        this.inProgress.put(player.getUniqueId(), entry);
        this.skin.apply(this.entity);
        NMS.sendTabListAdd(player, this.entity.getBukkitEntity());
        this.scheduleRemovePacket(entry, 2);
    }

    static {
        TAB_LIST_REMOVER = new TabListRemover();
    }

    private static class PlayerListener
    implements Listener {
        private PlayerListener() {
        }

        @EventHandler
        private void onPlayerQuit(PlayerQuitEvent event) {
            TAB_LIST_REMOVER.cancelPackets(event.getPlayer());
        }
    }

    private class PlayerEntry {
        Player player;
        int removeCount;
        BukkitTask removeTask;

        PlayerEntry(Player player) {
            this.player = player;
        }

        void cancel() {
            if (this.removeTask != null) {
                this.removeTask.cancel();
            }
            this.removeCount = 0;
        }
    }
}

