/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.skin;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.SpawnReason;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.npc.profile.ProfileFetchHandler;
import net.citizensnpcs.npc.profile.ProfileFetcher;
import net.citizensnpcs.npc.profile.ProfileRequest;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.trait.SkinTrait;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.scheduler.BukkitTask;

public class Skin {
    private boolean fetching;
    private int fetchRetries = -1;
    private boolean hasFetched;
    private volatile boolean isValid = true;
    private final Map<SkinnableEntity, Void> pending = new WeakHashMap<SkinnableEntity, Void>(15);
    private BukkitTask retryTask;
    private volatile Property skinData;
    private volatile UUID skinId;
    private final String skinName;
    private static final Map<String, Skin> CACHE = new HashMap<String, Skin>(20);
    public static final String CACHED_SKIN_UUID_METADATA = "cached-skin-uuid";
    public static final String CACHED_SKIN_UUID_NAME_METADATA = "cached-skin-uuid-name";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Skin(String skinName) {
        this.skinName = skinName.toLowerCase();
        Map<String, Skin> map = CACHE;
        synchronized (map) {
            if (CACHE.containsKey(this.skinName)) {
                throw new IllegalArgumentException("There is already a skin named " + skinName);
            }
            CACHE.put(this.skinName, this);
        }
    }

    public boolean apply(SkinnableEntity entity) {
        Preconditions.checkNotNull((Object)entity);
        NPC npc = entity.getNPC();
        SkinTrait skinTrait = npc.getOrAddTrait(SkinTrait.class);
        String cachedName = (String)npc.data().get(CACHED_SKIN_UUID_NAME_METADATA);
        String texture = skinTrait.getTexture();
        if (this.skinName.equals(cachedName) && texture != null && !texture.equals("cache")) {
            Property localData = new Property("textures", texture, skinTrait.getSignature());
            Skin.setNPCTexture(entity, localData);
            if (entity.getNPC().data().has("player-skin-use-latest")) {
                entity.getNPC().data().remove("player-skin-use-latest");
            }
            if (!skinTrait.shouldUpdateSkins()) {
                return true;
            }
        }
        if (!this.hasSkinData()) {
            String defaultSkinName = ChatColor.stripColor((String)npc.getName()).toLowerCase();
            if (npc.hasTrait(SkinTrait.class) && this.skinName.equals(defaultSkinName) && !npc.getOrAddTrait(SkinTrait.class).fetchDefaultSkin()) {
                return false;
            }
            if (this.hasFetched) {
                return true;
            }
            if (!this.fetching) {
                this.fetch();
            }
            this.pending.put(entity, null);
            return false;
        }
        Skin.setNPCSkinData(entity, this.skinName, this.skinId, this.skinData);
        return true;
    }

    public void applyAndRespawn(SkinnableEntity entity) {
        Preconditions.checkNotNull((Object)entity);
        if (!this.apply(entity)) {
            return;
        }
        final NPC npc = entity.getNPC();
        if (!npc.isSpawned()) {
            return;
        }
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), new Runnable(){

            @Override
            public void run() {
                npc.despawn(DespawnReason.PENDING_RESPAWN);
                npc.spawn(npc.getStoredLocation(), SpawnReason.RESPAWN);
            }
        });
    }

    private void fetch() {
        final int maxRetries = Settings.Setting.MAX_NPC_SKIN_RETRIES.asInt();
        if (maxRetries > -1 && this.fetchRetries >= maxRetries) {
            if (Messaging.isDebugging()) {
                Messaging.debug("Reached max skin fetch retries for '" + this.skinName + "'");
            }
            return;
        }
        if (this.skinName.length() < 3 || this.skinName.length() > 16) {
            if (Messaging.isDebugging()) {
                Messaging.debug("Skin name invalid length '" + this.skinName + "'");
            }
            return;
        }
        if (this.skinName.toLowerCase().startsWith("cit-")) {
            return;
        }
        this.fetching = true;
        ProfileFetcher.fetch(this.skinName, new ProfileFetchHandler(){

            @Override
            public void onResult(ProfileRequest request) {
                Skin.this.hasFetched = true;
                switch (request.getResult()) {
                    case NOT_FOUND: {
                        Skin.this.isValid = false;
                        break;
                    }
                    case TOO_MANY_REQUESTS: {
                        if (maxRetries == 0) break;
                        Skin.this.fetchRetries++;
                        long delay = Settings.Setting.NPC_SKIN_RETRY_DELAY.asLong();
                        Skin.this.retryTask = Bukkit.getScheduler().runTaskLater(CitizensAPI.getPlugin(), new Runnable(){

                            @Override
                            public void run() {
                                Skin.this.fetch();
                            }
                        }, delay);
                        if (!Messaging.isDebugging()) break;
                        Messaging.debug("Retrying skin fetch for '" + Skin.this.skinName + "' in " + delay + " ticks.");
                        break;
                    }
                    case SUCCESS: {
                        GameProfile profile = request.getProfile();
                        Skin.this.setData(profile);
                        break;
                    }
                }
            }
        });
    }

    private void fetchForced() {
        final int maxRetries = Settings.Setting.MAX_NPC_SKIN_RETRIES.asInt();
        if (maxRetries > -1 && this.fetchRetries >= maxRetries) {
            if (Messaging.isDebugging()) {
                Messaging.debug("Reached max skin fetch retries for '" + this.skinName + "'");
            }
            return;
        }
        if (this.skinName.length() < 3 || this.skinName.length() > 16) {
            if (Messaging.isDebugging()) {
                Messaging.debug("Skin name invalid length '" + this.skinName + "'");
            }
            return;
        }
        if (this.skinName.toLowerCase().startsWith("cit-")) {
            return;
        }
        this.fetching = true;
        ProfileFetcher.fetchForced(this.skinName, new ProfileFetchHandler(){

            @Override
            public void onResult(ProfileRequest request) {
                Skin.this.hasFetched = true;
                switch (request.getResult()) {
                    case NOT_FOUND: {
                        Skin.this.isValid = false;
                        break;
                    }
                    case TOO_MANY_REQUESTS: {
                        if (maxRetries == 0) break;
                        Skin.this.fetchRetries++;
                        long delay = Settings.Setting.NPC_SKIN_RETRY_DELAY.asLong();
                        Skin.this.retryTask = Bukkit.getScheduler().runTaskLater(CitizensAPI.getPlugin(), new Runnable(){

                            @Override
                            public void run() {
                                Skin.this.fetchForced();
                            }
                        }, delay);
                        if (!Messaging.isDebugging()) break;
                        Messaging.debug("Retrying skin fetch for '" + Skin.this.skinName + "' in " + delay + " ticks.");
                        break;
                    }
                    case SUCCESS: {
                        GameProfile profile = request.getProfile();
                        Skin.this.setData(profile);
                        break;
                    }
                }
            }
        });
    }

    @Nullable
    public UUID getSkinId() {
        return this.skinId;
    }

    public String getSkinName() {
        return this.skinName;
    }

    public boolean hasSkinData() {
        return this.skinData != null;
    }

    public boolean isValid() {
        return this.isValid;
    }

    private void setData(@Nullable GameProfile profile) {
        if (profile == null) {
            this.isValid = false;
            return;
        }
        if (!profile.getName().toLowerCase().equals(this.skinName)) {
            Messaging.debug("GameProfile name (" + profile.getName() + ") and skin name (" + this.skinName + ") do not match. Has the user renamed recently?");
        }
        this.skinId = profile.getId();
        this.skinData = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
        ArrayList<SkinnableEntity> entities = new ArrayList<SkinnableEntity>(this.pending.keySet());
        for (SkinnableEntity entity : entities) {
            this.applyAndRespawn(entity);
        }
        this.pending.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        Map<String, Skin> map = CACHE;
        synchronized (map) {
            for (Skin skin : CACHE.values()) {
                skin.pending.clear();
                if (skin.retryTask == null) continue;
                skin.retryTask.cancel();
            }
            CACHE.clear();
        }
    }

    public static Skin get(SkinnableEntity entity) {
        return Skin.get(entity, false);
    }

    public static Skin get(SkinnableEntity entity, boolean forceUpdate) {
        Preconditions.checkNotNull((Object)entity);
        String skinName = entity.getSkinName().toLowerCase();
        return Skin.get(skinName, forceUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Skin get(String skinName, boolean forceUpdate) {
        Skin skin;
        Preconditions.checkNotNull((Object)skinName);
        skinName = skinName.toLowerCase();
        Map<String, Skin> map = CACHE;
        synchronized (map) {
            skin = CACHE.get(skinName);
        }
        if (skin == null) {
            skin = new Skin(skinName);
        } else if (forceUpdate) {
            skin.fetchForced();
        }
        return skin;
    }

    private static void setNPCSkinData(SkinnableEntity entity, String skinName, UUID skinId, Property skinProperty) {
        NPC npc = entity.getNPC();
        SkinTrait skinTrait = npc.getOrAddTrait(SkinTrait.class);
        npc.data().setPersistent(CACHED_SKIN_UUID_NAME_METADATA, (Object)skinName);
        npc.data().setPersistent(CACHED_SKIN_UUID_METADATA, (Object)skinId.toString());
        if (skinProperty.getValue() != null) {
            skinTrait.setTexture(skinProperty.getValue(), skinProperty.getSignature() == null ? "" : skinProperty.getSignature());
            Skin.setNPCTexture(entity, skinProperty);
        } else {
            skinTrait.clearTexture();
        }
    }

    private static void setNPCTexture(SkinnableEntity entity, Property skinProperty) {
        GameProfile profile = entity.getProfile();
        Property current = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
        if (current != null && current.getValue().equals(skinProperty.getValue()) && current.getSignature() != null && current.getSignature().equals(skinProperty.getSignature())) {
            return;
        }
        profile.getProperties().removeAll((Object)"textures");
        profile.getProperties().put((Object)"textures", (Object)skinProperty);
    }
}

