/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.profile;

import com.google.common.base.Preconditions;
import com.mojang.authlib.GameProfile;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.annotation.Nullable;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.npc.profile.ProfileFetchHandler;
import net.citizensnpcs.npc.profile.ProfileFetchResult;
import org.bukkit.Bukkit;

public class ProfileRequest {
    private Deque<ProfileFetchHandler> handlers;
    private final String playerName;
    private GameProfile profile;
    private volatile ProfileFetchResult result = ProfileFetchResult.PENDING;

    public ProfileRequest(String playerName, ProfileFetchHandler handler) {
        Preconditions.checkNotNull((Object)playerName);
        this.playerName = playerName;
        if (handler != null) {
            this.addHandler(handler);
        }
    }

    public void addHandler(ProfileFetchHandler handler) {
        Preconditions.checkNotNull((Object)handler);
        if (this.result != ProfileFetchResult.PENDING) {
            handler.onResult(this);
            return;
        }
        if (this.handlers == null) {
            this.handlers = new ArrayDeque<ProfileFetchHandler>();
        }
        this.handlers.addLast(handler);
    }

    public String getPlayerName() {
        return this.playerName;
    }

    @Nullable
    public GameProfile getProfile() {
        return this.profile;
    }

    public ProfileFetchResult getResult() {
        return this.result;
    }

    void setResult(final @Nullable GameProfile profile, final ProfileFetchResult result) {
        if (!CitizensAPI.hasImplementation()) {
            return;
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), new Runnable(){

            @Override
            public void run() {
                ProfileRequest.this.profile = profile;
                ProfileRequest.this.result = result;
                if (ProfileRequest.this.handlers == null) {
                    return;
                }
                while (!ProfileRequest.this.handlers.isEmpty()) {
                    ((ProfileFetchHandler)ProfileRequest.this.handlers.removeFirst()).onResult(ProfileRequest.this);
                }
                ProfileRequest.this.handlers = null;
            }
        });
    }
}

