/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.profile;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.npc.profile.ProfileFetchHandler;
import net.citizensnpcs.npc.profile.ProfileFetchThread;
import org.bukkit.Bukkit;
import org.bukkit.scheduler.BukkitTask;

public class ProfileFetcher {
    private static ProfileFetchThread PROFILE_THREAD;
    private static BukkitTask THREAD_TASK;

    ProfileFetcher() {
    }

    public static void fetch(String name, @Nullable ProfileFetchHandler handler) {
        Preconditions.checkNotNull((Object)name);
        if (PROFILE_THREAD == null) {
            ProfileFetcher.initThread();
        }
        PROFILE_THREAD.fetch(name, handler);
    }

    public static void fetchForced(String name, ProfileFetchHandler handler) {
        Preconditions.checkNotNull((Object)name);
        if (PROFILE_THREAD == null) {
            ProfileFetcher.initThread();
        }
        PROFILE_THREAD.fetchForced(name, handler);
    }

    private static void initThread() {
        if (THREAD_TASK != null) {
            THREAD_TASK.cancel();
        }
        PROFILE_THREAD = new ProfileFetchThread();
        THREAD_TASK = Bukkit.getScheduler().runTaskTimerAsynchronously(CitizensAPI.getPlugin(), (Runnable)PROFILE_THREAD, 21L, 20L);
    }

    public static void reset() {
        ProfileFetcher.initThread();
    }
}

