/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.profile;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.ProfileLookupCallback;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.npc.profile.ProfileFetchHandler;
import net.citizensnpcs.npc.profile.ProfileFetchResult;
import net.citizensnpcs.npc.profile.ProfileRequest;
import net.citizensnpcs.util.NMS;
import org.bukkit.Bukkit;

class ProfileFetchThread
implements Runnable {
    private final Deque<ProfileRequest> queue = new ArrayDeque<ProfileRequest>();
    private final Map<String, ProfileRequest> requested = new HashMap<String, ProfileRequest>(40);
    private final Object sync = new Object();

    ProfileFetchThread() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fetch(String name, @Nullable ProfileFetchHandler handler) {
        ProfileRequest request;
        Preconditions.checkNotNull((Object)name);
        name = name.toLowerCase();
        Object object = this.sync;
        synchronized (object) {
            request = this.requested.get(name);
            if (request == null) {
                request = new ProfileRequest(name, handler);
                this.queue.add(request);
                this.requested.put(name, request);
                return;
            }
            if (request.getResult() == ProfileFetchResult.TOO_MANY_REQUESTS) {
                this.queue.add(request);
            }
        }
        if (handler != null) {
            if (request.getResult() == ProfileFetchResult.PENDING || request.getResult() == ProfileFetchResult.TOO_MANY_REQUESTS) {
                ProfileFetchThread.addHandler(request, handler);
            } else {
                ProfileFetchThread.sendResult(handler, request);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchForced(String name, ProfileFetchHandler handler) {
        ProfileRequest request;
        Preconditions.checkNotNull((Object)name);
        name = name.toLowerCase();
        Object object = this.sync;
        synchronized (object) {
            request = this.requested.get(name);
            if (request != null) {
                if (request.getResult() == ProfileFetchResult.TOO_MANY_REQUESTS) {
                    this.queue.add(request);
                } else {
                    this.requested.remove(name);
                    this.queue.remove(request);
                    request = null;
                }
            }
            if (request == null) {
                request = new ProfileRequest(name, handler);
                this.queue.add(request);
                this.requested.put(name, request);
                return;
            }
        }
        if (handler != null) {
            if (request.getResult() == ProfileFetchResult.PENDING || request.getResult() == ProfileFetchResult.TOO_MANY_REQUESTS) {
                ProfileFetchThread.addHandler(request, handler);
            } else {
                ProfileFetchThread.sendResult(handler, request);
            }
        }
    }

    private void fetchRequests(final Collection<ProfileRequest> requests) {
        Preconditions.checkNotNull(requests);
        GameProfileRepository repo = NMS.getGameProfileRepository();
        String[] playerNames = new String[requests.size()];
        int i = 0;
        for (ProfileRequest request : requests) {
            playerNames[i++] = request.getPlayerName();
        }
        repo.findProfilesByNames(playerNames, Agent.MINECRAFT, new ProfileLookupCallback(){

            public void onProfileLookupFailed(GameProfile profile, Exception e) {
                ProfileRequest request;
                if (Messaging.isDebugging()) {
                    Messaging.debug("Profile lookup for player '" + profile.getName() + "' failed2: " + ProfileFetchThread.getExceptionMsg(e));
                    Messaging.debug(Throwables.getStackTraceAsString((Throwable)e));
                }
                if ((request = ProfileFetchThread.findRequest(profile.getName(), requests)) == null) {
                    return;
                }
                if (ProfileFetchThread.isProfileNotFound(e)) {
                    request.setResult(null, ProfileFetchResult.NOT_FOUND);
                } else if (ProfileFetchThread.isTooManyRequests(e)) {
                    request.setResult(null, ProfileFetchResult.TOO_MANY_REQUESTS);
                } else {
                    request.setResult(null, ProfileFetchResult.FAILED);
                }
            }

            public void onProfileLookupSucceeded(GameProfile profile) {
                ProfileRequest request;
                if (Messaging.isDebugging()) {
                    Messaging.debug("Fetched profile " + profile.getId() + " for player " + profile.getName());
                }
                if ((request = ProfileFetchThread.findRequest(profile.getName(), requests)) == null) {
                    return;
                }
                try {
                    request.setResult(NMS.fillProfileProperties(profile, true), ProfileFetchResult.SUCCESS);
                }
                catch (Throwable e) {
                    if (Messaging.isDebugging()) {
                        Messaging.debug("Profile lookup for player '" + profile.getName() + "' failed: " + ProfileFetchThread.getExceptionMsg(e) + " " + ProfileFetchThread.isTooManyRequests(e));
                        Messaging.debug(Throwables.getStackTraceAsString((Throwable)e));
                    }
                    if (ProfileFetchThread.isTooManyRequests(e)) {
                        request.setResult(null, ProfileFetchResult.TOO_MANY_REQUESTS);
                    }
                    request.setResult(null, ProfileFetchResult.FAILED);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList<ProfileRequest> requests;
        Object object = this.sync;
        synchronized (object) {
            if (this.queue.isEmpty()) {
                return;
            }
            requests = new ArrayList<ProfileRequest>(this.queue);
            this.queue.clear();
        }
        this.fetchRequests(requests);
    }

    private static void addHandler(final ProfileRequest request, final ProfileFetchHandler handler) {
        Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), new Runnable(){

            @Override
            public void run() {
                request.addHandler(handler);
            }
        }, 1L);
    }

    @Nullable
    private static ProfileRequest findRequest(String name, Collection<ProfileRequest> requests) {
        name = name.toLowerCase();
        for (ProfileRequest request : requests) {
            if (!request.getPlayerName().equals(name)) continue;
            return request;
        }
        return null;
    }

    private static String getExceptionMsg(Throwable e) {
        return Throwables.getRootCause((Throwable)e).getMessage();
    }

    private static boolean isProfileNotFound(Exception e) {
        String message = e.getMessage();
        String cause = e.getCause() != null ? e.getCause().getMessage() : null;
        return message != null && message.contains("did not find") || cause != null && cause.contains("did not find");
    }

    private static boolean isTooManyRequests(Throwable e) {
        String message = e.getMessage();
        String cause = e.getCause() != null ? e.getCause().getMessage() : null;
        return message != null && message.contains("too many requests") || cause != null && cause.contains("too many requests");
    }

    private static void sendResult(final ProfileFetchHandler handler, final ProfileRequest request) {
        Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), new Runnable(){

            @Override
            public void run() {
                handler.onResult(request);
            }
        }, 1L);
    }
}

