/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.ai.speech;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import net.citizensnpcs.api.ai.speech.SpeechFactory;
import net.citizensnpcs.api.ai.speech.Talkable;
import net.citizensnpcs.api.ai.speech.VocalChord;
import net.citizensnpcs.npc.ai.speech.Chat;
import net.citizensnpcs.npc.ai.speech.TalkableEntity;
import org.bukkit.entity.Entity;

public class CitizensSpeechFactory
implements SpeechFactory {
    private final Map<String, Class<? extends VocalChord>> registered = new HashMap<String, Class<? extends VocalChord>>();

    public CitizensSpeechFactory() {
        this.register(Chat.class, "chat");
    }

    @Override
    public VocalChord getVocalChord(Class<? extends VocalChord> clazz) {
        Preconditions.checkNotNull(clazz, (Object)"class cannot be null");
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public VocalChord getVocalChord(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        if (name.equalsIgnoreCase("chat")) {
            return new Chat();
        }
        if (this.isRegistered(name)) {
            try {
                return this.registered.get(name.toLowerCase()).newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public String getVocalChordName(Class<? extends VocalChord> clazz) {
        for (Map.Entry<String, Class<? extends VocalChord>> vocalChord : this.registered.entrySet()) {
            if (vocalChord.getValue() != clazz) continue;
            return vocalChord.getKey();
        }
        return null;
    }

    @Override
    public boolean isRegistered(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        return this.registered.containsKey(name.toLowerCase());
    }

    @Override
    public Talkable newTalkableEntity(Entity entity) {
        if (entity == null) {
            return null;
        }
        return new TalkableEntity(entity);
    }

    @Override
    public void register(Class<? extends VocalChord> clazz, String name) {
        Preconditions.checkNotNull((Object)name, (Object)"info cannot be null");
        Preconditions.checkNotNull(clazz, (Object)"vocalchord cannot be null");
        if (this.registered.containsKey(name.toLowerCase())) {
            throw new IllegalArgumentException("vocalchord name already registered");
        }
        this.registered.put(name.toLowerCase(), clazz);
    }
}

