/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.ai.speech;

import java.util.ArrayList;
import java.util.List;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.speech.SpeechContext;
import net.citizensnpcs.api.ai.speech.Talkable;
import net.citizensnpcs.api.ai.speech.VocalChord;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.npc.ai.speech.TalkableEntity;
import org.bukkit.entity.Entity;

public class Chat
implements VocalChord {
    @Override
    public String getName() {
        return "chat";
    }

    @Override
    public void talk(SpeechContext context) {
        if (context.getTalker() == null) {
            return;
        }
        NPC npc = CitizensAPI.getNPCRegistry().getNPC(context.getTalker().getEntity());
        if (npc == null) {
            return;
        }
        if (!context.hasRecipients()) {
            String text = Settings.Setting.CHAT_FORMAT.asString().replace("<npc>", npc.getName()).replace("<text>", context.getMessage());
            this.talkToBystanders(npc, text, context);
            return;
        }
        if (context.size() <= 1) {
            String text = Settings.Setting.CHAT_FORMAT_TO_TARGET.asString().replace("<npc>", npc.getName()).replace("<text>", context.getMessage());
            String targetName = "";
            for (Talkable entity : context) {
                entity.talkTo(context, text, this);
                targetName = entity.getName();
            }
            if (!Settings.Setting.CHAT_BYSTANDERS_HEAR_TARGETED_CHAT.asBoolean()) {
                return;
            }
            String bystanderText = Settings.Setting.CHAT_FORMAT_TO_BYSTANDERS.asString().replace("<npc>", npc.getName()).replace("<target>", targetName).replace("<text>", context.getMessage());
            this.talkToBystanders(npc, bystanderText, context);
            return;
        }
        String text = Settings.Setting.CHAT_FORMAT_TO_TARGET.asString().replace("<npc>", npc.getName()).replace("<text>", context.getMessage());
        ArrayList<String> targetNames = new ArrayList<String>();
        for (Talkable entity : context) {
            entity.talkTo(context, text, this);
            targetNames.add(entity.getName());
        }
        if (!Settings.Setting.CHAT_BYSTANDERS_HEAR_TARGETED_CHAT.asBoolean()) {
            return;
        }
        String targets = "";
        int max = Settings.Setting.CHAT_MAX_NUMBER_OF_TARGETS.asInt();
        String[] format = Settings.Setting.CHAT_MULTIPLE_TARGETS_FORMAT.asString().split("\\|");
        if (format.length != 4) {
            Messaging.severe("npc.chat.options.multiple-targets-format invalid!");
        }
        if (max == 1) {
            targets = format[0].replace("<target>", (CharSequence)targetNames.get(0)) + format[3];
        } else if (max == 2 || targetNames.size() == 2) {
            targets = targetNames.size() == 2 ? format[0].replace("<target>", (CharSequence)targetNames.get(0)) + format[2].replace("<target>", (CharSequence)targetNames.get(1)) : format[0].replace("<target>", (CharSequence)targetNames.get(0)) + format[1].replace("<target>", (CharSequence)targetNames.get(1)) + format[3];
        } else if (max >= 3) {
            targets = format[0].replace("<target>", (CharSequence)targetNames.get(0));
            int x = 1;
            for (x = 1; x < max - 1 && targetNames.size() - 1 != x; ++x) {
                targets = targets + format[1].replace("<npc>", (CharSequence)targetNames.get(x));
            }
            targets = targetNames.size() == max ? targets + format[2].replace("<npc>", (CharSequence)targetNames.get(x)) : targets + format[3];
        }
        String bystanderText = Settings.Setting.CHAT_FORMAT_WITH_TARGETS_TO_BYSTANDERS.asString().replace("<npc>", npc.getName()).replace("<targets>", targets).replace("<text>", context.getMessage());
        this.talkToBystanders(npc, bystanderText, context);
    }

    private void talkToBystanders(NPC npc, String text, SpeechContext context) {
        List bystanderEntities = npc.getEntity().getNearbyEntities(Settings.Setting.CHAT_RANGE.asDouble(), Settings.Setting.CHAT_RANGE.asDouble(), Settings.Setting.CHAT_RANGE.asDouble());
        for (Entity bystander : bystanderEntities) {
            boolean shouldTalk = true;
            if (!Settings.Setting.TALK_CLOSE_TO_NPCS.asBoolean() && CitizensAPI.getNPCRegistry().isNPC(bystander)) {
                shouldTalk = false;
            }
            if (context.hasRecipients()) {
                for (Talkable target : context) {
                    if (!target.getEntity().equals(bystander)) continue;
                    shouldTalk = false;
                    break;
                }
            }
            if (!shouldTalk) continue;
            new TalkableEntity(bystander).talkNear(context, text, this);
        }
    }
}

