/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.ai;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.citizensnpcs.api.ai.AbstractPathStrategy;
import net.citizensnpcs.api.ai.NavigatorParameters;
import net.citizensnpcs.api.ai.TargetType;
import net.citizensnpcs.api.ai.event.CancelReason;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class MCNavigationStrategy
extends AbstractPathStrategy {
    private final Entity entity;
    private final MCNavigator navigator;
    private final NavigatorParameters parameters;
    private final Location target;
    private static final Location HANDLE_LOCATION = new Location(null, 0.0, 0.0, 0.0);

    MCNavigationStrategy(NPC npc, Iterable<Vector> path, NavigatorParameters params) {
        super(TargetType.LOCATION);
        ArrayList list = Lists.newArrayList(path);
        this.target = ((Vector)list.get(list.size() - 1)).toLocation(npc.getStoredLocation().getWorld());
        this.parameters = params;
        this.entity = npc.getEntity();
        this.navigator = NMS.getTargetNavigator(npc.getEntity(), list, params);
    }

    MCNavigationStrategy(NPC npc, Location dest, NavigatorParameters params) {
        super(TargetType.LOCATION);
        if (!MinecraftBlockExaminer.canStandIn(dest.getBlock())) {
            dest = MinecraftBlockExaminer.findValidLocationAbove(dest, 2);
        }
        this.target = Util.getCenterLocation(dest.getBlock());
        this.parameters = params;
        this.entity = npc.getEntity();
        this.navigator = NMS.getTargetNavigator(this.entity, this.target, params);
    }

    @Override
    public Location getCurrentDestination() {
        Location dest = NMS.getDestination(this.entity);
        return dest != null ? dest : this.target.clone();
    }

    @Override
    public Iterable<Vector> getPath() {
        return this.navigator.getPath();
    }

    @Override
    public Location getTargetAsLocation() {
        return this.target;
    }

    @Override
    public TargetType getTargetType() {
        return TargetType.LOCATION;
    }

    @Override
    public void stop() {
        this.navigator.stop();
    }

    public String toString() {
        return "MCNavigationStrategy [target=" + this.target + "]";
    }

    @Override
    public boolean update() {
        if (this.navigator.getCancelReason() != null) {
            this.setCancelReason(this.navigator.getCancelReason());
        }
        if (this.getCancelReason() != null) {
            return true;
        }
        boolean wasFinished = this.navigator.update();
        Location loc = this.entity.getLocation(HANDLE_LOCATION);
        double dX = this.target.getX() - loc.getX();
        double dZ = this.target.getZ() - loc.getZ();
        double dY = this.target.getY() - loc.getY();
        double xzDistance = Math.sqrt(dX * dX + dZ * dZ);
        if (Math.abs(dY) < 1.0 && xzDistance <= this.parameters.distanceMargin()) {
            this.stop();
            return true;
        }
        if (this.navigator.getCancelReason() != null) {
            this.setCancelReason(this.navigator.getCancelReason());
            return true;
        }
        return wasFinished;
    }

    public static interface MCNavigator {
        public CancelReason getCancelReason();

        public Iterable<Vector> getPath();

        public void stop();

        public boolean update();
    }
}

