/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.ai;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.citizensnpcs.api.astar.pathfinder.BlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.NeighbourGeneratorBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.PathPoint;
import net.citizensnpcs.api.astar.pathfinder.VectorNode;
import net.citizensnpcs.api.util.SpigotUtil;
import org.bukkit.util.Vector;

public class FallingExaminer
implements NeighbourGeneratorBlockExaminer {
    private final Map<PathPoint, Integer> fallen = Maps.newHashMap();
    private final int maxFallDistance;

    public FallingExaminer(int maxFallDistance) {
        this.maxFallDistance = maxFallDistance;
    }

    @Override
    public float getCost(BlockSource source, PathPoint point) {
        return 0.0f;
    }

    @Override
    public List<PathPoint> getNeighbours(BlockSource source, PathPoint point) {
        Vector pos = point.getVector();
        List<PathPoint> neighbours = ((VectorNode)point).getNeighbours(source, point);
        if (!SpigotUtil.checkYSafe(pos.getBlockY() + 1, source.getWorld())) {
            return neighbours;
        }
        if (!MinecraftBlockExaminer.canStandOn(source.getBlockAt(pos.getBlockX(), pos.getBlockY() - 1, pos.getBlockZ()))) {
            Integer dist = this.fallen.get(point);
            if (dist == null) {
                neighbours.add(point);
                dist = 0;
                this.fallen.put(point, dist);
            } else if (dist < this.maxFallDistance) {
                this.fallen.put(point, dist + 1);
                neighbours.add(point.createAtOffset(new Vector(pos.getBlockX(), pos.getBlockY() - 1, pos.getBlockZ())));
            }
        } else {
            this.fallen.remove(point);
        }
        return neighbours;
    }

    @Override
    public BlockExaminer.PassableState isPassable(BlockSource source, PathPoint point) {
        if (this.fallen.containsKey(point)) {
            return BlockExaminer.PassableState.PASSABLE;
        }
        return BlockExaminer.PassableState.IGNORE;
    }
}

