/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.ai;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Function;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.EntityTarget;
import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.ai.NavigatorParameters;
import net.citizensnpcs.api.ai.PathStrategy;
import net.citizensnpcs.api.ai.StuckAction;
import net.citizensnpcs.api.ai.TargetType;
import net.citizensnpcs.api.ai.TeleportStuckAction;
import net.citizensnpcs.api.ai.event.CancelReason;
import net.citizensnpcs.api.ai.event.NavigationBeginEvent;
import net.citizensnpcs.api.ai.event.NavigationCancelEvent;
import net.citizensnpcs.api.ai.event.NavigationCompleteEvent;
import net.citizensnpcs.api.ai.event.NavigationReplaceEvent;
import net.citizensnpcs.api.ai.event.NavigationStuckEvent;
import net.citizensnpcs.api.ai.event.NavigatorCallback;
import net.citizensnpcs.api.astar.pathfinder.DoorExaminer;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.SwimmingExaminer;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.npc.ai.AStarNavigationStrategy;
import net.citizensnpcs.npc.ai.BoundingBoxExaminer;
import net.citizensnpcs.npc.ai.FlyingAStarNavigationStrategy;
import net.citizensnpcs.npc.ai.MCNavigationStrategy;
import net.citizensnpcs.npc.ai.MCTargetStrategy;
import net.citizensnpcs.npc.ai.StraightLineNavigationStrategy;
import net.citizensnpcs.util.ChunkCoord;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.util.Vector;

public class CitizensNavigator
implements Navigator,
Runnable {
    private Location activeTicket;
    private final NavigatorParameters defaultParams;
    private PathStrategy executing;
    private int lastX;
    private int lastY;
    private int lastZ;
    private NavigatorParameters localParams;
    private final NPC npc;
    private boolean paused;
    private int stationaryTicks;
    private static final Location STATIONARY_LOCATION = new Location(null, 0.0, 0.0, 0.0);
    private static boolean SUPPORT_CHUNK_TICKETS = true;
    private static int UNINITIALISED_SPEED = Integer.MIN_VALUE;

    public CitizensNavigator(NPC npc) {
        this.localParams = this.defaultParams = new NavigatorParameters().baseSpeed(UNINITIALISED_SPEED).range(Settings.Setting.DEFAULT_PATHFINDING_RANGE.asFloat()).debug(Settings.Setting.DEBUG_PATHFINDING.asBoolean()).defaultAttackStrategy(MCTargetStrategy.DEFAULT_ATTACK_STRATEGY).attackRange(Settings.Setting.NPC_ATTACK_DISTANCE.asDouble()).updatePathRate(Settings.Setting.DEFAULT_PATHFINDER_UPDATE_PATH_RATE.asInt()).distanceMargin(Settings.Setting.DEFAULT_DISTANCE_MARGIN.asDouble()).pathDistanceMargin(Settings.Setting.DEFAULT_PATH_DISTANCE_MARGIN.asDouble()).stationaryTicks(Settings.Setting.DEFAULT_STATIONARY_TICKS.asInt()).stuckAction(TeleportStuckAction.INSTANCE).examiner(new MinecraftBlockExaminer()).useNewPathfinder(Settings.Setting.USE_NEW_PATHFINDER.asBoolean()).straightLineTargetingDistance(Settings.Setting.DEFAULT_STRAIGHT_LINE_TARGETING_DISTANCE.asFloat()).destinationTeleportMargin(Settings.Setting.DEFAULT_DESTINATION_TELEPORT_MARGIN.asDouble());
        this.npc = npc;
        if (npc.data().get("disable-default-stuck-action", Boolean.valueOf(false)).booleanValue()) {
            this.defaultParams.stuckAction(null);
        }
        this.defaultParams.examiner(new SwimmingExaminer(npc));
    }

    @Override
    public void cancelNavigation() {
        this.stopNavigating(CancelReason.PLUGIN);
    }

    @Override
    public NavigatorParameters getDefaultParameters() {
        return this.defaultParams;
    }

    @Override
    public EntityTarget getEntityTarget() {
        return this.executing instanceof EntityTarget ? (EntityTarget)((Object)this.executing) : null;
    }

    @Override
    public NavigatorParameters getLocalParameters() {
        if (!this.isNavigating()) {
            return this.defaultParams;
        }
        return this.localParams;
    }

    @Override
    public NPC getNPC() {
        return this.npc;
    }

    @Override
    public PathStrategy getPathStrategy() {
        return this.executing;
    }

    @Override
    public Location getTargetAsLocation() {
        return this.isNavigating() ? this.executing.getTargetAsLocation() : null;
    }

    @Override
    public TargetType getTargetType() {
        return this.isNavigating() ? this.executing.getTargetType() : null;
    }

    @Override
    public boolean isNavigating() {
        return this.executing != null;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    public void load(DataKey root) {
        if (root.keyExists("pathfindingrange")) {
            this.defaultParams.range((float)root.getDouble("pathfindingrange"));
        }
        if (root.keyExists("stationaryticks")) {
            this.defaultParams.stationaryTicks(root.getInt("stationaryticks"));
        }
        if (root.keyExists("distancemargin")) {
            this.defaultParams.distanceMargin(root.getDouble("distancemargin"));
        }
        if (root.keyExists("destinationteleportmargin")) {
            this.defaultParams.destinationTeleportMargin(root.getDouble("destinationteleportmargin"));
        }
        if (root.keyExists("updatepathrate")) {
            this.defaultParams.updatePathRate(root.getInt("updatepathrate"));
        }
        this.defaultParams.speedModifier((float)root.getDouble("speedmodifier", 1.0));
        this.defaultParams.avoidWater(root.getBoolean("avoidwater"));
        if (!root.getBoolean("usedefaultstuckaction") && this.defaultParams.stuckAction() == TeleportStuckAction.INSTANCE) {
            this.defaultParams.stuckAction(null);
        }
    }

    public void onDespawn() {
        this.stopNavigating(CancelReason.NPC_DESPAWNED);
    }

    public void onSpawn() {
        if (this.defaultParams.baseSpeed() == (float)UNINITIALISED_SPEED) {
            this.defaultParams.baseSpeed(NMS.getSpeedFor(this.npc));
        }
        this.updatePathfindingRange();
    }

    @Override
    public void run() {
        this.updateMountedStatus();
        if (!this.isNavigating() || !this.npc.isSpawned() || this.isPaused()) {
            return;
        }
        Location npcLoc = this.npc.getStoredLocation();
        Location targetLoc = this.getTargetAsLocation();
        if (!npcLoc.getWorld().equals(targetLoc.getWorld()) || (double)this.localParams.range() < npcLoc.distance(targetLoc)) {
            this.stopNavigating(CancelReason.STUCK);
            return;
        }
        if (this.updateStationaryStatus()) {
            return;
        }
        this.updatePathfindingRange();
        boolean finished = this.executing.update();
        if (!finished) {
            this.localParams.run();
        }
        if (this.localParams.lookAtFunction() != null) {
            Util.faceLocation(this.npc.getEntity(), (Location)this.localParams.lookAtFunction().apply((Object)this), true, true);
            npcLoc = this.npc.getEntity().getLocation();
            for (Entity entity = this.npc.getEntity().getPassenger(); entity != null; entity = entity.getPassenger()) {
                Location loc = entity.getLocation(STATIONARY_LOCATION);
                loc.setYaw(npcLoc.getYaw());
                entity.teleport(loc);
            }
        }
        if (this.localParams.destinationTeleportMargin() > 0.0 && npcLoc.distance(targetLoc) <= this.localParams.destinationTeleportMargin()) {
            this.npc.teleport(targetLoc, PlayerTeleportEvent.TeleportCause.PLUGIN);
            finished = true;
        }
        if (!finished) {
            return;
        }
        if (this.executing.getCancelReason() != null) {
            this.stopNavigating(this.executing.getCancelReason());
        } else {
            NavigationCompleteEvent event = new NavigationCompleteEvent(this);
            PathStrategy old = this.executing;
            Bukkit.getPluginManager().callEvent((Event)event);
            if (old == this.executing) {
                this.stopNavigating(null);
            }
        }
    }

    public void save(DataKey root) {
        if (this.defaultParams.range() != Settings.Setting.DEFAULT_PATHFINDING_RANGE.asFloat()) {
            root.setDouble("pathfindingrange", this.defaultParams.range());
        } else {
            root.removeKey("pathfindingrange");
        }
        if (this.defaultParams.stationaryTicks() != Settings.Setting.DEFAULT_STATIONARY_TICKS.asInt()) {
            root.setInt("stationaryticks", this.defaultParams.stationaryTicks());
        } else {
            root.removeKey("stationaryticks");
        }
        if (this.defaultParams.destinationTeleportMargin() != Settings.Setting.DEFAULT_DESTINATION_TELEPORT_MARGIN.asDouble()) {
            root.setDouble("destinationteleportmargin", this.defaultParams.destinationTeleportMargin());
        } else {
            root.removeKey("destinationteleportmargin");
        }
        if (this.defaultParams.distanceMargin() != Settings.Setting.DEFAULT_DISTANCE_MARGIN.asDouble()) {
            root.setDouble("distancemargin", this.defaultParams.distanceMargin());
        } else {
            root.removeKey("distancemargin");
        }
        if (this.defaultParams.updatePathRate() != Settings.Setting.DEFAULT_PATHFINDER_UPDATE_PATH_RATE.asInt()) {
            root.setInt("updatepathrate", this.defaultParams.updatePathRate());
        } else {
            root.removeKey("updatepathrate");
        }
        if (this.defaultParams.useNewPathfinder() != Settings.Setting.USE_NEW_PATHFINDER.asBoolean()) {
            root.setBoolean("usenewpathfinder", this.defaultParams.useNewPathfinder());
        } else {
            root.removeKey("usenewpathfinder");
        }
        root.setDouble("speedmodifier", this.defaultParams.speedModifier());
        root.setBoolean("avoidwater", this.defaultParams.avoidWater());
        root.setBoolean("usedefaultstuckaction", this.defaultParams.stuckAction() == TeleportStuckAction.INSTANCE);
    }

    @Override
    public void setPaused(boolean paused) {
        if (paused && this.isNavigating()) {
            NMS.cancelMoveDestination(this.npc.getEntity());
        }
        this.paused = paused;
    }

    @Override
    public void setStraightLineTarget(Entity target, boolean aggressive) {
        if (!this.npc.isSpawned()) {
            throw new IllegalStateException("npc is not spawned");
        }
        if (target == null) {
            this.cancelNavigation();
            return;
        }
        this.setTarget((NavigatorParameters params) -> {
            params.straightLineTargetingDistance(100000.0f);
            return new MCTargetStrategy(this.npc, target, aggressive, (NavigatorParameters)params);
        });
    }

    @Override
    public void setStraightLineTarget(Location target) {
        if (!this.npc.isSpawned()) {
            throw new IllegalStateException("npc is not spawned");
        }
        if (target == null) {
            this.cancelNavigation();
            return;
        }
        this.setTarget((NavigatorParameters params) -> new StraightLineNavigationStrategy(this.npc, target.clone(), (NavigatorParameters)params));
    }

    @Override
    public void setTarget(final Entity target, final boolean aggressive) {
        if (!this.npc.isSpawned()) {
            throw new IllegalStateException("npc is not spawned");
        }
        if (target == null) {
            this.cancelNavigation();
            return;
        }
        this.setTarget(new Function<NavigatorParameters, PathStrategy>(){

            @Override
            public PathStrategy apply(NavigatorParameters params) {
                return new MCTargetStrategy(CitizensNavigator.this.npc, target, aggressive, params);
            }
        });
    }

    @Override
    public void setTarget(Function<NavigatorParameters, PathStrategy> strategy) {
        if (!this.npc.isSpawned()) {
            throw new IllegalStateException("npc is not spawned");
        }
        this.switchParams();
        this.switchStrategyTo(strategy.apply(this.localParams));
    }

    @Override
    public void setTarget(final Iterable<Vector> path) {
        if (!this.npc.isSpawned()) {
            throw new IllegalStateException("npc is not spawned");
        }
        if (path == null || Iterables.size(path) == 0) {
            this.cancelNavigation();
            return;
        }
        this.setTarget(new Function<NavigatorParameters, PathStrategy>(){

            @Override
            public PathStrategy apply(NavigatorParameters params) {
                if (CitizensNavigator.this.npc.isFlyable()) {
                    return new FlyingAStarNavigationStrategy(CitizensNavigator.this.npc, path, params);
                }
                if (params.useNewPathfinder() || !(CitizensNavigator.this.npc.getEntity() instanceof LivingEntity) || CitizensNavigator.this.npc.getEntity() instanceof ArmorStand) {
                    return new AStarNavigationStrategy(CitizensNavigator.this.npc, path, params);
                }
                return new MCNavigationStrategy(CitizensNavigator.this.npc, path, params);
            }
        });
    }

    @Override
    public void setTarget(Location targetIn) {
        if (!this.npc.isSpawned()) {
            throw new IllegalStateException("npc is not spawned");
        }
        if (targetIn == null) {
            this.cancelNavigation();
            return;
        }
        final Location target = targetIn.clone();
        this.setTarget(new Function<NavigatorParameters, PathStrategy>(){

            @Override
            public PathStrategy apply(NavigatorParameters params) {
                if (CitizensNavigator.this.npc.isFlyable()) {
                    return new FlyingAStarNavigationStrategy(CitizensNavigator.this.npc, target, params);
                }
                if (params.useNewPathfinder() || !(CitizensNavigator.this.npc.getEntity() instanceof LivingEntity) || CitizensNavigator.this.npc.getEntity() instanceof ArmorStand) {
                    return new AStarNavigationStrategy(CitizensNavigator.this.npc, target, params);
                }
                return new MCNavigationStrategy(CitizensNavigator.this.npc, target, params);
            }
        });
    }

    private void stopNavigating() {
        if (this.executing != null) {
            this.executing.stop();
        }
        this.executing = null;
        this.localParams = this.defaultParams;
        this.stationaryTicks = 0;
        if (this.npc.isSpawned()) {
            Vector velocity = this.npc.getEntity().getVelocity();
            velocity.setX(0).setY(0).setZ(0);
            this.npc.getEntity().setVelocity(velocity);
            NMS.cancelMoveDestination(this.npc.getEntity());
        }
        if (!(SUPPORT_CHUNK_TICKETS && CitizensAPI.hasImplementation() && CitizensAPI.getPlugin().isEnabled())) {
            return;
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), new Runnable(){

            @Override
            public void run() {
                CitizensNavigator.this.updateTicket(CitizensNavigator.this.isNavigating() ? CitizensNavigator.this.executing.getTargetAsLocation() : null);
            }
        }, 10L);
    }

    private void stopNavigating(CancelReason reason) {
        if (!this.isNavigating()) {
            return;
        }
        Iterator<NavigatorCallback> itr = this.localParams.callbacks().iterator();
        ArrayList<NavigatorCallback> callbacks = new ArrayList<NavigatorCallback>();
        while (itr.hasNext()) {
            callbacks.add(itr.next());
            itr.remove();
        }
        for (NavigatorCallback callback : callbacks) {
            callback.onCompletion(reason);
        }
        if (reason == null) {
            this.stopNavigating();
            return;
        }
        if (reason == CancelReason.STUCK) {
            boolean shouldContinue;
            StuckAction action = this.localParams.stuckAction();
            NavigationStuckEvent event = new NavigationStuckEvent(this, action);
            Bukkit.getPluginManager().callEvent((Event)event);
            action = event.getAction();
            boolean bl = shouldContinue = action != null ? action.run(this.npc, this) : false;
            if (shouldContinue) {
                this.stationaryTicks = 0;
                this.executing.clearCancelReason();
                return;
            }
        }
        NavigationCancelEvent event = new NavigationCancelEvent(this, reason);
        PathStrategy old = this.executing;
        Bukkit.getPluginManager().callEvent((Event)event);
        if (old == this.executing) {
            this.stopNavigating();
        }
    }

    private void switchParams() {
        this.localParams = this.defaultParams.clone();
        if (!this.npc.data().has("pathfinder-open-doors") ? Settings.Setting.NEW_PATHFINDER_OPENS_DOORS.asBoolean() : (Boolean)this.npc.data().get("pathfinder-open-doors") != false) {
            this.localParams.examiner(new DoorExaminer());
        }
        if (Settings.Setting.NEW_PATHFINDER_CHECK_BOUNDING_BOXES.asBoolean()) {
            this.localParams.examiner(new BoundingBoxExaminer(this.npc.getEntity()));
        }
    }

    private void switchStrategyTo(PathStrategy newStrategy) {
        this.updatePathfindingRange();
        if (this.executing != null) {
            Bukkit.getPluginManager().callEvent((Event)new NavigationReplaceEvent(this));
        }
        this.executing = newStrategy;
        this.stationaryTicks = 0;
        if (this.npc.isSpawned()) {
            NMS.updateNavigationWorld(this.npc.getEntity(), this.npc.getEntity().getWorld());
            this.updateTicket(this.executing.getTargetAsLocation());
        }
        Bukkit.getPluginManager().callEvent((Event)new NavigationBeginEvent(this));
    }

    private void updateMountedStatus() {
        if (this.isNavigating()) {
            // empty if block
        }
    }

    private void updatePathfindingRange() {
        NMS.updatePathfindingRange(this.npc, this.localParams.range());
    }

    private boolean updateStationaryStatus() {
        if (this.localParams.stationaryTicks() < 0) {
            return false;
        }
        Location current = this.npc.getEntity().getLocation(STATIONARY_LOCATION);
        if (current.getY() < -6.0) {
            this.stopNavigating(CancelReason.STUCK);
            return true;
        }
        if (this.lastX == current.getBlockX() && this.lastY == current.getBlockY() && this.lastZ == current.getBlockZ()) {
            if (++this.stationaryTicks >= this.localParams.stationaryTicks()) {
                this.stopNavigating(CancelReason.STUCK);
                return true;
            }
        } else {
            this.stationaryTicks = 0;
        }
        this.lastX = current.getBlockX();
        this.lastY = current.getBlockY();
        this.lastZ = current.getBlockZ();
        return false;
    }

    private void updateTicket(Location target) {
        if (!(SUPPORT_CHUNK_TICKETS && CitizensAPI.hasImplementation() && CitizensAPI.getPlugin().isEnabled())) {
            return;
        }
        if (target != null && this.activeTicket != null && new ChunkCoord(target.getChunk()).equals(new ChunkCoord(this.activeTicket.getChunk()))) {
            this.activeTicket = target.clone();
            return;
        }
        if (this.activeTicket != null) {
            try {
                this.activeTicket.getChunk().removePluginChunkTicket(CitizensAPI.getPlugin());
            }
            catch (NoSuchMethodError e) {
                SUPPORT_CHUNK_TICKETS = false;
                this.activeTicket = null;
            }
        }
        if (target == null) {
            this.activeTicket = null;
            return;
        }
        this.activeTicket = target.clone();
        try {
            this.activeTicket.getChunk().addPluginChunkTicket(CitizensAPI.getPlugin());
        }
        catch (NoSuchMethodError e) {
            SUPPORT_CHUNK_TICKETS = false;
            this.activeTicket = null;
        }
    }
}

