/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.ai;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.ai.AbstractPathStrategy;
import net.citizensnpcs.api.ai.NavigatorParameters;
import net.citizensnpcs.api.ai.TargetType;
import net.citizensnpcs.api.ai.event.CancelReason;
import net.citizensnpcs.api.astar.AStarMachine;
import net.citizensnpcs.api.astar.pathfinder.BlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.Path;
import net.citizensnpcs.api.astar.pathfinder.PathPoint;
import net.citizensnpcs.api.astar.pathfinder.VectorGoal;
import net.citizensnpcs.api.astar.pathfinder.VectorNode;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.ai.NMSChunkBlockSource;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;

public class AStarNavigationStrategy
extends AbstractPathStrategy {
    private final Location destination;
    private int iterations;
    private final NPC npc;
    private final NavigatorParameters params;
    private Path plan;
    private boolean planned = false;
    private AStarMachine.AStarState state;
    private Vector vector;
    private static final AStarMachine<VectorNode, Path> ASTAR = AStarMachine.createWithDefaultStorage();
    private static final Location NPC_LOCATION = new Location(null, 0.0, 0.0, 0.0);

    public AStarNavigationStrategy(NPC npc, Iterable<Vector> path, NavigatorParameters params) {
        super(TargetType.LOCATION);
        ArrayList list = Lists.newArrayList(path);
        this.params = params;
        this.destination = ((Vector)list.get(list.size() - 1)).toLocation(npc.getStoredLocation().getWorld());
        this.npc = npc;
        this.setPlan(new Path(list));
    }

    public AStarNavigationStrategy(NPC npc, Location dest, NavigatorParameters params) {
        super(TargetType.LOCATION);
        this.params = params;
        this.destination = dest;
        this.npc = npc;
    }

    @Override
    public Location getCurrentDestination() {
        return this.vector != null ? this.vector.toLocation(this.npc.getEntity().getWorld()) : this.destination.clone();
    }

    @Override
    public Iterable<Vector> getPath() {
        return this.plan == null ? null : this.plan.getPath();
    }

    @Override
    public Location getTargetAsLocation() {
        return this.destination;
    }

    public void initialisePathfinder() {
        this.params.examiner(new BlockExaminer(){

            @Override
            public float getCost(BlockSource source, PathPoint point) {
                Vector pos = point.getVector();
                Material above = source.getMaterialAt(pos.setY(pos.getY() + 1.0));
                return AStarNavigationStrategy.this.params.avoidWater() && (MinecraftBlockExaminer.isLiquid(above) || MinecraftBlockExaminer.isLiquidOrInLiquid(pos.toLocation(source.getWorld()).getBlock())) ? 1.0f : 0.0f;
            }

            @Override
            public BlockExaminer.PassableState isPassable(BlockSource source, PathPoint point) {
                return BlockExaminer.PassableState.IGNORE;
            }
        });
        Location location = this.npc.getEntity().getLocation();
        VectorGoal goal = new VectorGoal(this.destination, (float)this.params.pathDistanceMargin());
        this.state = ASTAR.getStateFor(goal, new VectorNode(goal, location, new NMSChunkBlockSource(location, this.params.range()), this.params.examiners()));
    }

    public void setPlan(Path path) {
        this.plan = path;
        this.planned = true;
        if (this.plan == null || this.plan.isComplete()) {
            this.setCancelReason(CancelReason.STUCK);
        } else {
            this.vector = this.plan.getCurrentVector();
            if (this.params.debug()) {
                this.plan.debug();
            }
        }
    }

    @Override
    public void stop() {
        if (this.plan != null && this.params.debug()) {
            this.plan.debugEnd();
        }
        this.state = null;
        this.plan = null;
    }

    @Override
    public boolean update() {
        if (!this.planned) {
            if (this.state == null) {
                this.initialisePathfinder();
            }
            int maxIterations = Settings.Setting.MAXIMUM_ASTAR_ITERATIONS.asInt();
            int iterationsPerTick = Settings.Setting.ASTAR_ITERATIONS_PER_TICK.asInt();
            Path plan = ASTAR.run(this.state, iterationsPerTick);
            if (plan == null) {
                if (this.state.isEmpty()) {
                    this.setCancelReason(CancelReason.STUCK);
                }
                if (iterationsPerTick > 0 && maxIterations > 0) {
                    this.iterations += iterationsPerTick;
                    if (this.iterations > maxIterations) {
                        this.setCancelReason(CancelReason.STUCK);
                    }
                }
            } else {
                this.setPlan(plan);
            }
        }
        if (this.getCancelReason() != null || this.plan == null || this.plan.isComplete()) {
            return true;
        }
        Location loc = this.npc.getEntity().getLocation(NPC_LOCATION);
        Location dest = Util.getCenterLocation(this.vector.toLocation(loc.getWorld()).getBlock());
        double dX = dest.getX() - loc.getX();
        double dZ = dest.getZ() - loc.getZ();
        double dY = dest.getY() - loc.getY();
        double xzDistance = dX * dX + dZ * dZ;
        if (Math.abs(dY) < 1.0 && Math.sqrt(xzDistance) <= this.params.distanceMargin()) {
            this.plan.update(this.npc);
            if (this.plan.isComplete()) {
                return true;
            }
            this.vector = this.plan.getCurrentVector();
            return false;
        }
        if (this.params.debug()) {
            this.npc.getEntity().getWorld().playEffect(dest, Effect.ENDER_SIGNAL, 0);
        }
        if (this.npc.getEntity() instanceof LivingEntity && !this.npc.getEntity().getType().name().contains("ARMOR_STAND")) {
            NMS.setDestination(this.npc.getEntity(), dest.getX(), dest.getY(), dest.getZ(), this.params.speed());
        } else {
            Vector dir = dest.toVector().subtract(this.npc.getEntity().getLocation().toVector()).normalize().multiply(0.2);
            Block in = this.npc.getEntity().getLocation().getBlock();
            if (dY >= 1.0 && Math.sqrt(xzDistance) <= 0.4 || dY >= 0.2 && MinecraftBlockExaminer.isLiquidOrInLiquid(in)) {
                dir.add(new Vector(0.0, 0.75, 0.0));
            }
            this.npc.getEntity().setVelocity(dir);
            Util.faceLocation(this.npc.getEntity(), dest);
        }
        this.plan.run(this.npc);
        return false;
    }
}

