/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitFactory;
import net.citizensnpcs.api.trait.TraitInfo;
import net.citizensnpcs.api.trait.trait.Equipment;
import net.citizensnpcs.api.trait.trait.Inventory;
import net.citizensnpcs.api.trait.trait.MobType;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.api.trait.trait.Spawned;
import net.citizensnpcs.api.trait.trait.Speech;
import net.citizensnpcs.trait.Age;
import net.citizensnpcs.trait.Anchors;
import net.citizensnpcs.trait.ArmorStandTrait;
import net.citizensnpcs.trait.ClickRedirectTrait;
import net.citizensnpcs.trait.CommandTrait;
import net.citizensnpcs.trait.Controllable;
import net.citizensnpcs.trait.CurrentLocation;
import net.citizensnpcs.trait.DropsTrait;
import net.citizensnpcs.trait.EnderCrystalTrait;
import net.citizensnpcs.trait.EndermanTrait;
import net.citizensnpcs.trait.FollowTrait;
import net.citizensnpcs.trait.GameModeTrait;
import net.citizensnpcs.trait.Gravity;
import net.citizensnpcs.trait.HologramTrait;
import net.citizensnpcs.trait.HorseModifiers;
import net.citizensnpcs.trait.LookClose;
import net.citizensnpcs.trait.MountTrait;
import net.citizensnpcs.trait.OcelotModifiers;
import net.citizensnpcs.trait.Poses;
import net.citizensnpcs.trait.Powered;
import net.citizensnpcs.trait.RabbitType;
import net.citizensnpcs.trait.Saddle;
import net.citizensnpcs.trait.ScoreboardTrait;
import net.citizensnpcs.trait.ScriptTrait;
import net.citizensnpcs.trait.SheepTrait;
import net.citizensnpcs.trait.ShopTrait;
import net.citizensnpcs.trait.SitTrait;
import net.citizensnpcs.trait.SkinLayers;
import net.citizensnpcs.trait.SkinTrait;
import net.citizensnpcs.trait.SleepTrait;
import net.citizensnpcs.trait.SlimeSize;
import net.citizensnpcs.trait.SmoothRotationTrait;
import net.citizensnpcs.trait.SneakTrait;
import net.citizensnpcs.trait.VillagerProfession;
import net.citizensnpcs.trait.WitherTrait;
import net.citizensnpcs.trait.WolfModifiers;
import net.citizensnpcs.trait.WoolColor;
import net.citizensnpcs.trait.text.Text;
import net.citizensnpcs.trait.waypoint.Waypoints;

public class CitizensTraitFactory
implements TraitFactory {
    private final List<TraitInfo> defaultTraits = Lists.newArrayList();
    private final Map<String, TraitInfo> registered = Maps.newHashMap();
    private static final Set<String> INTERNAL_TRAITS = Sets.newHashSet();

    public CitizensTraitFactory() {
        this.registerTrait(TraitInfo.create(Age.class));
        this.registerTrait(TraitInfo.create(ArmorStandTrait.class));
        this.registerTrait(TraitInfo.create(Anchors.class));
        this.registerTrait(TraitInfo.create(ClickRedirectTrait.class));
        this.registerTrait(TraitInfo.create(CommandTrait.class));
        this.registerTrait(TraitInfo.create(Controllable.class));
        this.registerTrait(TraitInfo.create(CurrentLocation.class));
        this.registerTrait(TraitInfo.create(DropsTrait.class));
        this.registerTrait(TraitInfo.create(EnderCrystalTrait.class));
        this.registerTrait(TraitInfo.create(EndermanTrait.class));
        this.registerTrait(TraitInfo.create(Equipment.class));
        this.registerTrait(TraitInfo.create(FollowTrait.class));
        this.registerTrait(TraitInfo.create(GameModeTrait.class));
        this.registerTrait(TraitInfo.create(Gravity.class));
        this.registerTrait(TraitInfo.create(HorseModifiers.class));
        this.registerTrait(TraitInfo.create(HologramTrait.class));
        this.registerTrait(TraitInfo.create(Inventory.class));
        this.registerTrait(TraitInfo.create(LookClose.class));
        this.registerTrait(TraitInfo.create(MountTrait.class));
        this.registerTrait(TraitInfo.create(MobType.class).asDefaultTrait());
        this.registerTrait(TraitInfo.create(OcelotModifiers.class));
        this.registerTrait(TraitInfo.create(Owner.class));
        this.registerTrait(TraitInfo.create(Poses.class));
        this.registerTrait(TraitInfo.create(Powered.class));
        this.registerTrait(TraitInfo.create(RabbitType.class));
        this.registerTrait(TraitInfo.create(SmoothRotationTrait.class));
        this.registerTrait(TraitInfo.create(Saddle.class));
        this.registerTrait(TraitInfo.create(ScoreboardTrait.class));
        this.registerTrait(TraitInfo.create(ScriptTrait.class));
        this.registerTrait(TraitInfo.create(SitTrait.class));
        this.registerTrait(TraitInfo.create(SleepTrait.class));
        this.registerTrait(TraitInfo.create(SheepTrait.class));
        this.registerTrait(TraitInfo.create(SkinLayers.class));
        this.registerTrait(TraitInfo.create(SkinTrait.class));
        this.registerTrait(TraitInfo.create(SneakTrait.class));
        this.registerTrait(TraitInfo.create(SlimeSize.class));
        this.registerTrait(TraitInfo.create(ShopTrait.class));
        this.registerTrait(TraitInfo.create(Spawned.class));
        this.registerTrait(TraitInfo.create(Speech.class));
        this.registerTrait(TraitInfo.create(Text.class));
        this.registerTrait(TraitInfo.create(Waypoints.class));
        this.registerTrait(TraitInfo.create(WitherTrait.class));
        this.registerTrait(TraitInfo.create(WoolColor.class));
        this.registerTrait(TraitInfo.create(WolfModifiers.class));
        this.registerTrait(TraitInfo.create(VillagerProfession.class));
        for (String trait : this.registered.keySet()) {
            INTERNAL_TRAITS.add(trait);
        }
    }

    @Override
    public void addDefaultTraits(NPC npc) {
        for (TraitInfo info : this.defaultTraits) {
            npc.addTrait((Trait)this.create(info));
        }
    }

    private <T extends Trait> T create(TraitInfo info) {
        return info.tryCreateInstance();
    }

    @Override
    public void deregisterTrait(TraitInfo info) {
        Preconditions.checkNotNull((Object)info, (Object)"info cannot be null");
        this.registered.remove(info.getTraitName());
    }

    @Override
    public Collection<TraitInfo> getRegisteredTraits() {
        return this.registered.values();
    }

    @Override
    public <T extends Trait> T getTrait(Class<T> clazz) {
        for (TraitInfo entry : this.registered.values()) {
            if (clazz != entry.getTraitClass()) continue;
            return this.create(entry);
        }
        return null;
    }

    @Override
    public <T extends Trait> T getTrait(String name) {
        TraitInfo info = this.registered.get(name.toLowerCase());
        if (info == null) {
            return null;
        }
        return this.create(info);
    }

    @Override
    public Class<? extends Trait> getTraitClass(String name) {
        TraitInfo info = this.registered.get(name.toLowerCase());
        return info == null ? null : info.getTraitClass();
    }

    public Map<String, Integer> getTraitPlot() {
        HashMap counts = Maps.newHashMap();
        for (NPC npc : CitizensAPI.getNPCRegistry()) {
            for (Trait trait : npc.getTraits()) {
                if (INTERNAL_TRAITS.contains(trait.getName())) continue;
                counts.put(trait.getName(), counts.getOrDefault(trait.getName(), 0) + 1);
            }
        }
        return counts;
    }

    @Override
    public boolean isInternalTrait(Trait trait) {
        return INTERNAL_TRAITS.contains(trait.getName());
    }

    @Override
    public void registerTrait(TraitInfo info) {
        Preconditions.checkNotNull((Object)info, (Object)"info cannot be null");
        info.checkValid();
        if (this.registered.containsKey(info.getTraitName())) {
            throw new IllegalArgumentException("Trait name " + info.getTraitName() + " already registered");
        }
        this.registered.put(info.getTraitName(), info);
        if (info.isDefaultTrait()) {
            this.defaultTraits.add(info);
        }
    }
}

