/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc;

import clib.trove.map.hash.TIntObjectHashMap;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.NPCCreateEvent;
import net.citizensnpcs.api.event.SpawnReason;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCDataStore;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.EntityControllers;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.ArmorStandTrait;
import net.citizensnpcs.trait.LookClose;
import net.citizensnpcs.trait.MountTrait;
import net.citizensnpcs.util.NMS;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public class CitizensNPCRegistry
implements NPCRegistry {
    private final String name;
    private final TIntObjectHashMap<NPC> npcs = new TIntObjectHashMap();
    private final NPCDataStore saves;
    private final Map<UUID, NPC> uniqueNPCs = Maps.newHashMap();
    private static final Comparator<NPC> NPC_COMPARATOR = new Comparator<NPC>(){

        @Override
        public int compare(NPC o1, NPC o2) {
            return o1.getId() - o2.getId();
        }
    };

    public CitizensNPCRegistry(NPCDataStore store) {
        this(store, "");
    }

    public CitizensNPCRegistry(NPCDataStore store, String registryName) {
        this.saves = store;
        this.name = registryName;
    }

    private CitizensNPC create(EntityType type, UUID uuid, int id, String name) {
        return new CitizensNPC(uuid, id, name, EntityControllers.createForType(type), this);
    }

    @Override
    public NPC createNPC(EntityType type, String name) {
        return this.createNPC(type, UUID.randomUUID(), this.generateUniqueId(), name);
    }

    @Override
    public NPC createNPC(EntityType type, String name, Location loc) {
        NPC npc = this.createNPC(type, name);
        npc.spawn(loc, SpawnReason.PLUGIN);
        return npc;
    }

    @Override
    public NPC createNPC(EntityType type, UUID uuid, int id, String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        Preconditions.checkNotNull((Object)type, (Object)"type cannot be null");
        CitizensNPC npc = this.create(type, uuid, id, name);
        if (npc == null) {
            throw new IllegalStateException("Could not create NPC.");
        }
        this.npcs.put(id, (Object)npc);
        this.uniqueNPCs.put(npc.getUniqueId(), npc);
        Bukkit.getPluginManager().callEvent((Event)new NPCCreateEvent(npc));
        if (type == EntityType.ARMOR_STAND && !npc.hasTrait(ArmorStandTrait.class)) {
            npc.addTrait(ArmorStandTrait.class);
        }
        if (Settings.Setting.DEFAULT_LOOK_CLOSE.asBoolean()) {
            npc.addTrait(LookClose.class);
        }
        npc.addTrait(MountTrait.class);
        return npc;
    }

    @Override
    public NPC createNPCUsingItem(EntityType type, String name, ItemStack item) {
        NPC npc = this.createNPC(type, name);
        if (type != EntityType.DROPPED_ITEM && type != EntityType.FALLING_BLOCK && type != EntityType.GLOW_ITEM_FRAME && type != EntityType.ITEM_FRAME) {
            throw new UnsupportedOperationException("Not an item entity type");
        }
        npc.data().set("item-type-id", (Object)item.getType().name());
        npc.data().set("item-type-data", (Object)item.getData().getData());
        npc.data().set("item-type-amount", (Object)item.getAmount());
        return npc;
    }

    @Override
    public void deregister(NPC npc) {
        npc.despawn(DespawnReason.REMOVAL);
        this.npcs.remove(npc.getId());
        this.uniqueNPCs.remove(npc.getUniqueId());
        if (this.saves != null) {
            this.saves.clearData(npc);
        }
    }

    @Override
    public void deregisterAll() {
        Iterator<NPC> itr = this.iterator();
        while (itr.hasNext()) {
            NPC npc = itr.next();
            npc.despawn(DespawnReason.REMOVAL);
            for (Trait t : npc.getTraits()) {
                HandlerList.unregisterAll((Listener)t);
                t.onRemove();
            }
            itr.remove();
            if (this.saves == null) continue;
            this.saves.clearData(npc);
        }
    }

    @Override
    public void despawnNPCs(DespawnReason reason) {
        Iterator<NPC> itr = this.iterator();
        while (itr.hasNext()) {
            NPC npc = itr.next();
            try {
                npc.despawn(reason);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            itr.remove();
        }
    }

    private int generateUniqueId() {
        return this.saves.createUniqueNPCId(this);
    }

    @Override
    public NPC getById(int id) {
        if (id < 0) {
            throw new IllegalArgumentException("invalid id");
        }
        return (NPC)this.npcs.get(id);
    }

    @Override
    public NPC getByUniqueId(UUID uuid) {
        return this.uniqueNPCs.get(uuid);
    }

    @Override
    public NPC getByUniqueIdGlobal(UUID uuid) {
        NPC npc = this.getByUniqueId(uuid);
        if (npc != null) {
            return npc;
        }
        for (NPCRegistry registry : CitizensAPI.getNPCRegistries()) {
            NPC other;
            if (registry == this || (other = registry.getByUniqueId(uuid)) == null) continue;
            return other;
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public NPC getNPC(Entity entity) {
        if (entity == null) {
            return null;
        }
        if (entity instanceof NPCHolder) {
            return ((NPCHolder)entity).getNPC();
        }
        return NMS.getNPC(entity);
    }

    @Override
    public boolean isNPC(Entity entity) {
        return this.getNPC(entity) != null;
    }

    @Override
    public Iterator<NPC> iterator() {
        return new Iterator<NPC>(){
            Iterator<NPC> itr;
            UUID lastUUID;
            {
                this.itr = CitizensNPCRegistry.this.npcs.valueCollection().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.itr.hasNext();
            }

            @Override
            public NPC next() {
                NPC npc = this.itr.next();
                if (npc != null && npc.getUniqueId() != null) {
                    this.lastUUID = npc.getUniqueId();
                }
                return npc;
            }

            @Override
            public void remove() {
                this.itr.remove();
                if (this.lastUUID != null) {
                    CitizensNPCRegistry.this.uniqueNPCs.remove(this.lastUUID);
                    this.lastUUID = null;
                }
            }
        };
    }

    @Override
    public void saveToStore() {
        this.saves.storeAll(this);
        this.saves.saveToDiskImmediate();
    }

    @Override
    public Iterable<NPC> sorted() {
        ArrayList<NPC> vals = new ArrayList<NPC>(this.npcs.valueCollection());
        Collections.sort(vals, NPC_COMPARATOR);
        return vals;
    }
}

