/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Consumer;
import net.citizensnpcs.NPCNeedsRespawnEvent;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.astar.pathfinder.SwimmingExaminer;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.NPCDespawnEvent;
import net.citizensnpcs.api.event.NPCSpawnEvent;
import net.citizensnpcs.api.event.SpawnReason;
import net.citizensnpcs.api.npc.AbstractNPC;
import net.citizensnpcs.api.npc.BlockBreaker;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.trait.MobType;
import net.citizensnpcs.api.trait.trait.Spawned;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.npc.EntityController;
import net.citizensnpcs.npc.EntityControllers;
import net.citizensnpcs.npc.ai.CitizensNavigator;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.trait.CurrentLocation;
import net.citizensnpcs.trait.Gravity;
import net.citizensnpcs.trait.HologramTrait;
import net.citizensnpcs.trait.ScoreboardTrait;
import net.citizensnpcs.trait.SneakTrait;
import net.citizensnpcs.util.ChunkCoord;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.PlayerAnimation;
import net.citizensnpcs.util.PlayerUpdateTask;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.scheduler.BukkitRunnable;

public class CitizensNPC
extends AbstractNPC {
    private ChunkCoord cachedCoord;
    private EntityController entityController;
    private final CitizensNavigator navigator = new CitizensNavigator(this);
    private int updateCounter = 0;
    private static final Location CACHE_LOCATION = new Location(null, 0.0, 0.0, 0.0);
    private static final SetMultimap<ChunkCoord, NPC> CHUNK_LOADERS = HashMultimap.create();
    private static final String NPC_METADATA_MARKER = "NPC";
    private static boolean SUPPORT_GLOWING = true;
    private static boolean SUPPORT_NODAMAGE_TICKS = true;
    private static boolean SUPPORT_PICKUP_ITEMS = true;
    private static boolean SUPPORT_SILENT = true;
    private static boolean SUPPORT_USE_ITEM = true;

    public CitizensNPC(UUID uuid, int id, String name, EntityController entityController, NPCRegistry registry) {
        super(uuid, id, name, registry);
        Preconditions.checkNotNull((Object)entityController);
        this.entityController = entityController;
    }

    @Override
    public boolean despawn(DespawnReason reason) {
        if (this.getEntity() == null && reason != DespawnReason.DEATH) {
            Messaging.debug("Tried to despawn", this, "while already despawned, DespawnReason." + (Object)((Object)reason));
            if (reason == DespawnReason.RELOAD) {
                this.unloadEvents();
            }
            return true;
        }
        NPCDespawnEvent event = new NPCDespawnEvent(this, reason);
        if (reason == DespawnReason.CHUNK_UNLOAD) {
            event.setCancelled(this.data().get("keep-chunk-loaded", Boolean.valueOf(Settings.Setting.KEEP_CHUNKS_LOADED.asBoolean())));
        }
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled() && reason != DespawnReason.DEATH) {
            Messaging.debug("Couldn't despawn", this, "due to despawn event cancellation. Will load chunk.", this.getEntity().isValid(), ", DespawnReason." + (Object)((Object)reason));
            return false;
        }
        boolean keepSelected = this.getOrAddTrait(Spawned.class).shouldSpawn();
        if (!keepSelected) {
            this.data().remove("selectors");
        }
        if (this.getEntity() instanceof Player) {
            PlayerUpdateTask.deregisterPlayer(this.getEntity());
        }
        this.navigator.onDespawn();
        if (reason == DespawnReason.RELOAD) {
            this.unloadEvents();
        }
        for (Trait trait : new ArrayList(this.traits.values())) {
            trait.onDespawn();
        }
        Messaging.debug("Despawned", this, "DespawnReason." + (Object)((Object)reason));
        if (this.getEntity() instanceof SkinnableEntity) {
            ((SkinnableEntity)this.getEntity()).getSkinTracker().onRemoveNPC();
        }
        if (reason == DespawnReason.DEATH) {
            this.entityController.setEntity(null);
        } else {
            this.entityController.remove();
        }
        return true;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.resetCachedCoord();
    }

    @Override
    public void faceLocation(Location location) {
        if (!this.isSpawned()) {
            return;
        }
        Util.faceLocation(this.getEntity(), location);
    }

    @Override
    public BlockBreaker getBlockBreaker(Block targetBlock, BlockBreaker.BlockBreakerConfiguration config) {
        return NMS.getBlockBreaker(this.getEntity(), targetBlock, config);
    }

    @Override
    public Entity getEntity() {
        return this.entityController == null ? null : this.entityController.getBukkitEntity();
    }

    @Override
    public Navigator getNavigator() {
        return this.navigator;
    }

    @Override
    public Location getStoredLocation() {
        return this.isSpawned() ? this.getEntity().getLocation() : this.getOrAddTrait(CurrentLocation.class).getLocation();
    }

    @Override
    public boolean isFlyable() {
        this.updateFlyableState();
        return super.isFlyable();
    }

    @Override
    public boolean isSpawned() {
        return this.getEntity() != null && NMS.isValid(this.getEntity());
    }

    @Override
    public void load(DataKey root) {
        super.load(root);
        CurrentLocation spawnLocation = this.getOrAddTrait(CurrentLocation.class);
        if (this.getOrAddTrait(Spawned.class).shouldSpawn() && spawnLocation.getLocation() != null) {
            if (spawnLocation.getLocation() != null) {
                this.spawn(spawnLocation.getLocation(), SpawnReason.RESPAWN);
            } else {
                Messaging.debug("Tried to spawn", this, "on load but world was null");
            }
        }
        this.navigator.load(root.getRelative("navigator"));
    }

    @Override
    public boolean requiresNameHologram() {
        return super.requiresNameHologram() || this.getEntityType() != EntityType.ARMOR_STAND && Settings.Setting.ALWAYS_USE_NAME_HOLOGRAM.asBoolean();
    }

    private void resetCachedCoord() {
        if (this.cachedCoord == null) {
            return;
        }
        CHUNK_LOADERS.remove((Object)NPC_METADATA_MARKER, CHUNK_LOADERS);
        CHUNK_LOADERS.remove((Object)this.cachedCoord, (Object)this);
        if (CHUNK_LOADERS.get((Object)this.cachedCoord).size() == 0) {
            this.cachedCoord.setForceLoaded(false);
        }
        this.cachedCoord = null;
    }

    @Override
    public void save(DataKey root) {
        super.save(root);
        if (!this.data().get("should-save", Boolean.valueOf(true)).booleanValue()) {
            return;
        }
        this.navigator.save(root.getRelative("navigator"));
    }

    @Override
    public void setBukkitEntityType(EntityType type) {
        EntityController controller = EntityControllers.createForType(type);
        if (controller == null) {
            throw new IllegalArgumentException("Unsupported entity type " + type);
        }
        this.setEntityController(controller);
    }

    public void setEntityController(EntityController newController) {
        Preconditions.checkNotNull((Object)newController);
        boolean wasSpawned = this.isSpawned();
        Location prev = null;
        if (wasSpawned) {
            prev = this.getEntity().getLocation(CACHE_LOCATION);
            this.despawn(DespawnReason.PENDING_RESPAWN);
        }
        this.entityController = newController;
        if (wasSpawned) {
            this.spawn(prev, SpawnReason.RESPAWN);
        }
    }

    @Override
    public void setFlyable(boolean flyable) {
        super.setFlyable(flyable);
        this.updateFlyableState();
    }

    @Override
    public void setMoveDestination(Location destination) {
        if (!this.isSpawned()) {
            return;
        }
        if (destination == null) {
            NMS.cancelMoveDestination(this.getEntity());
        } else {
            NMS.setDestination(this.getEntity(), destination.getX(), destination.getY(), destination.getZ(), 1.0f);
        }
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (this.requiresNameHologram() && !this.hasTrait(HologramTrait.class)) {
            this.addTrait(HologramTrait.class);
        }
    }

    @Override
    public boolean spawn(Location at) {
        return this.spawn(at, SpawnReason.PLUGIN);
    }

    @Override
    public boolean spawn(Location at, final SpawnReason reason) {
        SkinnableEntity skinnable;
        boolean couldSpawn;
        Preconditions.checkNotNull((Object)at, (Object)"location cannot be null");
        Preconditions.checkNotNull((Object)((Object)reason), (Object)"reason cannot be null");
        if (this.getEntity() != null) {
            Messaging.debug("Tried to spawn", this, "while already spawned. SpawnReason." + (Object)((Object)reason));
            return false;
        }
        if (at.getWorld() == null) {
            Messaging.debug("Tried to spawn", this, "but the world was null. SpawnReason." + (Object)((Object)reason));
            return false;
        }
        at = at.clone();
        if (reason == SpawnReason.CHUNK_LOAD || reason == SpawnReason.COMMAND) {
            at.getChunk().load();
        }
        this.getOrAddTrait(CurrentLocation.class).setLocation(at);
        this.entityController.spawn(at.clone(), this);
        this.getEntity().setMetadata(NPC_METADATA_MARKER, (MetadataValue)new FixedMetadataValue(CitizensAPI.getPlugin(), (Object)true));
        Collection onPreSpawn = this.traits.values();
        for (Trait trait : onPreSpawn.toArray(new Trait[onPreSpawn.size()])) {
            try {
                trait.onPreSpawn();
            }
            catch (Throwable ex) {
                Messaging.severeTr("citizens.notifications.trait-onspawn-failed", trait.getName(), this.getId());
                ex.printStackTrace();
            }
        }
        boolean loaded = Util.isLoaded(at);
        boolean bl = couldSpawn = !loaded ? false : NMS.addEntityToWorld(this.getEntity(), CreatureSpawnEvent.SpawnReason.CUSTOM);
        if (!couldSpawn) {
            if (Messaging.isDebugging()) {
                Messaging.debug("Retrying spawn of", this, "later, SpawnReason." + (Object)((Object)reason) + ". Was loaded", loaded, "is loaded", Util.isLoaded(at));
            }
            this.entityController.remove();
            Bukkit.getPluginManager().callEvent((Event)new NPCNeedsRespawnEvent(this, at));
            return false;
        }
        SkinnableEntity skinnableEntity = skinnable = this.getEntity() instanceof SkinnableEntity ? (SkinnableEntity)this.getEntity() : null;
        if (skinnable != null) {
            skinnable.getSkinTracker().onSpawnNPC();
        }
        this.getEntity().teleport(at);
        NMS.setHeadYaw(this.getEntity(), at.getYaw());
        NMS.setBodyYaw(this.getEntity(), at.getYaw());
        final Location to = at;
        final Consumer<Runnable> postSpawn = new Consumer<Runnable>(){
            private int timer;

            @Override
            public void accept(Runnable cancel) {
                if (CitizensNPC.this.getEntity() == null || !CitizensNPC.this.getEntity().isValid()) {
                    if (this.timer++ > Settings.Setting.ENTITY_SPAWN_WAIT_TICKS.asInt()) {
                        Messaging.debug("Couldn't spawn ", CitizensNPC.this, "waited", this.timer, "ticks but entity not added to world");
                        CitizensNPC.this.entityController.remove();
                        cancel.run();
                        Bukkit.getPluginManager().callEvent((Event)new NPCNeedsRespawnEvent(CitizensNPC.this, to));
                    }
                    return;
                }
                CitizensNPC.this.getOrAddTrait(CurrentLocation.class).setLocation(to);
                CitizensNPC.this.getOrAddTrait(Spawned.class).setSpawned(true);
                NPCSpawnEvent spawnEvent = new NPCSpawnEvent(CitizensNPC.this, to, reason);
                Bukkit.getPluginManager().callEvent((Event)spawnEvent);
                if (spawnEvent.isCancelled()) {
                    Messaging.debug("Couldn't spawn", CitizensNPC.this, "SpawnReason." + (Object)((Object)reason), "due to event cancellation.");
                    CitizensNPC.this.entityController.remove();
                    cancel.run();
                    return;
                }
                CitizensNPC.this.navigator.onSpawn();
                for (Trait trait : (Trait[])Iterables.toArray(CitizensNPC.this.traits.values(), Trait.class)) {
                    try {
                        trait.onSpawn();
                    }
                    catch (Throwable ex) {
                        Messaging.severeTr("citizens.notifications.trait-onspawn-failed", trait.getName(), CitizensNPC.this.getId());
                        ex.printStackTrace();
                    }
                }
                EntityType type = CitizensNPC.this.getEntity().getType();
                if (type.isAlive()) {
                    LivingEntity entity = (LivingEntity)CitizensNPC.this.getEntity();
                    entity.setRemoveWhenFarAway(false);
                    if (NMS.getStepHeight((Entity)entity) < 1.0f) {
                        NMS.setStepHeight((Entity)entity, 1.0f);
                    }
                    if (type == EntityType.PLAYER) {
                        NMS.replaceTrackerEntry((Player)CitizensNPC.this.getEntity());
                        PlayerUpdateTask.registerPlayer(CitizensNPC.this.getEntity());
                    }
                    if (SUPPORT_NODAMAGE_TICKS && (Settings.Setting.DEFAULT_SPAWN_NODAMAGE_TICKS.asInt() != 20 || CitizensNPC.this.data().has(NPC.Metadata.SPAWN_NODAMAGE_TICKS))) {
                        try {
                            entity.setNoDamageTicks(CitizensNPC.this.data().get(NPC.Metadata.SPAWN_NODAMAGE_TICKS, Integer.valueOf(Settings.Setting.DEFAULT_SPAWN_NODAMAGE_TICKS.asInt())).intValue());
                        }
                        catch (NoSuchMethodError err) {
                            SUPPORT_NODAMAGE_TICKS = false;
                        }
                    }
                }
                if (CitizensNPC.this.requiresNameHologram() && !CitizensNPC.this.hasTrait(HologramTrait.class)) {
                    CitizensNPC.this.addTrait(HologramTrait.class);
                }
                CitizensNPC.this.updateFlyableState();
                CitizensNPC.this.updateCustomNameVisibility();
                CitizensNPC.this.updateCustomName();
                Messaging.debug("Spawned", CitizensNPC.this, "SpawnReason." + (Object)((Object)reason));
                cancel.run();
            }
        };
        if (this.getEntity() != null && this.getEntity().isValid()) {
            postSpawn.accept(() -> {});
        } else {
            new BukkitRunnable(){

                public void run() {
                    postSpawn.accept(() -> this.cancel());
                }
            }.runTaskTimer(CitizensAPI.getPlugin(), 0L, 1L);
        }
        return true;
    }

    @Override
    public void teleport(Location location, PlayerTeleportEvent.TeleportCause reason) {
        super.teleport(location, reason);
        if (!this.isSpawned()) {
            return;
        }
        Location npcLoc = this.getEntity().getLocation(CACHE_LOCATION);
        if (this.isSpawned() && npcLoc.getWorld() == location.getWorld() && npcLoc.distanceSquared(location) < 1.0) {
            NMS.setHeadYaw(this.getEntity(), location.getYaw());
        }
    }

    public String toString() {
        EntityType mobType = this.hasTrait(MobType.class) ? this.getTraitNullable(MobType.class).getType() : null;
        return this.getId() + "{" + this.getName() + ", " + mobType + "}";
    }

    @Override
    public void update() {
        try {
            Gravity trait;
            super.update();
            if (!this.isSpawned()) {
                this.resetCachedCoord();
                return;
            }
            if (this.navigator.isNavigating()) {
                Location currentDest;
                if (this.data().get(NPC.Metadata.SWIMMING, Boolean.valueOf(true)).booleanValue() && ((currentDest = this.navigator.getPathStrategy().getCurrentDestination()) == null || currentDest.getY() > this.getStoredLocation().getY())) {
                    NMS.trySwim(this.getEntity(), SwimmingExaminer.isWaterMob(this.getEntity()) ? 0.02f : 0.04f);
                }
            } else if (this.data().get(NPC.Metadata.SWIMMING, Boolean.valueOf(!SwimmingExaminer.isWaterMob(this.getEntity()))).booleanValue() && ((trait = this.getTraitNullable(Gravity.class)) == null || trait.hasGravity())) {
                NMS.trySwim(this.getEntity());
            }
            this.navigator.run();
            if (SUPPORT_GLOWING) {
                try {
                    this.getEntity().setGlowing(this.data().get(NPC.Metadata.GLOWING, Boolean.valueOf(false)).booleanValue());
                }
                catch (NoSuchMethodError e) {
                    SUPPORT_GLOWING = false;
                }
            }
            boolean isLiving = this.getEntity() instanceof LivingEntity;
            int packetUpdateDelay = this.data().get(NPC.Metadata.PACKET_UPDATE_DELAY, Integer.valueOf(Settings.Setting.PACKET_UPDATE_DELAY.asInt()));
            if (this.updateCounter++ > packetUpdateDelay) {
                ChunkCoord currentCoord;
                if (Settings.Setting.KEEP_CHUNKS_LOADED.asBoolean() && !(currentCoord = new ChunkCoord(this.getStoredLocation())).equals(this.cachedCoord)) {
                    this.resetCachedCoord();
                    currentCoord.setForceLoaded(true);
                    CHUNK_LOADERS.put((Object)currentCoord, (Object)this);
                    this.cachedCoord = currentCoord;
                }
                if (isLiving) {
                    this.updateCustomName();
                }
                this.updateCounter = 0;
            }
            this.updateCustomNameVisibility();
            if (isLiving) {
                NMS.setKnockbackResistance((LivingEntity)this.getEntity(), this.isProtected() ? 1.0 : 0.0);
                if (SUPPORT_PICKUP_ITEMS) {
                    try {
                        ((LivingEntity)this.getEntity()).setCanPickupItems(this.data().get(NPC.Metadata.PICKUP_ITEMS, Boolean.valueOf(!this.isProtected())).booleanValue());
                    }
                    catch (Throwable t) {
                        SUPPORT_PICKUP_ITEMS = false;
                    }
                }
            }
            if (isLiving && this.getEntity() instanceof Player) {
                this.updateUsingItemState((Player)this.getEntity());
                if (this.data().has(NPC.Metadata.SNEAKING) && !this.hasTrait(SneakTrait.class)) {
                    this.addTrait(SneakTrait.class);
                }
            }
            if (SUPPORT_SILENT && this.data().has("silent-sounds")) {
                try {
                    this.getEntity().setSilent(Boolean.parseBoolean(this.data().get(NPC.Metadata.SILENT).toString()));
                }
                catch (NoSuchMethodError e) {
                    SUPPORT_SILENT = false;
                }
            }
        }
        catch (Exception ex) {
            Throwable error = Throwables.getRootCause((Throwable)ex);
            Messaging.logTr("citizens.notifications.exception-updating-npc", this.getId(), error.getMessage());
            error.printStackTrace();
        }
    }

    private void updateCustomName() {
        if (this.data().has(NPC.Metadata.SCOREBOARD_FAKE_TEAM_NAME)) {
            this.getOrAddTrait(ScoreboardTrait.class).update();
        }
    }

    private void updateCustomNameVisibility() {
        String nameplateVisible = ((Object)this.data().get(NPC.Metadata.NAMEPLATE_VISIBLE, Boolean.valueOf(true))).toString();
        if (this.requiresNameHologram()) {
            nameplateVisible = "false";
        }
        if (nameplateVisible.equals("true") || nameplateVisible.equals("hover")) {
            this.getEntity().setCustomName(this.getFullName());
        }
        this.getEntity().setCustomNameVisible(Boolean.parseBoolean(nameplateVisible));
    }

    private void updateFlyableState() {
        EntityType type;
        EntityType entityType = type = this.isSpawned() ? this.getEntity().getType() : this.getOrAddTrait(MobType.class).getType();
        if (type == null) {
            return;
        }
        if (!Util.isAlwaysFlyable(type)) {
            return;
        }
        if (!this.data().has("flyable")) {
            this.data().setPersistent("flyable", (Object)true);
        }
        if (!this.hasTrait(Gravity.class)) {
            this.getOrAddTrait(Gravity.class).setEnabled(true);
        }
    }

    private void updateUsingItemState(Player player) {
        boolean useItem = this.data().get(NPC.Metadata.USING_HELD_ITEM, Boolean.valueOf(false));
        boolean offhand = this.data().get(NPC.Metadata.USING_OFFHAND_ITEM, Boolean.valueOf(false));
        if (!SUPPORT_USE_ITEM) {
            return;
        }
        try {
            if (useItem) {
                NMS.playAnimation(PlayerAnimation.STOP_USE_ITEM, player, 64);
                NMS.playAnimation(PlayerAnimation.START_USE_MAINHAND_ITEM, player, 64);
            } else if (offhand) {
                NMS.playAnimation(PlayerAnimation.STOP_USE_ITEM, player, 64);
                NMS.playAnimation(PlayerAnimation.START_USE_OFFHAND_ITEM, player, 64);
            }
        }
        catch (UnsupportedOperationException ex) {
            SUPPORT_USE_ITEM = false;
        }
    }
}

