/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_8_R3.util;

import java.lang.reflect.Field;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.nms.v1_8_R3.entity.EntityHumanNPC;
import net.citizensnpcs.nms.v1_8_R3.util.NMSImpl;
import net.citizensnpcs.util.NMS;
import net.minecraft.server.v1_8_R3.Entity;
import net.minecraft.server.v1_8_R3.EntityPlayer;
import net.minecraft.server.v1_8_R3.EntityTrackerEntry;
import net.minecraft.server.v1_8_R3.PacketPlayOutAnimation;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class PlayerlistTrackerEntry
extends EntityTrackerEntry {
    private EntityPlayer lastUpdatedPlayer;
    private static Field B = NMS.getField(EntityTrackerEntry.class, "b");
    private static Field C = NMS.getField(EntityTrackerEntry.class, "c");
    private static Field TRACKER = NMS.getField(EntityTrackerEntry.class, "tracker");
    private static Field U = NMS.getField(EntityTrackerEntry.class, "u");

    public PlayerlistTrackerEntry(Entity entity, int i, int j, boolean flag) {
        super(entity, i, j, flag);
    }

    public PlayerlistTrackerEntry(EntityTrackerEntry entry) {
        this(PlayerlistTrackerEntry.getTracker(entry), PlayerlistTrackerEntry.getB(entry), PlayerlistTrackerEntry.getC(entry), PlayerlistTrackerEntry.getU(entry));
    }

    public boolean isUpdating() {
        return this.lastUpdatedPlayer != null;
    }

    public void updateLastPlayer() {
        if (this.lastUpdatedPlayer == null) {
            return;
        }
        final Entity tracker = PlayerlistTrackerEntry.getTracker(this);
        final EntityPlayer entityplayer = this.lastUpdatedPlayer;
        NMS.sendTabListAdd((Player)entityplayer.getBukkitEntity(), (Player)tracker.getBukkitEntity());
        this.lastUpdatedPlayer = null;
        if (!Settings.Setting.DISABLE_TABLIST.asBoolean()) {
            return;
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), new Runnable(){

            @Override
            public void run() {
                NMSImpl.sendPacket((Player)entityplayer.getBukkitEntity(), new PacketPlayOutAnimation(tracker, 0));
                NMS.sendTabListRemove((Player)entityplayer.getBukkitEntity(), (Player)tracker.getBukkitEntity());
            }
        }, (long)Settings.Setting.TABLIST_REMOVE_PACKET_DELAY.asInt());
    }

    public void updatePlayer(EntityPlayer entityplayer) {
        if (entityplayer instanceof EntityHumanNPC) {
            return;
        }
        this.lastUpdatedPlayer = entityplayer;
        super.updatePlayer(entityplayer);
        this.lastUpdatedPlayer = null;
    }

    private static int getB(EntityTrackerEntry entry) {
        try {
            return (Integer)B.get(entry);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return 0;
    }

    private static int getC(EntityTrackerEntry entry) {
        try {
            return (Integer)C.get(entry);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return 0;
    }

    private static Entity getTracker(EntityTrackerEntry entry) {
        try {
            return (Entity)TRACKER.get(entry);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static boolean getU(EntityTrackerEntry entry) {
        try {
            return (Boolean)U.get(entry);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return false;
    }
}

