/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_8_R3.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.HttpAuthenticationService;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.authlib.yggdrasil.YggdrasilMinecraftSessionService;
import com.mojang.authlib.yggdrasil.response.MinecraftProfilePropertiesResponse;
import com.mojang.util.UUIDTypeAdapter;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.ai.NavigatorParameters;
import net.citizensnpcs.api.ai.event.CancelReason;
import net.citizensnpcs.api.command.CommandManager;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.gui.ForwardingInventory;
import net.citizensnpcs.api.npc.BlockBreaker;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.util.BoundingBox;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.nms.v1_8_R3.entity.BatController;
import net.citizensnpcs.nms.v1_8_R3.entity.BlazeController;
import net.citizensnpcs.nms.v1_8_R3.entity.CaveSpiderController;
import net.citizensnpcs.nms.v1_8_R3.entity.ChickenController;
import net.citizensnpcs.nms.v1_8_R3.entity.CowController;
import net.citizensnpcs.nms.v1_8_R3.entity.CreeperController;
import net.citizensnpcs.nms.v1_8_R3.entity.EnderDragonController;
import net.citizensnpcs.nms.v1_8_R3.entity.EndermanController;
import net.citizensnpcs.nms.v1_8_R3.entity.EndermiteController;
import net.citizensnpcs.nms.v1_8_R3.entity.EntityHumanNPC;
import net.citizensnpcs.nms.v1_8_R3.entity.GhastController;
import net.citizensnpcs.nms.v1_8_R3.entity.GiantController;
import net.citizensnpcs.nms.v1_8_R3.entity.GuardianController;
import net.citizensnpcs.nms.v1_8_R3.entity.HorseController;
import net.citizensnpcs.nms.v1_8_R3.entity.HumanController;
import net.citizensnpcs.nms.v1_8_R3.entity.IronGolemController;
import net.citizensnpcs.nms.v1_8_R3.entity.MagmaCubeController;
import net.citizensnpcs.nms.v1_8_R3.entity.MushroomCowController;
import net.citizensnpcs.nms.v1_8_R3.entity.OcelotController;
import net.citizensnpcs.nms.v1_8_R3.entity.PigController;
import net.citizensnpcs.nms.v1_8_R3.entity.PigZombieController;
import net.citizensnpcs.nms.v1_8_R3.entity.RabbitController;
import net.citizensnpcs.nms.v1_8_R3.entity.SheepController;
import net.citizensnpcs.nms.v1_8_R3.entity.SilverfishController;
import net.citizensnpcs.nms.v1_8_R3.entity.SkeletonController;
import net.citizensnpcs.nms.v1_8_R3.entity.SlimeController;
import net.citizensnpcs.nms.v1_8_R3.entity.SnowmanController;
import net.citizensnpcs.nms.v1_8_R3.entity.SpiderController;
import net.citizensnpcs.nms.v1_8_R3.entity.SquidController;
import net.citizensnpcs.nms.v1_8_R3.entity.VillagerController;
import net.citizensnpcs.nms.v1_8_R3.entity.WitchController;
import net.citizensnpcs.nms.v1_8_R3.entity.WitherController;
import net.citizensnpcs.nms.v1_8_R3.entity.WolfController;
import net.citizensnpcs.nms.v1_8_R3.entity.ZombieController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.ArmorStandController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.ArrowController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.BoatController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.EggController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.EnderCrystalController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.EnderPearlController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.EnderSignalController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.FallingBlockController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.FireworkController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.FishingHookController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.ItemController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.ItemFrameController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.LargeFireballController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.LeashController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.MinecartChestController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.MinecartCommandController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.MinecartFurnaceController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.MinecartHopperController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.MinecartRideableController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.MinecartTNTController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.PaintingController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.SmallFireballController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.SnowballController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.SplashPotionController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.TNTPrimedController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.ThrownExpBottleController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.WitherSkullController;
import net.citizensnpcs.nms.v1_8_R3.network.EmptyChannel;
import net.citizensnpcs.nms.v1_8_R3.util.CitizensBlockBreaker;
import net.citizensnpcs.nms.v1_8_R3.util.PlayerAnimationImpl;
import net.citizensnpcs.nms.v1_8_R3.util.PlayerlistTrackerEntry;
import net.citizensnpcs.npc.EntityControllers;
import net.citizensnpcs.npc.ai.MCNavigationStrategy;
import net.citizensnpcs.npc.ai.MCTargetStrategy;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.trait.SmoothRotationTrait;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.NMSBridge;
import net.citizensnpcs.util.PlayerAnimation;
import net.citizensnpcs.util.PlayerUpdateTask;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_8_R3.AttributeInstance;
import net.minecraft.server.v1_8_R3.AxisAlignedBB;
import net.minecraft.server.v1_8_R3.Block;
import net.minecraft.server.v1_8_R3.BlockPosition;
import net.minecraft.server.v1_8_R3.ChatComponentText;
import net.minecraft.server.v1_8_R3.ChatMessage;
import net.minecraft.server.v1_8_R3.Container;
import net.minecraft.server.v1_8_R3.ContainerAnvil;
import net.minecraft.server.v1_8_R3.ControllerJump;
import net.minecraft.server.v1_8_R3.ControllerMove;
import net.minecraft.server.v1_8_R3.CrashReport;
import net.minecraft.server.v1_8_R3.CrashReportSystemDetails;
import net.minecraft.server.v1_8_R3.DamageSource;
import net.minecraft.server.v1_8_R3.EnchantmentManager;
import net.minecraft.server.v1_8_R3.EntityEnderDragon;
import net.minecraft.server.v1_8_R3.EntityFishingHook;
import net.minecraft.server.v1_8_R3.EntityHorse;
import net.minecraft.server.v1_8_R3.EntityHuman;
import net.minecraft.server.v1_8_R3.EntityInsentient;
import net.minecraft.server.v1_8_R3.EntityLiving;
import net.minecraft.server.v1_8_R3.EntityMinecartAbstract;
import net.minecraft.server.v1_8_R3.EntityPlayer;
import net.minecraft.server.v1_8_R3.EntityTameableAnimal;
import net.minecraft.server.v1_8_R3.EntityTracker;
import net.minecraft.server.v1_8_R3.EntityTrackerEntry;
import net.minecraft.server.v1_8_R3.EntityTypes;
import net.minecraft.server.v1_8_R3.EntityWither;
import net.minecraft.server.v1_8_R3.EnumMonsterType;
import net.minecraft.server.v1_8_R3.GenericAttributes;
import net.minecraft.server.v1_8_R3.IChatBaseComponent;
import net.minecraft.server.v1_8_R3.ICrafting;
import net.minecraft.server.v1_8_R3.IInventory;
import net.minecraft.server.v1_8_R3.MathHelper;
import net.minecraft.server.v1_8_R3.Navigation;
import net.minecraft.server.v1_8_R3.NavigationAbstract;
import net.minecraft.server.v1_8_R3.NetworkManager;
import net.minecraft.server.v1_8_R3.Packet;
import net.minecraft.server.v1_8_R3.PacketPlayOutAnimation;
import net.minecraft.server.v1_8_R3.PacketPlayOutBed;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityTeleport;
import net.minecraft.server.v1_8_R3.PacketPlayOutOpenWindow;
import net.minecraft.server.v1_8_R3.PacketPlayOutPlayerInfo;
import net.minecraft.server.v1_8_R3.PacketPlayOutScoreboardTeam;
import net.minecraft.server.v1_8_R3.PathEntity;
import net.minecraft.server.v1_8_R3.PathPoint;
import net.minecraft.server.v1_8_R3.PathfinderGoalSelector;
import net.minecraft.server.v1_8_R3.ReportedException;
import net.minecraft.server.v1_8_R3.ScoreboardTeam;
import net.minecraft.server.v1_8_R3.ScoreboardTeamBase;
import net.minecraft.server.v1_8_R3.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_8_R3.CraftServer;
import org.bukkit.craftbukkit.v1_8_R3.CraftSound;
import org.bukkit.craftbukkit.v1_8_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_8_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftWither;
import org.bukkit.craftbukkit.v1_8_R3.inventory.CraftInventoryAnvil;
import org.bukkit.craftbukkit.v1_8_R3.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_8_R3.util.CraftMagicNumbers;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Wither;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.PluginLoadOrder;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;

public class NMSImpl
implements NMSBridge {
    private static final Set<EntityType> BAD_CONTROLLER_LOOK = EnumSet.of(EntityType.SILVERFISH, new EntityType[]{EntityType.ENDERMITE, EntityType.ENDER_DRAGON, EntityType.BAT, EntityType.SLIME, EntityType.MAGMA_CUBE, EntityType.HORSE, EntityType.GHAST});
    private static final float DEFAULT_SPEED = 1.0f;
    private static Method ENTITY_ATTACK_A = NMS.getMethod(net.minecraft.server.v1_8_R3.Entity.class, "a", true, EntityLiving.class, net.minecraft.server.v1_8_R3.Entity.class);
    private static Map<Class<?>, Integer> ENTITY_CLASS_TO_INT;
    private static Map<Class<?>, String> ENTITY_CLASS_TO_NAME;
    private static final Location FROM_LOCATION;
    private static Method GET_NMS_BLOCK;
    public static Field GOAL_FIELD;
    private static final Field JUMP_FIELD;
    private static Method MAKE_REQUEST;
    private static Field MOVE_CONTROLLER_MOVING;
    private static Field NAVIGATION_WORLD_FIELD;
    public static Field NETWORK_ADDRESS;
    public static final Location PACKET_CACHE_LOCATION;
    private static Field PATHFINDING_RANGE;
    private static final Random RANDOM;
    private static final MethodHandle REPAIR_INVENTORY;
    private static final MethodHandle RESULT_INVENTORY;
    private static Field SKULL_PROFILE_FIELD;
    private static Field TEAM_FIELD;
    private static Field TRACKED_ENTITY_SET;

    public NMSImpl() {
        this.loadEntityTypes();
    }

    @Override
    public boolean addEntityToWorld(Entity entity, CreatureSpawnEvent.SpawnReason custom) {
        return NMSImpl.getHandle((Entity)entity).world.addEntity(NMSImpl.getHandle(entity), custom);
    }

    @Override
    public void addOrRemoveFromPlayerList(Entity entity, boolean remove) {
        if (entity == null) {
            return;
        }
        EntityHuman handle = (EntityHuman)NMSImpl.getHandle(entity);
        if (handle.world == null) {
            return;
        }
        if (remove) {
            handle.world.players.remove(handle);
        } else if (!handle.world.players.contains(handle)) {
            handle.world.players.add(handle);
        }
        PlayerUpdateTask.addOrRemove(entity, remove);
    }

    @Override
    public void attack(LivingEntity attacker, LivingEntity btarget) {
        int fireAspectLevel;
        boolean flag;
        EntityLiving handle = NMSImpl.getHandle(attacker);
        EntityLiving target = NMSImpl.getHandle(btarget);
        if (handle instanceof EntityPlayer) {
            EntityPlayer humanHandle = (EntityPlayer)handle;
            humanHandle.attack((net.minecraft.server.v1_8_R3.Entity)target);
            PlayerAnimation.ARM_SWING.play((Player)humanHandle.getBukkitEntity());
            return;
        }
        AttributeInstance attackDamage = handle.getAttributeInstance(GenericAttributes.ATTACK_DAMAGE);
        float f = (float)(attackDamage == null ? 1.0 : attackDamage.getValue());
        int i = 0;
        if (target instanceof EntityLiving) {
            f += EnchantmentManager.a((net.minecraft.server.v1_8_R3.ItemStack)handle.bA(), (EnumMonsterType)target.getMonsterType());
            i += EnchantmentManager.a((EntityLiving)handle);
        }
        if (!(flag = target.damageEntity(DamageSource.mobAttack((EntityLiving)handle), f))) {
            return;
        }
        if (i > 0) {
            target.g(-Math.sin((double)handle.yaw * Math.PI / 180.0) * (double)i * 0.5, 0.1, Math.cos((double)handle.yaw * Math.PI / 180.0) * (double)i * 0.5);
            handle.motX *= 0.6;
            handle.motZ *= 0.6;
        }
        if ((fireAspectLevel = EnchantmentManager.getFireAspectEnchantmentLevel((EntityLiving)handle)) > 0) {
            target.setOnFire(fireAspectLevel * 4);
        }
        if (ENTITY_ATTACK_A != null) {
            try {
                ENTITY_ATTACK_A.invoke((Object)handle, handle, target);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    @Override
    public void cancelMoveDestination(Entity entity) {
        net.minecraft.server.v1_8_R3.Entity handle = NMSImpl.getHandle(entity);
        if (handle instanceof EntityInsentient) {
            try {
                MOVE_CONTROLLER_MOVING.set(((EntityInsentient)handle).getControllerMove(), false);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        } else if (handle instanceof EntityHumanNPC) {
            ((EntityHumanNPC)handle).getControllerMove().f = false;
        }
    }

    @Override
    public GameProfile fillProfileProperties(GameProfile profile, boolean requireSecure) throws Exception {
        if (Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("NMS.fillProfileProperties cannot be invoked from the main thread.");
        }
        MinecraftSessionService sessionService = ((CraftServer)Bukkit.getServer()).getServer().aD();
        if (!(sessionService instanceof YggdrasilMinecraftSessionService)) {
            return sessionService.fillProfileProperties(profile, requireSecure);
        }
        YggdrasilAuthenticationService auth = ((YggdrasilMinecraftSessionService)sessionService).getAuthenticationService();
        URL url = HttpAuthenticationService.constantURL((String)(this.getAuthServerBaseUrl() + UUIDTypeAdapter.fromUUID((UUID)profile.getId())));
        MinecraftProfilePropertiesResponse response = (MinecraftProfilePropertiesResponse)MAKE_REQUEST.invoke((Object)auth, url = HttpAuthenticationService.concatenateURL((URL)url, (String)("unsigned=" + !requireSecure)), null, MinecraftProfilePropertiesResponse.class);
        if (response == null) {
            return profile;
        }
        GameProfile result = new GameProfile(response.getId(), response.getName());
        result.getProperties().putAll((Multimap)response.getProperties());
        profile.getProperties().putAll((Multimap)response.getProperties());
        return result;
    }

    public String getAuthServerBaseUrl() {
        return Settings.Setting.AUTH_SERVER_URL.asString();
    }

    @Override
    public BlockBreaker getBlockBreaker(Entity entity, org.bukkit.block.Block targetBlock, BlockBreaker.BlockBreakerConfiguration config) {
        return new CitizensBlockBreaker(entity, targetBlock, config);
    }

    @Override
    public Object getBossBar(Entity entity) {
        return null;
    }

    @Override
    public BoundingBox getBoundingBox(Entity handle) {
        AxisAlignedBB bb = NMSImpl.getHandle(handle).getBoundingBox();
        return new BoundingBox(bb.a, bb.b, bb.c, bb.d, bb.e, bb.f);
    }

    @Override
    public BoundingBox getCollisionBox(org.bukkit.block.Block block) {
        BlockPosition pos;
        WorldServer world = ((CraftWorld)block.getWorld()).getHandle();
        Block type = CraftMagicNumbers.getBlock((org.bukkit.block.Block)block);
        AxisAlignedBB aabb = type.a((net.minecraft.server.v1_8_R3.World)world, pos = new BlockPosition(block.getX(), block.getY(), block.getZ()), world.getType(pos));
        return aabb == null ? BoundingBox.EMPTY : new BoundingBox(aabb.a, aabb.b, aabb.c, aabb.d, aabb.e, aabb.f);
    }

    @Override
    public Location getDestination(Entity entity) {
        ControllerMove controller;
        net.minecraft.server.v1_8_R3.Entity handle = NMSImpl.getHandle(entity);
        ControllerMove controllerMove = handle instanceof EntityInsentient ? ((EntityInsentient)handle).getControllerMove() : (controller = handle instanceof EntityHumanNPC ? ((EntityHumanNPC)handle).getControllerMove() : null);
        if (controller == null || !controller.a()) {
            return null;
        }
        return new Location(entity.getWorld(), controller.d(), controller.e(), controller.f());
    }

    @Override
    public GameProfileRepository getGameProfileRepository() {
        return ((CraftServer)Bukkit.getServer()).getServer().getGameProfileRepository();
    }

    @Override
    public float getHeadYaw(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return entity.getLocation().getYaw();
        }
        return NMSImpl.getHandle((LivingEntity)((LivingEntity)entity)).aK;
    }

    @Override
    public double getHeight(Entity entity) {
        return NMSImpl.getHandle((Entity)entity).length;
    }

    @Override
    public float getHorizontalMovement(Entity entity) {
        if (!entity.getType().isAlive()) {
            return Float.NaN;
        }
        EntityLiving handle = NMSImpl.getHandle((LivingEntity)entity);
        return handle.ba;
    }

    @Override
    public NPC getNPC(Entity entity) {
        net.minecraft.server.v1_8_R3.Entity handle = NMSImpl.getHandle(entity);
        return handle instanceof NPCHolder ? ((NPCHolder)handle).getNPC() : null;
    }

    @Override
    public List<Entity> getPassengers(Entity entity) {
        net.minecraft.server.v1_8_R3.Entity passenger = NMSImpl.getHandle((Entity)entity).passenger;
        if (passenger == null) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Object[])new Entity[]{passenger.getBukkitEntity()});
    }

    @Override
    public GameProfile getProfile(SkullMeta meta) {
        if (SKULL_PROFILE_FIELD == null) {
            try {
                SKULL_PROFILE_FIELD = meta.getClass().getDeclaredField("profile");
                SKULL_PROFILE_FIELD.setAccessible(true);
            }
            catch (Exception e) {
                return null;
            }
        }
        try {
            return (GameProfile)SKULL_PROFILE_FIELD.get(meta);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getSound(String flag) throws CommandException {
        try {
            String ret = CraftSound.getSound((Sound)Sound.valueOf((String)flag.toUpperCase()));
            if (ret == null) {
                throw new CommandException("citizens.commands.npc.sound.invalid-sound");
            }
            return ret;
        }
        catch (Exception e) {
            throw new CommandException("citizens.commands.npc.sound.invalid-sound");
        }
    }

    @Override
    public float getSpeedFor(NPC npc) {
        if (!npc.isSpawned() || !(npc.getEntity() instanceof LivingEntity)) {
            return 1.0f;
        }
        EntityLiving handle = NMSImpl.getHandle((LivingEntity)npc.getEntity());
        if (handle == null) {
            return 1.0f;
        }
        return 1.0f;
    }

    @Override
    public float getStepHeight(Entity entity) {
        return NMSImpl.getHandle((Entity)entity).S;
    }

    @Override
    public MCNavigationStrategy.MCNavigator getTargetNavigator(Entity entity, Iterable<Vector> dest, final NavigatorParameters params) {
        final PathEntity path = new PathEntity((PathPoint[])Iterables.toArray((Iterable)Iterables.transform(dest, (Function)new Function<Vector, PathPoint>(){

            public PathPoint apply(Vector input) {
                return new PathPoint(input.getBlockX(), input.getBlockY(), input.getBlockZ());
            }
        }), PathPoint.class));
        return this.getTargetNavigator(entity, params, new Function<NavigationAbstract, Boolean>(){

            public Boolean apply(NavigationAbstract input) {
                return input.a(path, (double)params.speed());
            }
        });
    }

    @Override
    public MCNavigationStrategy.MCNavigator getTargetNavigator(Entity entity, final Location dest, final NavigatorParameters params) {
        return this.getTargetNavigator(entity, params, new Function<NavigationAbstract, Boolean>(){

            public Boolean apply(NavigationAbstract input) {
                return input.a(dest.getX(), dest.getY(), dest.getZ(), (double)params.speed());
            }
        });
    }

    private MCNavigationStrategy.MCNavigator getTargetNavigator(final Entity entity, final NavigatorParameters params, final Function<NavigationAbstract, Boolean> function) {
        boolean oldAvoidsWater;
        net.minecraft.server.v1_8_R3.Entity raw = NMSImpl.getHandle(entity);
        raw.onGround = true;
        final NavigationAbstract navigation = NMSImpl.getNavigation(entity);
        boolean bl = oldAvoidsWater = navigation instanceof Navigation ? ((Navigation)navigation).e() : false;
        if (navigation instanceof Navigation) {
            ((Navigation)navigation).a(params.avoidWater());
        }
        return new MCNavigationStrategy.MCNavigator(){
            float lastSpeed;
            CancelReason reason;

            @Override
            public CancelReason getCancelReason() {
                return this.reason;
            }

            @Override
            public Iterable<Vector> getPath() {
                return new NavigationIterable(navigation);
            }

            @Override
            public void stop() {
                if (navigation instanceof Navigation) {
                    ((Navigation)navigation).a(oldAvoidsWater);
                }
                NMSImpl.stopNavigation(navigation);
            }

            @Override
            public boolean update() {
                if (params.speed() != this.lastSpeed) {
                    if (Messaging.isDebugging() && this.lastSpeed > 0.0f) {
                        Messaging.debug("Repathfinding " + ((NPCHolder)entity).getNPC().getId() + " due to speed change");
                    }
                    net.minecraft.server.v1_8_R3.Entity handle = NMSImpl.getHandle(entity);
                    float oldWidth = handle.width;
                    if (handle instanceof EntityHorse) {
                        handle.width = Math.min(0.99f, oldWidth);
                    }
                    if (!((Boolean)function.apply((Object)navigation)).booleanValue()) {
                        this.reason = CancelReason.STUCK;
                    }
                    handle.width = oldWidth;
                    this.lastSpeed = params.speed();
                }
                navigation.a(params.speed());
                return NMSImpl.isNavigationFinished(navigation);
            }
        };
    }

    @Override
    public MCTargetStrategy.TargetNavigator getTargetNavigator(Entity entity, Entity target, NavigatorParameters parameters) {
        NavigationAbstract navigation = NMSImpl.getNavigation(entity);
        return navigation == null ? null : new NavigationFieldWrapper(entity, navigation, target, parameters);
    }

    @Override
    public Entity getVehicle(Entity entity) {
        net.minecraft.server.v1_8_R3.Entity handle = NMSImpl.getHandle(entity);
        if (handle == null) {
            return null;
        }
        net.minecraft.server.v1_8_R3.Entity e = handle.vehicle;
        return e == handle || e == null ? null : e.getBukkitEntity();
    }

    @Override
    public float getVerticalMovement(Entity entity) {
        if (!entity.getType().isAlive()) {
            return Float.NaN;
        }
        EntityLiving handle = NMSImpl.getHandle((LivingEntity)entity);
        return handle.aZ;
    }

    @Override
    public double getWidth(Entity entity) {
        return NMSImpl.getHandle((Entity)entity).width;
    }

    @Override
    public float getYaw(Entity entity) {
        return NMSImpl.getHandle((Entity)entity).yaw;
    }

    @Override
    public boolean isOnGround(Entity entity) {
        return NMSImpl.getHandle((Entity)entity).onGround;
    }

    @Override
    public boolean isSolid(org.bukkit.block.Block in) {
        Block block;
        if (GET_NMS_BLOCK == null) {
            return in.getType().isSolid();
        }
        try {
            block = (Block)GET_NMS_BLOCK.invoke((Object)in, new Object[0]);
        }
        catch (Exception e) {
            return in.getType().isSolid();
        }
        return block.w();
    }

    @Override
    public boolean isValid(Entity entity) {
        net.minecraft.server.v1_8_R3.Entity handle = NMSImpl.getHandle(entity);
        return handle.valid && handle.isAlive();
    }

    @Override
    public void load(CommandManager commands) {
    }

    private void loadEntityTypes() {
        EntityControllers.setEntityControllerForType(EntityType.ARROW, ArrowController.class);
        EntityControllers.setEntityControllerForType(EntityType.ARMOR_STAND, ArmorStandController.class);
        EntityControllers.setEntityControllerForType(EntityType.BAT, BatController.class);
        EntityControllers.setEntityControllerForType(EntityType.BLAZE, BlazeController.class);
        EntityControllers.setEntityControllerForType(EntityType.BOAT, BoatController.class);
        EntityControllers.setEntityControllerForType(EntityType.CAVE_SPIDER, CaveSpiderController.class);
        EntityControllers.setEntityControllerForType(EntityType.CHICKEN, ChickenController.class);
        EntityControllers.setEntityControllerForType(EntityType.COW, CowController.class);
        EntityControllers.setEntityControllerForType(EntityType.CREEPER, CreeperController.class);
        EntityControllers.setEntityControllerForType(EntityType.DROPPED_ITEM, ItemController.class);
        EntityControllers.setEntityControllerForType(EntityType.EGG, EggController.class);
        EntityControllers.setEntityControllerForType(EntityType.ENDER_CRYSTAL, EnderCrystalController.class);
        EntityControllers.setEntityControllerForType(EntityType.ENDER_DRAGON, EnderDragonController.class);
        EntityControllers.setEntityControllerForType(EntityType.ENDER_PEARL, EnderPearlController.class);
        EntityControllers.setEntityControllerForType(EntityType.ENDER_SIGNAL, EnderSignalController.class);
        EntityControllers.setEntityControllerForType(EntityType.ENDERMAN, EndermanController.class);
        EntityControllers.setEntityControllerForType(EntityType.ENDERMITE, EndermiteController.class);
        EntityControllers.setEntityControllerForType(EntityType.FALLING_BLOCK, FallingBlockController.class);
        EntityControllers.setEntityControllerForType(EntityType.FIREWORK, FireworkController.class);
        EntityControllers.setEntityControllerForType(EntityType.FIREBALL, LargeFireballController.class);
        EntityControllers.setEntityControllerForType(EntityType.FISHING_HOOK, FishingHookController.class);
        EntityControllers.setEntityControllerForType(EntityType.GHAST, GhastController.class);
        EntityControllers.setEntityControllerForType(EntityType.GIANT, GiantController.class);
        EntityControllers.setEntityControllerForType(EntityType.GUARDIAN, GuardianController.class);
        EntityControllers.setEntityControllerForType(EntityType.HORSE, HorseController.class);
        EntityControllers.setEntityControllerForType(EntityType.IRON_GOLEM, IronGolemController.class);
        EntityControllers.setEntityControllerForType(EntityType.ITEM_FRAME, ItemFrameController.class);
        EntityControllers.setEntityControllerForType(EntityType.LEASH_HITCH, LeashController.class);
        EntityControllers.setEntityControllerForType(EntityType.MAGMA_CUBE, MagmaCubeController.class);
        EntityControllers.setEntityControllerForType(EntityType.MINECART, MinecartRideableController.class);
        EntityControllers.setEntityControllerForType(EntityType.MINECART_CHEST, MinecartChestController.class);
        EntityControllers.setEntityControllerForType(EntityType.MINECART_COMMAND, MinecartCommandController.class);
        EntityControllers.setEntityControllerForType(EntityType.MINECART_FURNACE, MinecartFurnaceController.class);
        EntityControllers.setEntityControllerForType(EntityType.MINECART_HOPPER, MinecartHopperController.class);
        EntityControllers.setEntityControllerForType(EntityType.MINECART_TNT, MinecartTNTController.class);
        EntityControllers.setEntityControllerForType(EntityType.MUSHROOM_COW, MushroomCowController.class);
        EntityControllers.setEntityControllerForType(EntityType.OCELOT, OcelotController.class);
        EntityControllers.setEntityControllerForType(EntityType.PAINTING, PaintingController.class);
        EntityControllers.setEntityControllerForType(EntityType.PIG, PigController.class);
        EntityControllers.setEntityControllerForType(EntityType.PIG_ZOMBIE, PigZombieController.class);
        EntityControllers.setEntityControllerForType(EntityType.SPLASH_POTION, SplashPotionController.class);
        EntityControllers.setEntityControllerForType(EntityType.PLAYER, HumanController.class);
        EntityControllers.setEntityControllerForType(EntityType.RABBIT, RabbitController.class);
        EntityControllers.setEntityControllerForType(EntityType.SHEEP, SheepController.class);
        EntityControllers.setEntityControllerForType(EntityType.SILVERFISH, SilverfishController.class);
        EntityControllers.setEntityControllerForType(EntityType.SKELETON, SkeletonController.class);
        EntityControllers.setEntityControllerForType(EntityType.SLIME, SlimeController.class);
        EntityControllers.setEntityControllerForType(EntityType.SMALL_FIREBALL, SmallFireballController.class);
        EntityControllers.setEntityControllerForType(EntityType.SNOWBALL, SnowballController.class);
        EntityControllers.setEntityControllerForType(EntityType.SNOWMAN, SnowmanController.class);
        EntityControllers.setEntityControllerForType(EntityType.SPIDER, SpiderController.class);
        EntityControllers.setEntityControllerForType(EntityType.SQUID, SquidController.class);
        EntityControllers.setEntityControllerForType(EntityType.THROWN_EXP_BOTTLE, ThrownExpBottleController.class);
        EntityControllers.setEntityControllerForType(EntityType.PRIMED_TNT, TNTPrimedController.class);
        EntityControllers.setEntityControllerForType(EntityType.VILLAGER, VillagerController.class);
        EntityControllers.setEntityControllerForType(EntityType.WOLF, WolfController.class);
        EntityControllers.setEntityControllerForType(EntityType.WITCH, WitchController.class);
        EntityControllers.setEntityControllerForType(EntityType.WITHER, WitherController.class);
        EntityControllers.setEntityControllerForType(EntityType.WITHER_SKULL, WitherSkullController.class);
        EntityControllers.setEntityControllerForType(EntityType.ZOMBIE, ZombieController.class);
    }

    @Override
    public void loadPlugins() {
        ((CraftServer)Bukkit.getServer()).enablePlugins(PluginLoadOrder.POSTWORLD);
    }

    @Override
    public void look(Entity entity, float yaw, float pitch) {
        net.minecraft.server.v1_8_R3.Entity handle = NMSImpl.getHandle(entity);
        if (handle == null) {
            return;
        }
        handle.yaw = yaw = Util.clamp(yaw);
        this.setHeadYaw(entity, yaw);
        handle.pitch = pitch;
    }

    @Override
    public void look(Entity entity, Location to, boolean headOnly, boolean immediate) {
        net.minecraft.server.v1_8_R3.Entity handle = NMSImpl.getHandle(entity);
        if (immediate || headOnly || BAD_CONTROLLER_LOOK.contains(handle.getBukkitEntity().getType()) || !(handle instanceof EntityInsentient) && !(handle instanceof EntityHumanNPC)) {
            Location fromLocation = entity.getLocation(FROM_LOCATION);
            double xDiff = to.getX() - fromLocation.getX();
            double yDiff = to.getY() - fromLocation.getY();
            double zDiff = to.getZ() - fromLocation.getZ();
            double distanceXZ = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
            double distanceY = Math.sqrt(distanceXZ * distanceXZ + yDiff * yDiff);
            double yaw = Math.toDegrees(Math.acos(xDiff / distanceXZ));
            double pitch = Math.toDegrees(Math.acos(yDiff / distanceY)) - 90.0;
            if (zDiff < 0.0) {
                yaw += Math.abs(180.0 - yaw) * 2.0;
            }
            yaw = handle instanceof EntityEnderDragon ? (double)Util.getDragonYaw((Entity)handle.getBukkitEntity(), xDiff, zDiff) : (yaw -= 90.0);
            if (headOnly) {
                this.setHeadYaw(entity, (float)yaw);
            } else {
                this.look(entity, (float)yaw, (float)pitch);
            }
            return;
        }
        if (handle instanceof EntityInsentient) {
            ((EntityInsentient)handle).getControllerLook().a(to.getX(), to.getY(), to.getZ(), 10.0f, (float)((EntityInsentient)handle).bQ());
            while (((EntityInsentient)handle).aK >= 180.0f) {
                ((EntityInsentient)handle).aK -= 360.0f;
            }
            while (((EntityInsentient)handle).aK < -180.0f) {
                ((EntityInsentient)handle).aK += 360.0f;
            }
        } else if (handle instanceof EntityHumanNPC) {
            ((EntityHumanNPC)handle).getNPC().getOrAddTrait(SmoothRotationTrait.class).rotateToFace(to);
        }
    }

    @Override
    public void look(Entity from, Entity to) {
        net.minecraft.server.v1_8_R3.Entity handle = NMSImpl.getHandle(from);
        net.minecraft.server.v1_8_R3.Entity target = NMSImpl.getHandle(to);
        if (BAD_CONTROLLER_LOOK.contains(handle.getBukkitEntity().getType()) || !(handle instanceof EntityInsentient) && !(handle instanceof EntityHumanNPC)) {
            if (to instanceof LivingEntity) {
                this.look(from, ((LivingEntity)to).getEyeLocation(), false, true);
            } else {
                this.look(from, to.getLocation(), false, true);
            }
        } else if (handle instanceof EntityInsentient) {
            ((EntityInsentient)handle).getControllerLook().a(target, 10.0f, (float)((EntityInsentient)handle).bQ());
            while (((EntityLiving)handle).aK >= 180.0f) {
                ((EntityLiving)handle).aK -= 360.0f;
            }
            while (((EntityLiving)handle).aK < -180.0f) {
                ((EntityLiving)handle).aK += 360.0f;
            }
        } else if (handle instanceof EntityHumanNPC) {
            ((EntityHumanNPC)handle).getNPC().getOrAddTrait(SmoothRotationTrait.class).rotateToFace(to);
        }
    }

    @Override
    public void mount(Entity entity, Entity passenger) {
        if (NMSImpl.getHandle(passenger) == null) {
            return;
        }
        NMSImpl.getHandle(passenger).mount(NMSImpl.getHandle(entity));
    }

    @Override
    public InventoryView openAnvilInventory(final Player player, final Inventory anvil, String title) {
        EntityPlayer handle = (EntityPlayer)NMSImpl.getHandle((LivingEntity)player);
        ContainerAnvil container = new ContainerAnvil(handle.inventory, handle.world, new BlockPosition(0, 0, 0), (EntityHuman)handle){
            private CraftInventoryView bukkitEntity;

            public boolean a(EntityHuman entityhuman) {
                return true;
            }

            public void b(EntityHuman entityhuman) {
            }

            public CraftInventoryView getBukkitView() {
                if (this.bukkitEntity != null) {
                    return this.bukkitEntity;
                }
                try {
                    this.bukkitEntity = new CraftInventoryView((HumanEntity)player, (Inventory)new CitizensInventoryAnvil(new Location(player.getWorld(), 0.0, 0.0, 0.0), REPAIR_INVENTORY.invoke(this), RESULT_INVENTORY.invoke(this), this, anvil), (Container)this);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    return super.getBukkitView();
                }
                return this.bukkitEntity;
            }
        };
        container.windowId = handle.nextContainerCounter();
        container.getBukkitView().setItem(0, anvil.getItem(0));
        container.getBukkitView().setItem(1, anvil.getItem(1));
        container.checkReachable = false;
        container.addSlotListener((ICrafting)handle);
        handle.playerConnection.sendPacket((Packet)new PacketPlayOutOpenWindow(container.windowId, "minecraft:anvil", (IChatBaseComponent)new ChatMessage(title, new Object[0])));
        handle.activeContainer = container;
        return container.getBukkitView();
    }

    @Override
    public void openHorseScreen(Tameable horse, Player equipper) {
        EntityLiving handle = NMSImpl.getHandle((LivingEntity)horse);
        EntityLiving equipperHandle = NMSImpl.getHandle((LivingEntity)equipper);
        if (handle == null || equipperHandle == null) {
            return;
        }
        boolean wasTamed = horse.isTamed();
        horse.setTamed(true);
        ((EntityHorse)handle).g((EntityHuman)equipperHandle);
        horse.setTamed(wasTamed);
    }

    @Override
    public void playAnimation(PlayerAnimation animation, Player player, int radius) {
        PlayerAnimationImpl.play(animation, player, radius);
    }

    @Override
    public void playerTick(Player entity) {
        ((EntityPlayer)NMSImpl.getHandle((LivingEntity)entity)).l();
    }

    @Override
    public void registerEntityClass(Class<?> clazz) {
        if (ENTITY_CLASS_TO_INT == null || ENTITY_CLASS_TO_INT.containsKey(clazz)) {
            return;
        }
        Class<?> search = clazz;
        while ((search = search.getSuperclass()) != null && net.minecraft.server.v1_8_R3.Entity.class.isAssignableFrom(search)) {
            if (!ENTITY_CLASS_TO_INT.containsKey(search)) continue;
            int code = ENTITY_CLASS_TO_INT.get(search);
            ENTITY_CLASS_TO_INT.put(clazz, code);
            ENTITY_CLASS_TO_NAME.put(clazz, ENTITY_CLASS_TO_NAME.get(search));
            return;
        }
        throw new IllegalArgumentException("unable to find valid entity superclass for class " + clazz.toString());
    }

    @Override
    public void remove(Entity entity) {
        NMSImpl.getHandle(entity).die();
    }

    @Override
    public void removeFromServerPlayerList(Player player) {
        EntityPlayer handle = (EntityPlayer)NMSImpl.getHandle((LivingEntity)player);
        ((CraftServer)Bukkit.getServer()).getHandle().players.remove(handle);
    }

    @Override
    public void removeFromWorld(Entity entity) {
        Preconditions.checkNotNull((Object)entity);
        net.minecraft.server.v1_8_R3.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.world.removeEntity(nmsEntity);
    }

    @Override
    public void removeHookIfNecessary(NPCRegistry npcRegistry, FishHook entity) {
        EntityFishingHook hook = (EntityFishingHook)NMSImpl.getHandle((Entity)entity);
        if (hook.hooked == null) {
            return;
        }
        NPC npc = npcRegistry.getNPC((Entity)hook.hooked.getBukkitEntity());
        if (npc == null) {
            return;
        }
        if (npc.isProtected()) {
            hook.hooked = null;
            hook.die();
        }
    }

    @Override
    public void replaceTrackerEntry(Player player) {
        WorldServer server = (WorldServer)NMSImpl.getHandle((LivingEntity)player).getWorld();
        EntityTrackerEntry entry = (EntityTrackerEntry)server.getTracker().trackedEntities.get(player.getEntityId());
        if (entry == null) {
            return;
        }
        PlayerlistTrackerEntry replace = new PlayerlistTrackerEntry(entry);
        server.getTracker().trackedEntities.a(player.getEntityId(), (Object)replace);
        if (TRACKED_ENTITY_SET != null) {
            try {
                Set set = (Set)TRACKED_ENTITY_SET.get(server.getTracker());
                set.remove(entry);
                set.add(replace);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (NMSImpl.getHandle((LivingEntity)player) instanceof EntityHumanNPC) {
            ((EntityHumanNPC)NMSImpl.getHandle((LivingEntity)player)).setTracked(replace);
        }
    }

    @Override
    public void sendPositionUpdate(Player excluding, Entity from, Location storedLocation) {
        NMSImpl.sendPacketNearby(excluding, storedLocation, new PacketPlayOutEntityTeleport(NMSImpl.getHandle(from)));
    }

    @Override
    public void sendTabListAdd(Player recipient, Player listPlayer) {
        Preconditions.checkNotNull((Object)recipient);
        Preconditions.checkNotNull((Object)listPlayer);
        EntityPlayer entity = ((CraftPlayer)listPlayer).getHandle();
        NMSImpl.sendPacket(recipient, new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER, new EntityPlayer[]{entity}));
    }

    @Override
    public void sendTabListRemove(Player recipient, Collection<? extends SkinnableEntity> skinnableNPCs) {
        Preconditions.checkNotNull((Object)recipient);
        Preconditions.checkNotNull(skinnableNPCs);
        EntityPlayer[] entities = new EntityPlayer[skinnableNPCs.size()];
        int i = 0;
        for (SkinnableEntity skinnableEntity : skinnableNPCs) {
            entities[i] = (EntityPlayer)skinnableEntity;
            ++i;
        }
        NMSImpl.sendPacket(recipient, new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.REMOVE_PLAYER, entities));
    }

    @Override
    public void sendTabListRemove(Player recipient, Player listPlayer) {
        Preconditions.checkNotNull((Object)recipient);
        Preconditions.checkNotNull((Object)listPlayer);
        EntityPlayer entity = ((CraftPlayer)listPlayer).getHandle();
        NMSImpl.sendPacket(recipient, new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.REMOVE_PLAYER, new EntityPlayer[]{entity}));
    }

    @Override
    public void sendTeamPacket(Player recipient, Team team, int mode) {
        Preconditions.checkNotNull((Object)recipient);
        Preconditions.checkNotNull((Object)team);
        if (TEAM_FIELD == null) {
            TEAM_FIELD = NMS.getField(team.getClass(), "team");
        }
        try {
            ScoreboardTeam nmsTeam = (ScoreboardTeam)TEAM_FIELD.get(team);
            NMSImpl.sendPacket(recipient, new PacketPlayOutScoreboardTeam(nmsTeam, mode));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setAllayDancing(Entity entity, boolean dancing) {
    }

    @Override
    public void setBodyYaw(Entity entity, float yaw) {
        NMSImpl.getHandle((Entity)entity).yaw = yaw;
    }

    @Override
    public void setDestination(Entity entity, double x, double y, double z, float speed) {
        net.minecraft.server.v1_8_R3.Entity handle = NMSImpl.getHandle(entity);
        if (handle == null) {
            return;
        }
        if (handle instanceof EntityInsentient) {
            ((EntityInsentient)handle).getControllerMove().a(x, y, z, (double)speed);
        } else if (handle instanceof EntityHumanNPC) {
            ((EntityHumanNPC)handle).setMoveDestination(x, y, z, speed);
        }
    }

    @Override
    public void setEndermanAngry(Enderman enderman, boolean angry) {
        NMSImpl.getHandle((LivingEntity)enderman).getDataWatcher().watch(17, (Object)((byte)(angry ? 1 : 0)));
    }

    @Override
    public void setHeadYaw(Entity entity, float yaw) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        EntityLiving handle = (EntityLiving)NMSImpl.getHandle(entity);
        handle.aJ = yaw = Util.clamp(yaw);
        if (!(handle instanceof EntityHuman)) {
            handle.aI = yaw;
        }
        handle.aK = yaw;
    }

    @Override
    public void setKnockbackResistance(LivingEntity entity, double d) {
        EntityLiving handle = NMSImpl.getHandle(entity);
        handle.getAttributeInstance(GenericAttributes.c).setValue(d);
    }

    @Override
    public void setLyingDown(Entity cat, boolean lying) {
    }

    @Override
    public void setNavigationTarget(Entity handle, Entity target, float speed) {
        NMSImpl.getNavigation(handle).a(NMSImpl.getHandle(target), (double)speed);
    }

    @Override
    public void setNoGravity(Entity entity, boolean enabled) {
        if (!enabled || ((NPCHolder)entity).getNPC().getNavigator().isNavigating()) {
            return;
        }
        Vector vector = entity.getVelocity();
        vector.setY(Math.max(0.0, vector.getY()));
        entity.setVelocity(vector);
    }

    @Override
    public void setPandaSitting(Entity entity, boolean sitting) {
    }

    @Override
    public void setPeekShulker(Entity shulker, int peek) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPiglinDancing(Entity entity, boolean dancing) {
    }

    @Override
    public void setPitch(Entity entity, float pitch) {
        NMSImpl.getHandle((Entity)entity).pitch = pitch;
    }

    @Override
    public void setPolarBearRearing(Entity entity, boolean rearing) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setProfile(SkullMeta meta, GameProfile profile) {
        if (SKULL_PROFILE_FIELD == null) {
            try {
                SKULL_PROFILE_FIELD = meta.getClass().getDeclaredField("profile");
                SKULL_PROFILE_FIELD.setAccessible(true);
            }
            catch (Exception e) {
                return;
            }
        }
        try {
            SKULL_PROFILE_FIELD.set(meta, profile);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setShouldJump(Entity entity) {
        net.minecraft.server.v1_8_R3.Entity handle = NMSImpl.getHandle(entity);
        if (handle == null) {
            return;
        }
        if (handle instanceof EntityInsentient) {
            ControllerJump controller = ((EntityInsentient)handle).getControllerJump();
            controller.a();
        } else if (handle instanceof EntityHumanNPC) {
            ((EntityHumanNPC)handle).setShouldJump();
        }
    }

    @Override
    public void setSitting(Ocelot ocelot, boolean sitting) {
        this.setSitting((Tameable)ocelot, sitting);
    }

    @Override
    public void setSitting(Tameable tameable, boolean sitting) {
        ((EntityTameableAnimal)NMSImpl.getHandle((LivingEntity)tameable)).setSitting(sitting);
    }

    @Override
    public void setSneaking(Entity entity, boolean sneaking) {
        if (entity instanceof Player) {
            ((Player)entity).setSneaking(sneaking);
        }
    }

    @Override
    public void setStepHeight(Entity entity, float height) {
        NMSImpl.getHandle((Entity)entity).S = height;
    }

    @Override
    public void setTeamNameTagVisible(Team team, boolean visible) {
        if (TEAM_FIELD == null) {
            TEAM_FIELD = NMS.getField(team.getClass(), "team");
        }
        try {
            ScoreboardTeam nmsTeam = (ScoreboardTeam)TEAM_FIELD.get(team);
            nmsTeam.setNameTagVisibility(visible ? ScoreboardTeamBase.EnumNameTagVisibility.ALWAYS : ScoreboardTeamBase.EnumNameTagVisibility.NEVER);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setVerticalMovement(Entity bukkitEntity, double d) {
        if (!bukkitEntity.getType().isAlive()) {
            return;
        }
        EntityLiving handle = NMSImpl.getHandle((LivingEntity)bukkitEntity);
        handle.aZ = (float)d;
    }

    @Override
    public void setWitherCharged(Wither wither, boolean charged) {
        EntityWither handle = ((CraftWither)wither).getHandle();
        handle.r(charged ? 20 : 0);
    }

    @Override
    public boolean shouldJump(Entity entity) {
        if (JUMP_FIELD == null || !(entity instanceof LivingEntity)) {
            return false;
        }
        try {
            return JUMP_FIELD.getBoolean(NMSImpl.getHandle(entity));
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void sleep(Player entity, boolean sleep) {
        EntityPlayer player = (EntityPlayer)NMSImpl.getHandle((LivingEntity)entity);
        if (sleep) {
            PacketPlayOutBed packet = new PacketPlayOutBed((EntityHuman)player, new BlockPosition((int)player.locX, (int)player.locY, (int)player.locZ));
            NMSImpl.sendPacketNearby(entity, entity.getLocation(), packet, 64.0);
        } else {
            PacketPlayOutAnimation packet = new PacketPlayOutAnimation((net.minecraft.server.v1_8_R3.Entity)player, 2);
            NMSImpl.sendPacketNearby(entity, entity.getLocation(), packet, 64.0);
        }
    }

    @Override
    public boolean tick(Entity next) {
        net.minecraft.server.v1_8_R3.Entity entity = NMSImpl.getHandle(next);
        if (!entity.dead) {
            try {
                entity.world.g(entity);
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.a((Throwable)throwable, (String)"Ticking player");
                CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Player being ticked");
                entity.appendEntityCrashDetails(crashreportsystemdetails);
                throw new ReportedException(crashreport);
            }
        }
        boolean removeFromPlayerList = ((NPCHolder)entity).getNPC().data().get("removefromplayerlist", Boolean.valueOf(Settings.Setting.REMOVE_PLAYERS_FROM_PLAYER_LIST.asBoolean()));
        if (entity.dead) {
            entity.world.removeEntity(entity);
            return true;
        }
        if (!removeFromPlayerList) {
            if (!entity.world.players.contains(entity)) {
                entity.world.players.add((EntityHuman)entity);
            }
            return true;
        }
        entity.world.players.remove(entity);
        return false;
    }

    @Override
    public void trySwim(Entity entity) {
        this.trySwim(entity, 0.04f);
    }

    @Override
    public void trySwim(Entity entity, float power) {
        net.minecraft.server.v1_8_R3.Entity handle = NMSImpl.getHandle(entity);
        if (handle == null) {
            return;
        }
        if (RANDOM.nextFloat() < 0.8f && (handle.W() || handle.ab())) {
            handle.motY += (double)power;
        }
    }

    @Override
    public void updateInventoryTitle(Player player, InventoryView view, String newTitle) {
        EntityPlayer handle = (EntityPlayer)NMSImpl.getHandle((LivingEntity)player);
        Container active = handle.activeContainer;
        InventoryType type = view.getTopInventory().getType();
        PacketPlayOutOpenWindow packet = new PacketPlayOutOpenWindow(active.windowId, "minecraft:" + type.name().toLowerCase(), (IChatBaseComponent)new ChatComponentText(newTitle), view.getTopInventory().getSize());
        handle.playerConnection.sendPacket((Packet)packet);
        player.updateInventory();
    }

    @Override
    public void updateNavigationWorld(Entity entity, World world) {
        if (NAVIGATION_WORLD_FIELD == null) {
            return;
        }
        net.minecraft.server.v1_8_R3.Entity en = NMSImpl.getHandle(entity);
        if (en == null || !(en instanceof EntityInsentient)) {
            return;
        }
        EntityInsentient handle = (EntityInsentient)en;
        WorldServer worldHandle = ((CraftWorld)world).getHandle();
        try {
            NAVIGATION_WORLD_FIELD.set(handle.getNavigation(), worldHandle);
        }
        catch (Exception e) {
            Messaging.logTr("citizens.nms-errors.updating-navigation-world", e.getMessage());
        }
    }

    @Override
    public void updatePathfindingRange(NPC npc, float pathfindingRange) {
        if (!npc.isSpawned() || !npc.getEntity().getType().isAlive()) {
            return;
        }
        EntityLiving en = NMSImpl.getHandle((LivingEntity)npc.getEntity());
        if (!(en instanceof EntityInsentient)) {
            if (en instanceof EntityHumanNPC) {
                ((EntityHumanNPC)en).updatePathfindingRange(pathfindingRange);
            }
            return;
        }
        if (PATHFINDING_RANGE == null) {
            return;
        }
        EntityInsentient handle = (EntityInsentient)en;
        NavigationAbstract navigation = handle.getNavigation();
        try {
            AttributeInstance inst = (AttributeInstance)PATHFINDING_RANGE.get(navigation);
            inst.setValue((double)pathfindingRange);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static void clearGoals(PathfinderGoalSelector ... goalSelectors) {
        if (GOAL_FIELD == null || goalSelectors == null) {
            return;
        }
        for (PathfinderGoalSelector selector : goalSelectors) {
            try {
                Collection list = (Collection)GOAL_FIELD.get(selector);
                list.clear();
            }
            catch (Exception e) {
                Messaging.logTr("citizens.nms-errors.clearing-goals", e.getLocalizedMessage());
            }
        }
    }

    public static void flyingMoveLogic(EntityLiving entity, float f, float f1) {
        if (entity.bM()) {
            float f3;
            if (entity.V()) {
                double d0 = entity.locY;
                f3 = 0.8f;
                float f4 = 0.02f;
                float f2 = EnchantmentManager.b((net.minecraft.server.v1_8_R3.Entity)entity);
                if (f2 > 3.0f) {
                    f2 = 3.0f;
                }
                if (!entity.onGround) {
                    f2 *= 0.5f;
                }
                if (f2 > 0.0f) {
                    f3 += (0.54600006f - f3) * f2 / 3.0f;
                    f4 += (entity.bI() * 1.0f - f4) * f2 / 3.0f;
                }
                entity.a(f, f1, f4);
                entity.move(entity.motX, entity.motY, entity.motZ);
                entity.motX *= (double)f3;
                entity.motY *= (double)0.8f;
                entity.motZ *= (double)f3;
                entity.motY -= 0.02;
                if (entity.positionChanged && entity.c(entity.motX, entity.motY + (double)0.6f - entity.locY + d0, entity.motZ)) {
                    entity.motY = 0.3f;
                }
            } else if (entity.ab()) {
                double d0 = entity.locY;
                entity.a(f, f1, 0.02f);
                entity.move(entity.motX, entity.motY, entity.motZ);
                entity.motX *= 0.5;
                entity.motY *= 0.5;
                entity.motZ *= 0.5;
                entity.motY -= 0.02;
                if (entity.positionChanged && entity.c(entity.motX, entity.motY + (double)0.6f - entity.locY + d0, entity.motZ)) {
                    entity.motY = 0.3f;
                }
            } else {
                float f5 = 0.91f;
                if (entity.onGround) {
                    f5 = entity.world.getType((BlockPosition)new BlockPosition((int)MathHelper.floor((double)entity.locX), (int)(MathHelper.floor((double)entity.getBoundingBox().b) - 1), (int)MathHelper.floor((double)entity.locZ))).getBlock().frictionFactor * 0.91f;
                }
                float f6 = 0.16277136f / (f5 * f5 * f5);
                f3 = entity.onGround ? entity.bI() * f6 : entity.aM;
                entity.a(f, f1, f3);
                f5 = 0.91f;
                if (entity.onGround) {
                    f5 = entity.world.getType((BlockPosition)new BlockPosition((int)MathHelper.floor((double)entity.locX), (int)(MathHelper.floor((double)entity.getBoundingBox().b) - 1), (int)MathHelper.floor((double)entity.locZ))).getBlock().frictionFactor * 0.91f;
                }
                if (entity.k_()) {
                    boolean flag;
                    float f4 = 0.15f;
                    entity.motX = MathHelper.a((double)entity.motX, (double)(-f4), (double)f4);
                    entity.motZ = MathHelper.a((double)entity.motZ, (double)(-f4), (double)f4);
                    entity.fallDistance = 0.0f;
                    if (entity.motY < -0.15) {
                        entity.motY = -0.15;
                    }
                    boolean bl = flag = entity.isSneaking() && entity instanceof EntityHuman;
                    if (flag && entity.motY < 0.0) {
                        entity.motY = 0.0;
                    }
                }
                entity.move(entity.motX, entity.motY, entity.motZ);
                if (entity.positionChanged && entity.k_()) {
                    entity.motY = 0.2;
                }
                entity.motY = !(!entity.world.isClientSide || entity.world.isLoaded(new BlockPosition((int)entity.locX, 0, (int)entity.locZ)) && entity.world.getChunkAtWorldCoords(new BlockPosition((int)entity.locX, 0, (int)entity.locZ)).o()) ? (entity.locY > 0.0 ? -0.1 : 0.0) : (entity.motY -= 0.08);
                entity.motY *= (double)0.98f;
                entity.motX *= (double)f5;
                entity.motZ *= (double)f5;
            }
        }
        entity.aA = entity.aB;
        double d0 = entity.locX - entity.lastX;
        double d1 = entity.locZ - entity.lastZ;
        float f2 = MathHelper.sqrt((double)(d0 * d0 + d1 * d1)) * 4.0f;
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        entity.aB += (f2 - entity.aB) * 0.4f;
        entity.aC += entity.aB;
    }

    private static EntityLiving getHandle(LivingEntity entity) {
        return (EntityLiving)NMSImpl.getHandle((Entity)entity);
    }

    public static net.minecraft.server.v1_8_R3.Entity getHandle(Entity entity) {
        if (!(entity instanceof CraftEntity)) {
            return null;
        }
        return ((CraftEntity)entity).getHandle();
    }

    public static float getHeadYaw(EntityLiving handle) {
        return handle.aJ;
    }

    public static NavigationAbstract getNavigation(Entity entity) {
        net.minecraft.server.v1_8_R3.Entity handle = NMSImpl.getHandle(entity);
        return handle instanceof EntityInsentient ? ((EntityInsentient)handle).getNavigation() : (handle instanceof EntityHumanNPC ? ((EntityHumanNPC)handle).getNavigation() : null);
    }

    public static String getSoundEffect(NPC npc, String snd, String meta) {
        return npc == null || !npc.data().has(meta) ? snd : npc.data().get(meta, snd == null ? "" : snd.toString());
    }

    public static void initNetworkManager(NetworkManager network) {
        if (NETWORK_ADDRESS == null) {
            return;
        }
        try {
            network.channel = new EmptyChannel(null);
            NETWORK_ADDRESS.set(network, new SocketAddress(){
                private static final long serialVersionUID = 8207338859896320185L;
            });
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static boolean isNavigationFinished(NavigationAbstract navigation) {
        return navigation.m();
    }

    public static void minecartItemLogic(EntityMinecartAbstract minecart) {
        NPC npc = ((NPCHolder)minecart).getNPC();
        if (npc == null) {
            return;
        }
        Material mat = Material.getMaterial((String)npc.data().get("minecart-item-name", ""));
        int data = npc.data().get("minecart-item-data", Integer.valueOf(0));
        int offset = npc.data().get("minecart-item-offset", Integer.valueOf(0));
        minecart.a(mat != null);
        if (mat != null) {
            minecart.setDisplayBlock(Block.getById((int)mat.getId()).fromLegacyData(data));
        }
        minecart.SetDisplayBlockOffset(offset);
    }

    public static void sendPacket(Player player, Packet<?> packet) {
        if (packet == null) {
            return;
        }
        ((EntityPlayer)NMSImpl.getHandle((LivingEntity)player)).playerConnection.sendPacket(packet);
    }

    public static void sendPacketNearby(Player from, Location location, Packet<?> packet) {
        NMSImpl.sendPacketNearby(from, location, packet, 64.0);
    }

    public static void sendPacketNearby(Player from, Location location, Packet<?> packet, double radius) {
        ArrayList list = new ArrayList();
        list.add(packet);
        NMSImpl.sendPacketsNearby(from, location, list, radius);
    }

    public static void sendPacketsNearby(Player from, Location location, Collection<Packet<?>> packets, double radius) {
        radius *= radius;
        World world = location.getWorld();
        for (Player ply : Bukkit.getServer().getOnlinePlayers()) {
            if (ply == null || world != ply.getWorld() || from != null && !ply.canSee(from) || location.distanceSquared(ply.getLocation(PACKET_CACHE_LOCATION)) > radius) continue;
            for (Packet<?> packet : packets) {
                NMSImpl.sendPacket(ply, packet);
            }
        }
    }

    public static void sendPacketsNearby(Player from, Location location, Packet<?> ... packets) {
        NMSImpl.sendPacketsNearby(from, location, Arrays.asList(packets), 64.0);
    }

    public static void setSize(net.minecraft.server.v1_8_R3.Entity entity, float f, float f1, boolean justCreated) {
        if (f != entity.width || f1 != entity.length) {
            float f2 = entity.width;
            entity.width = f;
            entity.length = f1;
            entity.a(new AxisAlignedBB(entity.getBoundingBox().a, entity.getBoundingBox().b, entity.getBoundingBox().c, entity.getBoundingBox().a + (double)entity.width, entity.getBoundingBox().b + (double)entity.length, entity.getBoundingBox().c + (double)entity.width));
            if (entity.width > f2 && !justCreated && !entity.world.isClientSide) {
                entity.move((double)((f2 - entity.width) / 2.0f), 0.0, (double)((f2 - entity.width) / 2.0f));
            }
        }
    }

    public static void stopNavigation(NavigationAbstract navigation) {
        navigation.n();
    }

    public static void updateAI(EntityLiving entity) {
        if (entity instanceof EntityInsentient) {
            EntityInsentient handle = (EntityInsentient)entity;
            handle.getEntitySenses().a();
            NMSImpl.updateNavigation(handle.getNavigation());
            handle.getControllerMove().c();
            handle.getControllerLook().a();
            handle.getControllerJump().b();
        } else if (entity instanceof EntityHumanNPC) {
            ((EntityHumanNPC)entity).updateAI();
        }
    }

    public static void updateNavigation(NavigationAbstract navigation) {
        navigation.k();
    }

    static {
        FROM_LOCATION = new Location(null, 0.0, 0.0, 0.0);
        GET_NMS_BLOCK = NMS.getMethod(CraftBlock.class, "getNMSBlock", false, new Class[0]);
        GOAL_FIELD = NMS.getField(PathfinderGoalSelector.class, "b");
        JUMP_FIELD = NMS.getField(EntityLiving.class, "aY");
        MOVE_CONTROLLER_MOVING = NMS.getField(ControllerMove.class, "f");
        NAVIGATION_WORLD_FIELD = NMS.getField(NavigationAbstract.class, "c");
        NETWORK_ADDRESS = NMS.getField(NetworkManager.class, "l");
        PACKET_CACHE_LOCATION = new Location(null, 0.0, 0.0, 0.0);
        PATHFINDING_RANGE = NMS.getField(NavigationAbstract.class, "a");
        RANDOM = Util.getFastRandom();
        REPAIR_INVENTORY = NMS.getGetter(ContainerAnvil.class, "g");
        RESULT_INVENTORY = NMS.getGetter(ContainerAnvil.class, "h");
        TRACKED_ENTITY_SET = NMS.getField(EntityTracker.class, "c");
        try {
            Field field = NMS.getField(EntityTypes.class, "f");
            ENTITY_CLASS_TO_INT = (Map)field.get(null);
            field = NMS.getField(EntityTypes.class, "d");
            ENTITY_CLASS_TO_NAME = (Map)field.get(null);
        }
        catch (Exception e) {
            Messaging.logTr("citizens.nms-errors.getting-id-mapping", e.getMessage());
        }
        try {
            MAKE_REQUEST = YggdrasilAuthenticationService.class.getDeclaredMethod("makeRequest", URL.class, Object.class, Class.class);
            MAKE_REQUEST.setAccessible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static class NavigationFieldWrapper
    implements MCTargetStrategy.TargetNavigator {
        private final Entity entity;
        private final NavigationAbstract navigation;
        private final NavigatorParameters parameters;
        private final Entity target;

        private NavigationFieldWrapper(Entity entity, NavigationAbstract navigation, Entity target, NavigatorParameters parameters) {
            this.entity = entity;
            this.navigation = navigation;
            this.target = target;
            this.parameters = parameters;
        }

        @Override
        public Location getCurrentDestination() {
            return NMS.getDestination(this.entity);
        }

        @Override
        public Iterable<Vector> getPath() {
            return new NavigationIterable(this.navigation);
        }

        @Override
        public void setPath() {
            Location location = (Location)this.parameters.entityTargetLocationMapper().apply((Object)this.target);
            if (location == null) {
                throw new IllegalStateException("mapper should not return null");
            }
            this.navigation.a(location.getX(), location.getY(), location.getZ(), (double)this.parameters.speed());
        }

        @Override
        public void stop() {
            NMSImpl.stopNavigation(this.navigation);
        }

        @Override
        public void update() {
            NMSImpl.updateNavigation(this.navigation);
        }
    }

    private static class NavigationIterable
    implements Iterable<Vector> {
        private final NavigationAbstract navigation;

        public NavigationIterable(NavigationAbstract nav) {
            this.navigation = nav;
        }

        @Override
        public Iterator<Vector> iterator() {
            final int npoints = this.navigation.j() == null ? 0 : this.navigation.j().d();
            return new Iterator<Vector>(){
                PathPoint curr;
                int i;
                {
                    this.curr = npoints > 0 ? NavigationIterable.this.navigation.j().a(0) : null;
                    this.i = 0;
                }

                @Override
                public boolean hasNext() {
                    return this.curr != null;
                }

                @Override
                public Vector next() {
                    PathPoint old = this.curr;
                    this.curr = this.i + 1 < npoints ? NavigationIterable.this.navigation.j().a(++this.i) : null;
                    return new Vector(old.a, old.b, old.c);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static class CitizensInventoryAnvil
    extends CraftInventoryAnvil
    implements ForwardingInventory {
        private final Inventory wrapped;

        public CitizensInventoryAnvil(Location location, IInventory inventory, IInventory resultInventory, ContainerAnvil container, Inventory wrapped) {
            super(inventory, resultInventory);
            this.wrapped = wrapped;
        }

        @Override
        public Inventory getWrapped() {
            return this.wrapped;
        }

        public void setItem(int slot, ItemStack item) {
            super.setItem(slot, item);
            this.wrapped.setItem(slot, item);
        }
    }
}

