/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_8_R3.entity.nonliving;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_8_R3.entity.MobEntityController;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_8_R3.EntityWitherSkull;
import net.minecraft.server.v1_8_R3.NBTTagCompound;
import net.minecraft.server.v1_8_R3.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_8_R3.CraftServer;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftWitherSkull;
import org.bukkit.entity.Entity;
import org.bukkit.entity.WitherSkull;
import org.bukkit.util.Vector;

public class WitherSkullController
extends MobEntityController {
    public WitherSkullController() {
        super(EntityWitherSkullNPC.class);
    }

    public WitherSkull getBukkitEntity() {
        return (WitherSkull)super.getBukkitEntity();
    }

    public static class EntityWitherSkullNPC
    extends EntityWitherSkull
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityWitherSkullNPC(World world) {
            this(world, null);
        }

        public EntityWitherSkullNPC(World world, NPC npc) {
            super(world);
            this.npc = (CitizensNPC)npc;
        }

        public void collide(net.minecraft.server.v1_8_R3.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean d(NBTTagCompound save) {
            return this.npc == null ? super.d(save) : false;
        }

        public void g(double x, double y, double z) {
            Vector vector = Util.callPushEvent(this.npc, x, y, z);
            if (vector != null) {
                super.g(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(this.bukkitEntity instanceof NPCHolder)) {
                this.bukkitEntity = new WitherSkullNPC(this);
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public void t_() {
            if (this.npc != null) {
                this.npc.update();
            } else {
                super.t_();
            }
        }
    }

    public static class WitherSkullNPC
    extends CraftWitherSkull
    implements NPCHolder {
        private final CitizensNPC npc;

        public WitherSkullNPC(EntityWitherSkullNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityWitherSkull)entity);
            this.npc = entity.npc;
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }
}

