/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_8_R3.entity.nonliving;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_8_R3.entity.MobEntityController;
import net.citizensnpcs.nms.v1_8_R3.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_8_R3.EntityMinecartAbstract;
import net.minecraft.server.v1_8_R3.EntityMinecartChest;
import net.minecraft.server.v1_8_R3.NBTTagCompound;
import net.minecraft.server.v1_8_R3.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_8_R3.CraftServer;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftMinecartChest;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Minecart;
import org.bukkit.util.Vector;

public class MinecartChestController
extends MobEntityController {
    public MinecartChestController() {
        super(EntityMinecartChestNPC.class);
    }

    public Minecart getBukkitEntity() {
        return (Minecart)super.getBukkitEntity();
    }

    public static class EntityMinecartChestNPC
    extends EntityMinecartChest
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityMinecartChestNPC(World world) {
            this(world, null);
        }

        public EntityMinecartChestNPC(World world, NPC npc) {
            super(world);
            this.npc = (CitizensNPC)npc;
        }

        public void collide(net.minecraft.server.v1_8_R3.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean d(NBTTagCompound save) {
            return this.npc == null ? super.d(save) : false;
        }

        public void g(double x, double y, double z) {
            Vector vector = Util.callPushEvent(this.npc, x, y, z);
            if (vector != null) {
                super.g(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(this.bukkitEntity instanceof NPCHolder)) {
                this.bukkitEntity = new MinecartChestNPC(this);
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public void t_() {
            super.t_();
            if (this.npc != null) {
                this.npc.update();
                NMSImpl.minecartItemLogic((EntityMinecartAbstract)this);
            }
        }
    }

    public static class MinecartChestNPC
    extends CraftMinecartChest
    implements NPCHolder {
        private final CitizensNPC npc;

        public MinecartChestNPC(EntityMinecartChestNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityMinecartChest)entity);
            this.npc = entity.npc;
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }
}

