/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_8_R3.entity.nonliving;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_8_R3.entity.MobEntityController;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_8_R3.EntityFishingHook;
import net.minecraft.server.v1_8_R3.NBTTagCompound;
import net.minecraft.server.v1_8_R3.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_8_R3.CraftServer;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftFish;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FishHook;
import org.bukkit.util.Vector;

public class FishingHookController
extends MobEntityController {
    public FishingHookController() {
        super(EntityFishingHookNPC.class);
    }

    public FishHook getBukkitEntity() {
        return (FishHook)super.getBukkitEntity();
    }

    public static class EntityFishingHookNPC
    extends EntityFishingHook
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityFishingHookNPC(World world) {
            this(world, null);
        }

        public EntityFishingHookNPC(World world, NPC npc) {
            super(world);
            this.npc = (CitizensNPC)npc;
        }

        public void collide(net.minecraft.server.v1_8_R3.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean d(NBTTagCompound save) {
            return this.npc == null ? super.d(save) : false;
        }

        public void g(double x, double y, double z) {
            Vector vector = Util.callPushEvent(this.npc, x, y, z);
            if (vector != null) {
                super.g(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(this.bukkitEntity instanceof NPCHolder)) {
                this.bukkitEntity = new FishingHookNPC(this);
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public void t_() {
            if (this.npc != null) {
                this.npc.update();
            } else {
                super.t_();
            }
        }
    }

    public static class FishingHookNPC
    extends CraftFish
    implements NPCHolder {
        private final CitizensNPC npc;

        public FishingHookNPC(EntityFishingHookNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityFishingHook)entity);
            this.npc = entity.npc;
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }
}

