/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_8_R3.entity.nonliving;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_8_R3.entity.MobEntityController;
import net.citizensnpcs.nms.v1_8_R3.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_8_R3.AxisAlignedBB;
import net.minecraft.server.v1_8_R3.Block;
import net.minecraft.server.v1_8_R3.BlockPosition;
import net.minecraft.server.v1_8_R3.Blocks;
import net.minecraft.server.v1_8_R3.EntityBoat;
import net.minecraft.server.v1_8_R3.EntityLiving;
import net.minecraft.server.v1_8_R3.EnumParticle;
import net.minecraft.server.v1_8_R3.Material;
import net.minecraft.server.v1_8_R3.MathHelper;
import net.minecraft.server.v1_8_R3.NBTTagCompound;
import net.minecraft.server.v1_8_R3.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_8_R3.CraftServer;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftBoat;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_8_R3.event.CraftEventFactory;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class BoatController
extends MobEntityController {
    public BoatController() {
        super(EntityBoatNPC.class);
    }

    public Boat getBukkitEntity() {
        return (Boat)super.getBukkitEntity();
    }

    public static class EntityBoatNPC
    extends EntityBoat
    implements NPCHolder {
        private double b;
        private final CitizensNPC npc;

        public EntityBoatNPC(World world) {
            this(world, null);
        }

        public EntityBoatNPC(World world, NPC npc) {
            super(world);
            this.npc = (CitizensNPC)npc;
        }

        public void collide(net.minecraft.server.v1_8_R3.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean d(NBTTagCompound save) {
            return this.npc == null ? super.d(save) : false;
        }

        public void g(double x, double y, double z) {
            Vector vector = Util.callPushEvent(this.npc, x, y, z);
            if (vector != null) {
                super.g(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(this.bukkitEntity instanceof NPCHolder)) {
                this.bukkitEntity = new BoatNPC(this);
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public void setSize(float f, float f1) {
            if (this.npc == null) {
                super.setSize(f, f1);
            } else {
                NMSImpl.setSize((net.minecraft.server.v1_8_R3.Entity)this, f, f1, this.justCreated);
            }
        }

        public void t_() {
            if (this.npc != null) {
                this.npc.update();
                this.updateBoat();
            } else {
                super.t_();
            }
        }

        private void updateBoat() {
            double d12;
            int j;
            this.lastX = this.locX;
            this.lastY = this.locY;
            this.lastZ = this.locZ;
            int b0 = 5;
            double d0 = 0.0;
            for (int i = 0; i < b0; ++i) {
                double d1 = this.getBoundingBox().b + (this.getBoundingBox().e - this.getBoundingBox().b) * (double)(i + 0) / (double)b0 - 0.125;
                double d2 = this.getBoundingBox().b + (this.getBoundingBox().e - this.getBoundingBox().b) * (double)(i + 1) / (double)b0 - 0.125;
                AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.getBoundingBox().a, d1, this.getBoundingBox().c, this.getBoundingBox().d, d2, this.getBoundingBox().f);
                if (!this.world.b(axisalignedbb, Material.WATER)) continue;
                d0 += 1.0 / (double)b0;
            }
            double d3 = Math.sqrt(this.motX * this.motX + this.motZ * this.motZ);
            if (d3 > 0.2975) {
                double d4 = Math.cos((double)this.yaw * Math.PI / 180.0);
                double d5 = Math.sin((double)this.yaw * Math.PI / 180.0);
                j = 0;
                while ((double)j < 1.0 + d3 * 60.0) {
                    double d9;
                    double d8;
                    double d6 = this.random.nextFloat() * 2.0f - 1.0f;
                    double d7 = (double)(this.random.nextInt(2) * 2 - 1) * 0.7;
                    if (this.random.nextBoolean()) {
                        d8 = this.locX - d4 * d6 * 0.8 + d5 * d7;
                        d9 = this.locZ - d5 * d6 * 0.8 - d4 * d7;
                        this.world.addParticle(EnumParticle.WATER_SPLASH, d8, this.locY - 0.125, d9, this.motX, this.motY, this.motZ, new int[0]);
                    } else {
                        d8 = this.locX + d4 + d5 * d6 * 0.7;
                        d9 = this.locZ + d5 - d4 * d6 * 0.7;
                        this.world.addParticle(EnumParticle.WATER_SPLASH, d8, this.locY - 0.125, d9, this.motX, this.motY, this.motZ, new int[0]);
                    }
                    ++j;
                }
            }
            if (d0 < 1.0) {
                double d = d0 * 2.0 - 1.0;
                this.motY += 0.04 * d;
            } else {
                if (this.motY < 0.0) {
                    this.motY /= 2.0;
                }
                this.motY += 0.007;
            }
            if (this.passenger instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)this.passenger;
                float f = this.passenger.yaw + -entityliving.aZ * 90.0f;
                this.motX += -Math.sin(f * (float)Math.PI / 180.0f) * this.b * (double)entityliving.ba * (double)0.05f;
                this.motZ += Math.cos(f * (float)Math.PI / 180.0f) * this.b * (double)entityliving.ba * (double)0.05f;
            } else if (this.unoccupiedDeceleration >= 0.0) {
                this.motX *= this.unoccupiedDeceleration;
                this.motZ *= this.unoccupiedDeceleration;
                if (this.motX <= 1.0E-5) {
                    this.motX = 0.0;
                }
                if (this.motZ <= 1.0E-5) {
                    this.motZ = 0.0;
                }
            }
            double d4 = Math.sqrt(this.motX * this.motX + this.motZ * this.motZ);
            if (d4 > 0.35) {
                double d = 0.35 / d4;
                this.motX *= d;
                this.motZ *= d;
                d4 = 0.35;
            }
            if (d4 > d3 && this.b < 0.35) {
                this.b += (0.35 - this.b) / 35.0;
                if (this.b > 0.35) {
                    this.b = 0.35;
                }
            } else {
                this.b -= (this.b - 0.07) / 35.0;
                if (this.b < 0.07) {
                    this.b = 0.07;
                }
            }
            for (int k = 0; k < 4; ++k) {
                int l = MathHelper.floor((double)(this.locX + ((double)(k % 2) - 0.5) * 0.8));
                j = MathHelper.floor((double)(this.locZ + ((double)(k / 2) - 0.5) * 0.8));
                for (int i1 = 0; i1 < 2; ++i1) {
                    int j1 = MathHelper.floor((double)this.locY) + i1;
                    BlockPosition blockposition = new BlockPosition(l, j1, j);
                    Block block = this.world.getType(blockposition).getBlock();
                    if (block == Blocks.SNOW_LAYER) {
                        if (CraftEventFactory.callEntityChangeBlockEvent((net.minecraft.server.v1_8_R3.Entity)this, (int)l, (int)j1, (int)j, (Block)Blocks.AIR, (int)0).isCancelled()) continue;
                        this.world.setAir(blockposition);
                        this.positionChanged = false;
                        continue;
                    }
                    if (block != Blocks.WATERLILY || CraftEventFactory.callEntityChangeBlockEvent((net.minecraft.server.v1_8_R3.Entity)this, (int)l, (int)j1, (int)j, (Block)Blocks.AIR, (int)0).isCancelled()) continue;
                    this.world.setAir(blockposition, true);
                    this.positionChanged = false;
                }
            }
            if (this.onGround && !this.landBoats) {
                this.motX *= 0.5;
                this.motY *= 0.5;
                this.motZ *= 0.5;
            }
            this.move(this.motX, this.motY, this.motZ);
            if (!this.positionChanged || !(d3 > 0.2975)) {
                this.motX *= 0.99;
                this.motY *= 0.95;
                this.motZ *= 0.99;
            }
            this.pitch = 0.0f;
            double d5 = this.yaw;
            double d10 = this.lastX - this.locX;
            double d11 = this.lastZ - this.locZ;
            if (d10 * d10 + d11 * d11 > 0.001) {
                d5 = (float)(MathHelper.b((double)d11, (double)d10) * 180.0 / Math.PI);
            }
            if ((d12 = MathHelper.g((double)(d5 - (double)this.yaw))) > 20.0) {
                d12 = 20.0;
            }
            if (d12 < -20.0) {
                d12 = -20.0;
            }
            this.yaw = (float)((double)this.yaw + d12);
        }
    }

    public static class BoatNPC
    extends CraftBoat
    implements NPCHolder {
        private final CitizensNPC npc;

        public BoatNPC(EntityBoatNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityBoat)entity);
            this.npc = entity.npc;
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }
}

