/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_8_R3.entity;

import net.citizensnpcs.api.event.NPCEnderTeleportEvent;
import net.citizensnpcs.api.event.NPCKnockbackEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_8_R3.entity.MobEntityController;
import net.citizensnpcs.nms.v1_8_R3.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_8_R3.Block;
import net.minecraft.server.v1_8_R3.BlockPosition;
import net.minecraft.server.v1_8_R3.EntityLiving;
import net.minecraft.server.v1_8_R3.EntityWolf;
import net.minecraft.server.v1_8_R3.NBTTagCompound;
import net.minecraft.server.v1_8_R3.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_8_R3.CraftServer;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftWolf;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Wolf;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.util.Vector;

public class WolfController
extends MobEntityController {
    public WolfController() {
        super(EntityWolfNPC.class);
    }

    public Wolf getBukkitEntity() {
        return (Wolf)super.getBukkitEntity();
    }

    public static class EntityWolfNPC
    extends EntityWolf
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityWolfNPC(World world) {
            this(world, null);
        }

        public EntityWolfNPC(World world, NPC npc) {
            super(world);
            this.npc = (CitizensNPC)npc;
        }

        public void a(boolean flag) {
            float oldw = this.width;
            float oldl = this.length;
            super.a(flag);
            if (oldw != this.width || oldl != this.length) {
                this.setPosition(this.locX - 0.01, this.locY, this.locZ - 0.01);
                this.setPosition(this.locX + 0.01, this.locY, this.locZ + 0.01);
            }
        }

        protected void a(double d0, boolean flag, Block block, BlockPosition blockposition) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.a(d0, flag, block, blockposition);
            }
        }

        public void a(net.minecraft.server.v1_8_R3.Entity entity, float strength, double dx, double dz) {
            NPCKnockbackEvent event = new NPCKnockbackEvent(this.npc, strength, dx, dz);
            Bukkit.getPluginManager().callEvent((Event)event);
            Vector kb = event.getKnockbackVector();
            super.a(entity, (float)event.getStrength(), kb.getX(), kb.getZ());
        }

        protected String bo() {
            return NMSImpl.getSoundEffect(this.npc, super.bo(), "hurt-sound");
        }

        protected String bp() {
            return NMSImpl.getSoundEffect(this.npc, super.bp(), "death-sound");
        }

        public boolean cc() {
            if (this.npc == null) {
                return super.cc();
            }
            boolean protectedDefault = this.npc.data().get("protected", Boolean.valueOf(true));
            if (!protectedDefault || !this.npc.data().get("protected-leash", Boolean.valueOf(protectedDefault)).booleanValue()) {
                return super.cc();
            }
            if (super.cc()) {
                this.unleash(true, false);
            }
            return false;
        }

        public void collide(net.minecraft.server.v1_8_R3.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean d(NBTTagCompound save) {
            return this.npc == null ? super.d(save) : false;
        }

        protected void D() {
            if (this.npc == null) {
                super.D();
            }
        }

        public void e(float f, float f1) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.e(f, f1);
            }
        }

        public void E() {
            super.E();
            if (this.npc != null) {
                this.npc.update();
            }
        }

        public void enderTeleportTo(double d0, double d1, double d2) {
            if (this.npc == null) {
                super.enderTeleportTo(d0, d1, d2);
            }
            NPCEnderTeleportEvent event = new NPCEnderTeleportEvent(this.npc);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                super.enderTeleportTo(d0, d1, d2);
            }
        }

        public void g(double x, double y, double z) {
            Vector vector = Util.callPushEvent(this.npc, x, y, z);
            if (vector != null) {
                super.g(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public void g(float f, float f1) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.g(f, f1);
            } else {
                NMSImpl.flyingMoveLogic((EntityLiving)this, f, f1);
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(this.bukkitEntity instanceof NPCHolder)) {
                this.bukkitEntity = new WolfNPC(this);
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public boolean k_() {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.k_();
            }
            return false;
        }

        public void setGoalTarget(EntityLiving entityliving, EntityTargetEvent.TargetReason reason, boolean fire) {
            if (this.npc == null || this.equals(entityliving)) {
                super.setGoalTarget(entityliving, reason, fire);
            }
        }

        protected String z() {
            return NMSImpl.getSoundEffect(this.npc, super.z(), "ambient-sound");
        }
    }

    public static class WolfNPC
    extends CraftWolf
    implements NPCHolder {
        private final CitizensNPC npc;

        public WolfNPC(EntityWolfNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityWolf)entity);
            this.npc = entity.npc;
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public void setSitting(boolean sitting) {
            this.getHandle().setSitting(sitting);
        }
    }
}

