/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_8_R3.entity;

import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.NPCEnderTeleportEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Inventory;
import net.citizensnpcs.api.util.SpigotUtil;
import net.citizensnpcs.nms.v1_8_R3.network.EmptyNetHandler;
import net.citizensnpcs.nms.v1_8_R3.network.EmptyNetworkManager;
import net.citizensnpcs.nms.v1_8_R3.network.EmptySocket;
import net.citizensnpcs.nms.v1_8_R3.util.NMSImpl;
import net.citizensnpcs.nms.v1_8_R3.util.PlayerControllerJump;
import net.citizensnpcs.nms.v1_8_R3.util.PlayerControllerMove;
import net.citizensnpcs.nms.v1_8_R3.util.PlayerNavigation;
import net.citizensnpcs.nms.v1_8_R3.util.PlayerlistTrackerEntry;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.npc.skin.SkinPacketTracker;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.trait.Gravity;
import net.citizensnpcs.trait.SkinTrait;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_8_R3.AttributeInstance;
import net.minecraft.server.v1_8_R3.AxisAlignedBB;
import net.minecraft.server.v1_8_R3.Block;
import net.minecraft.server.v1_8_R3.BlockPosition;
import net.minecraft.server.v1_8_R3.DamageSource;
import net.minecraft.server.v1_8_R3.DataWatcher;
import net.minecraft.server.v1_8_R3.Entity;
import net.minecraft.server.v1_8_R3.EntityHuman;
import net.minecraft.server.v1_8_R3.EntityLiving;
import net.minecraft.server.v1_8_R3.EntityPlayer;
import net.minecraft.server.v1_8_R3.EnumProtocolDirection;
import net.minecraft.server.v1_8_R3.GenericAttributes;
import net.minecraft.server.v1_8_R3.ItemStack;
import net.minecraft.server.v1_8_R3.MinecraftServer;
import net.minecraft.server.v1_8_R3.NavigationAbstract;
import net.minecraft.server.v1_8_R3.Packet;
import net.minecraft.server.v1_8_R3.PacketListener;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityEquipment;
import net.minecraft.server.v1_8_R3.PlayerInteractManager;
import net.minecraft.server.v1_8_R3.WorldServer;
import net.minecraft.server.v1_8_R3.WorldSettings;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_8_R3.CraftServer;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class EntityHumanNPC
extends EntityPlayer
implements NPCHolder,
SkinnableEntity {
    private PlayerControllerJump controllerJump;
    private PlayerControllerMove controllerMove;
    private final Map<Integer, ItemStack> equipmentCache = new HashMap<Integer, ItemStack>();
    private int jumpTicks = 0;
    private PlayerNavigation navigation;
    private final CitizensNPC npc;
    private final Location packetLocationCache = new Location(null, 0.0, 0.0, 0.0);
    private final SkinPacketTracker skinTracker;
    private PlayerlistTrackerEntry trackerEntry;
    private int updateCounter = 0;
    private static final float EPSILON = 0.003f;
    private static final Location LOADED_LOCATION = new Location(null, 0.0, 0.0, 0.0);

    public EntityHumanNPC(MinecraftServer minecraftServer, WorldServer world, GameProfile gameProfile, PlayerInteractManager playerInteractManager, NPC npc) {
        super(minecraftServer, world, gameProfile, playerInteractManager);
        this.npc = (CitizensNPC)npc;
        if (npc != null) {
            this.skinTracker = new SkinPacketTracker(this);
            playerInteractManager.setGameMode(WorldSettings.EnumGamemode.SURVIVAL);
            this.initialise(minecraftServer);
        } else {
            this.skinTracker = null;
        }
    }

    protected void a(double d0, boolean flag, Block block, BlockPosition blockposition) {
        if (this.npc == null || !this.npc.isFlyable()) {
            super.a(d0, flag, block, blockposition);
        }
    }

    public boolean a(EntityPlayer entityplayer) {
        if (this.npc != null && this.trackerEntry == null) {
            return false;
        }
        return super.a(entityplayer);
    }

    public boolean ae() {
        return this.npc == null ? super.ae() : (this.npc.data().has("collidable") ? (Boolean)this.npc.data().get("collidable") : !this.npc.isProtected());
    }

    protected String bo() {
        return NMSImpl.getSoundEffect(this.npc, super.bo(), "hurt-sound");
    }

    protected String bp() {
        return NMSImpl.getSoundEffect(this.npc, super.bp(), "death-sound");
    }

    public void collide(Entity entity) {
        super.collide(entity);
        if (this.npc != null) {
            Util.callCollisionEvent(this.npc, (org.bukkit.entity.Entity)entity.getBukkitEntity());
        }
    }

    public boolean damageEntity(DamageSource damagesource, float f) {
        boolean damaged = super.damageEntity(damagesource, f);
        if (damaged && this.velocityChanged) {
            this.velocityChanged = false;
        }
        return damaged;
    }

    public void die(DamageSource damagesource) {
        if (this.dead) {
            return;
        }
        super.die(damagesource);
        Bukkit.getScheduler().runTaskLater(CitizensAPI.getPlugin(), new Runnable(){

            @Override
            public void run() {
                EntityHumanNPC.this.world.removeEntity((Entity)EntityHumanNPC.this);
            }
        }, 15L);
    }

    public void e(float f, float f1) {
        if (this.npc == null || !this.npc.isFlyable()) {
            super.e(f, f1);
        }
    }

    public void enderTeleportTo(double d0, double d1, double d2) {
        if (this.npc == null) {
            super.enderTeleportTo(d0, d1, d2);
        }
        NPCEnderTeleportEvent event = new NPCEnderTeleportEvent(this.npc);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            super.enderTeleportTo(d0, d1, d2);
        }
    }

    public void g(double x, double y, double z) {
        Vector vector = Util.callPushEvent(this.npc, x, y, z);
        if (vector != null) {
            super.g(vector.getX(), vector.getY(), vector.getZ());
        }
    }

    public void g(float f, float f1) {
        if (this.npc == null || !this.npc.isFlyable()) {
            super.g(f, f1);
        } else {
            NMSImpl.flyingMoveLogic((EntityLiving)this, f, f1);
        }
    }

    public CraftPlayer getBukkitEntity() {
        if (this.npc != null && this.bukkitEntity == null) {
            this.bukkitEntity = new PlayerNPC(this);
        }
        return super.getBukkitEntity();
    }

    public PlayerControllerJump getControllerJump() {
        return this.controllerJump;
    }

    public PlayerControllerMove getControllerMove() {
        return this.controllerMove;
    }

    public DataWatcher getDataWatcher() {
        if (this.trackerEntry != null && this.trackerEntry.isUpdating()) {
            this.trackerEntry.updateLastPlayer();
        }
        return super.getDataWatcher();
    }

    public NavigationAbstract getNavigation() {
        return this.navigation;
    }

    @Override
    public NPC getNPC() {
        return this.npc;
    }

    @Override
    public String getSkinName() {
        String skinName = this.npc.getOrAddTrait(SkinTrait.class).getSkinName();
        if (skinName == null) {
            skinName = this.npc.getName();
        }
        return skinName.toLowerCase();
    }

    @Override
    public SkinPacketTracker getSkinTracker() {
        return this.skinTracker;
    }

    public boolean inBlock() {
        if (this.npc == null || this.noclip || this.isSleeping()) {
            return super.inBlock();
        }
        return Util.inBlock((org.bukkit.entity.Entity)this.getBukkitEntity());
    }

    private void initialise(MinecraftServer minecraftServer) {
        EmptySocket socket = new EmptySocket();
        EmptyNetworkManager conn = null;
        try {
            conn = new EmptyNetworkManager(EnumProtocolDirection.CLIENTBOUND);
            this.playerConnection = new EmptyNetHandler(minecraftServer, conn, this);
            conn.a((PacketListener)this.playerConnection);
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        AttributeInstance range = this.getAttributeInstance(GenericAttributes.FOLLOW_RANGE);
        if (range == null) {
            range = this.getAttributeMap().b(GenericAttributes.FOLLOW_RANGE);
        }
        range.setValue(Settings.Setting.DEFAULT_PATHFINDING_RANGE.asDouble());
        this.controllerJump = new PlayerControllerJump(this);
        this.controllerMove = new PlayerControllerMove((EntityLiving)this);
        this.navigation = new PlayerNavigation(this, this.world);
        this.invulnerableTicks = 0;
        NMS.setStepHeight((org.bukkit.entity.Entity)this.getBukkitEntity(), 1.0f);
        this.setSkinFlags((byte)-1);
    }

    public boolean isNavigating() {
        return this.npc.getNavigator().isNavigating();
    }

    public boolean k_() {
        if (this.npc == null || !this.npc.isFlyable()) {
            return super.k_();
        }
        return false;
    }

    public void l() {
        boolean navigating;
        if (this.npc == null) {
            super.l();
            return;
        }
        super.K();
        boolean bl = navigating = this.npc.getNavigator().isNavigating() || this.controllerMove.a();
        if (!navigating && this.getBukkitEntity() != null && (!this.npc.hasTrait(Gravity.class) || this.npc.getOrAddTrait(Gravity.class).hasGravity()) && Util.isLoaded(this.getBukkitEntity().getLocation(LOADED_LOCATION)) && SpigotUtil.checkYSafe(this.locY, this.getBukkitEntity().getWorld())) {
            this.moveWithFallDamage(0.0f, 0.0f);
        }
        if (Math.abs(this.motX) < (double)0.003f && Math.abs(this.motY) < (double)0.003f && Math.abs(this.motZ) < (double)0.003f) {
            this.motZ = 0.0;
            this.motY = 0.0;
            this.motX = 0.0;
        }
        if (navigating) {
            if (!NMSImpl.isNavigationFinished(this.navigation)) {
                NMSImpl.updateNavigation(this.navigation);
            }
            this.moveOnCurrentHeading();
        }
        NMSImpl.updateAI((EntityLiving)this);
        if (this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue()) {
            this.bL();
        }
        if (this.npc.data().get(NPC.Metadata.PICKUP_ITEMS, Boolean.valueOf(!this.npc.isProtected())).booleanValue()) {
            AxisAlignedBB axisalignedbb = null;
            axisalignedbb = this.vehicle != null && !this.vehicle.dead ? this.getBoundingBox().a(this.vehicle.getBoundingBox()).grow(1.0, 0.0, 1.0) : this.getBoundingBox().grow(1.0, 0.5, 1.0);
            for (Entity entity : this.world.getEntities((Entity)this, axisalignedbb)) {
                if (entity.dead) continue;
                entity.d((EntityHuman)this);
            }
        }
    }

    private void moveOnCurrentHeading() {
        if (this.aY) {
            if (this.onGround && this.jumpTicks == 0) {
                this.bF();
                this.jumpTicks = 10;
            }
        } else {
            this.jumpTicks = 0;
        }
        this.aZ *= 0.98f;
        this.ba *= 0.98f;
        this.bb *= 0.9f;
        this.moveWithFallDamage(this.aZ, this.ba);
        NMS.setHeadYaw((org.bukkit.entity.Entity)this.getBukkitEntity(), this.yaw);
        if (this.jumpTicks > 0) {
            --this.jumpTicks;
        }
    }

    private void moveWithFallDamage(float mx, float my) {
        double y = this.locY;
        this.g(mx, my);
        if (!this.npc.isProtected()) {
            this.a(this.locY - y, this.onGround);
        }
    }

    public void setMoveDestination(double x, double y, double z, double speed) {
        this.controllerMove.a(x, y, z, speed);
    }

    public void setShouldJump() {
        this.controllerJump.a();
    }

    @Override
    public void setSkinFlags(byte flags) {
        this.getDataWatcher().watch(10, (Object)flags);
    }

    @Override
    public void setSkinName(String name) {
        this.npc.getOrAddTrait(SkinTrait.class).setSkinName(name);
    }

    @Override
    public void setSkinName(String name, boolean forceUpdate) {
        this.npc.getOrAddTrait(SkinTrait.class).setSkinName(name, forceUpdate);
    }

    @Override
    public void setSkinPersistent(String skinName, String signature, String data) {
        this.npc.getOrAddTrait(SkinTrait.class).setSkinPersistent(skinName, signature, data);
    }

    public void setTracked(PlayerlistTrackerEntry trackerEntry) {
        this.trackerEntry = trackerEntry;
    }

    public void t_() {
        super.t_();
        if (this.npc == null) {
            return;
        }
        if (this.updateCounter + 1 > Settings.Setting.PACKET_UPDATE_DELAY.asInt()) {
            this.updateEffects = true;
        }
        this.noclip = this.isSpectator();
        Bukkit.getServer().getPluginManager().unsubscribeFromPermission("bukkit.broadcast.user", (Permissible)this.bukkitEntity);
        boolean navigating = this.npc.getNavigator().isNavigating();
        this.updatePackets(navigating);
        this.npc.update();
    }

    public void updateAI() {
        this.controllerMove.c();
        this.controllerJump.b();
    }

    private void updatePackets(boolean navigating) {
        if (this.updateCounter++ <= this.npc.data().get(NPC.Metadata.PACKET_UPDATE_DELAY, Integer.valueOf(Settings.Setting.PACKET_UPDATE_DELAY.asInt()))) {
            return;
        }
        this.updateCounter = 0;
        boolean itemChanged = false;
        for (int slot = 0; slot < this.inventory.armor.length; ++slot) {
            ItemStack equipment = this.getEquipment(slot);
            ItemStack cache = this.equipmentCache.get(slot);
            if (!(cache == null && equipment == null || !(cache == null ^ equipment == null) && ItemStack.equals((ItemStack)cache, (ItemStack)equipment))) {
                itemChanged = true;
            }
            this.equipmentCache.put(slot, equipment);
        }
        if (!itemChanged) {
            return;
        }
        Location current = this.getBukkitEntity().getLocation(this.packetLocationCache);
        Packet[] packets = new Packet[this.inventory.armor.length];
        for (int i = 0; i < this.inventory.armor.length; ++i) {
            packets[i] = new PacketPlayOutEntityEquipment(this.getId(), i, this.getEquipment(i));
        }
        NMSImpl.sendPacketsNearby((Player)this.getBukkitEntity(), current, packets);
    }

    public void updatePathfindingRange(float pathfindingRange) {
        this.navigation.setRange(pathfindingRange);
    }

    public static class PlayerNPC
    extends CraftPlayer
    implements NPCHolder,
    SkinnableEntity {
        private final CraftServer cserver;
        private final CitizensNPC npc;

        private PlayerNPC(EntityHumanNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityPlayer)entity);
            this.npc = entity.npc;
            this.cserver = (CraftServer)Bukkit.getServer();
            this.npc.getOrAddTrait(Inventory.class);
        }

        @Override
        public Player getBukkitEntity() {
            return this;
        }

        public EntityHumanNPC getHandle() {
            return (EntityHumanNPC)this.entity;
        }

        public List<MetadataValue> getMetadata(String metadataKey) {
            return this.cserver.getEntityMetadata().getMetadata((Object)this, metadataKey);
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        @Override
        public String getSkinName() {
            return ((SkinnableEntity)this.entity).getSkinName();
        }

        @Override
        public SkinPacketTracker getSkinTracker() {
            return ((SkinnableEntity)this.entity).getSkinTracker();
        }

        public boolean hasMetadata(String metadataKey) {
            return this.cserver.getEntityMetadata().hasMetadata((Object)this, metadataKey);
        }

        public void removeMetadata(String metadataKey, Plugin owningPlugin) {
            this.cserver.getEntityMetadata().removeMetadata((Object)this, metadataKey, owningPlugin);
        }

        public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
            this.cserver.getEntityMetadata().setMetadata((Object)this, metadataKey, newMetadataValue);
        }

        @Override
        public void setSkinFlags(byte flags) {
            ((SkinnableEntity)this.entity).setSkinFlags(flags);
        }

        @Override
        public void setSkinName(String name) {
            ((SkinnableEntity)this.entity).setSkinName(name);
        }

        @Override
        public void setSkinName(String skinName, boolean forceUpdate) {
            ((SkinnableEntity)this.entity).setSkinName(skinName, forceUpdate);
        }

        @Override
        public void setSkinPersistent(String skinName, String signature, String data) {
            ((SkinnableEntity)this.entity).setSkinPersistent(skinName, signature, data);
        }
    }
}

