/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_19_R1.util;

import java.lang.invoke.MethodHandle;
import java.util.Objects;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.nms.v1_19_R1.entity.EntityHumanNPC;
import net.citizensnpcs.nms.v1_19_R1.util.NMSImpl;
import net.citizensnpcs.util.NMS;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.world.entity.Entity;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class PlayerlistTracker
extends PlayerChunkMap.EntityTracker {
    private EntityPlayer lastUpdatedPlayer;
    private final Entity tracker;
    private static final MethodHandle E = NMS.getGetter(EntityTrackerEntry.class, "e");
    private static final MethodHandle F = NMS.getGetter(EntityTrackerEntry.class, "f");
    private static final MethodHandle TRACKER = NMS.getFirstGetter(PlayerChunkMap.EntityTracker.class, Entity.class);
    private static final MethodHandle TRACKER_ENTRY = NMS.getFirstGetter(PlayerChunkMap.EntityTracker.class, EntityTrackerEntry.class);
    private static final MethodHandle TRACKING_DISTANCE = NMS.getFirstGetter(PlayerChunkMap.EntityTracker.class, Integer.TYPE);

    public PlayerlistTracker(PlayerChunkMap map, Entity entity, int i, int j, boolean flag) {
        PlayerChunkMap playerChunkMap = map;
        Objects.requireNonNull(playerChunkMap);
        super(playerChunkMap, entity, i, j, flag);
        this.tracker = entity;
    }

    public PlayerlistTracker(PlayerChunkMap map, PlayerChunkMap.EntityTracker entry) {
        this(map, PlayerlistTracker.getTracker(entry), PlayerlistTracker.getTrackingDistance(entry), PlayerlistTracker.getE(entry), PlayerlistTracker.getF(entry));
    }

    public void updateLastPlayer() {
        if (this.tracker.dt()) {
            return;
        }
        final EntityPlayer entityplayer = this.lastUpdatedPlayer;
        if (entityplayer == null) {
            return;
        }
        NMS.sendTabListAdd((Player)entityplayer.getBukkitEntity(), (Player)this.tracker.getBukkitEntity());
        if (!Settings.Setting.DISABLE_TABLIST.asBoolean()) {
            return;
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), new Runnable(){

            @Override
            public void run() {
                NMSImpl.sendPacket((Player)entityplayer.getBukkitEntity(), new PacketPlayOutAnimation(PlayerlistTracker.this.tracker, 0));
                NMS.sendTabListRemove((Player)entityplayer.getBukkitEntity(), (Player)PlayerlistTracker.this.tracker.getBukkitEntity());
            }
        }, (long)Settings.Setting.TABLIST_REMOVE_PACKET_DELAY.asInt());
    }

    public void b(EntityPlayer entityplayer) {
        if (entityplayer instanceof EntityHumanNPC) {
            return;
        }
        this.lastUpdatedPlayer = entityplayer;
        super.b(entityplayer);
    }

    private static int getE(PlayerChunkMap.EntityTracker entry) {
        try {
            return E.invoke(TRACKER_ENTRY.invoke(entry));
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            return 0;
        }
    }

    private static boolean getF(PlayerChunkMap.EntityTracker entry) {
        try {
            return F.invoke(TRACKER_ENTRY.invoke(entry));
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            return false;
        }
    }

    private static Entity getTracker(PlayerChunkMap.EntityTracker entry) {
        try {
            return TRACKER.invoke(entry);
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            return null;
        }
    }

    private static int getTrackingDistance(PlayerChunkMap.EntityTracker entry) {
        try {
            return TRACKING_DISTANCE.invoke(entry);
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            return 0;
        }
    }
}

