/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_19_R1.entity.nonliving;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_19_R1.entity.MobEntityController;
import net.citizensnpcs.nms.v1_19_R1.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_19_R1.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.core.Position;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.entity.vehicle.EntityMinecartFurnace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_19_R1.CraftServer;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftMinecartFurnace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Minecart;
import org.bukkit.util.Vector;

public class MinecartFurnaceController
extends MobEntityController {
    public MinecartFurnaceController() {
        super(EntityMinecartFurnaceNPC.class);
    }

    public Minecart getBukkitEntity() {
        return (Minecart)super.getBukkitEntity();
    }

    public static class EntityMinecartFurnaceNPC
    extends EntityMinecartFurnace
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityMinecartFurnaceNPC(EntityTypes<? extends EntityMinecartFurnace> types, World level) {
            this(types, level, null);
        }

        public EntityMinecartFurnaceNPC(EntityTypes<? extends EntityMinecartFurnace> types, World level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new MinecartFurnaceNPC(this));
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public void i(double x, double y, double z) {
            Vector vector = Util.callPushEvent(this.npc, x, y, z);
            if (vector != null) {
                super.i(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public void g(net.minecraft.world.entity.Entity entity) {
            super.g(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean e(NBTTagCompound save) {
            return this.npc == null ? super.e(save) : false;
        }

        public net.minecraft.world.entity.Entity teleportTo(WorldServer worldserver, Position location) {
            if (this.npc == null) {
                return super.teleportTo(worldserver, location);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, worldserver, location);
        }

        public void k() {
            super.k();
            if (this.npc != null) {
                this.npc.update();
                NMSImpl.minecartItemLogic((EntityMinecartAbstract)this);
            }
        }

        public boolean a(TagKey<FluidType> tagkey, double d0) {
            Vec3D old = this.dd().b(0.0, 0.0, 0.0);
            boolean res = super.a(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.f(old);
            }
            return res;
        }
    }

    public static class MinecartFurnaceNPC
    extends CraftMinecartFurnace
    implements ForwardingNPCHolder {
        public MinecartFurnaceNPC(EntityMinecartFurnaceNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityMinecartFurnace)entity);
        }
    }
}

