/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_19_R1.entity.nonliving;

import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.SpawnReason;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_19_R1.util.NMSImpl;
import net.citizensnpcs.npc.AbstractEntityController;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.core.Position;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_19_R1.CraftServer;
import org.bukkit.craftbukkit.v1_19_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftFallingBlock;
import org.bukkit.craftbukkit.v1_19_R1.util.CraftMagicNumbers;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.util.Vector;

public class FallingBlockController
extends AbstractEntityController {
    public FallingBlockController() {
        super(EntityFallingBlockNPC.class);
    }

    @Override
    protected Entity createEntity(Location at, NPC npc) {
        WorldServer ws = ((CraftWorld)at.getWorld()).getHandle();
        Block id = Blocks.b;
        int data = npc.data().get("item-type-data", npc.data().get("falling-block-data", Integer.valueOf(0)));
        if (npc.data().has("falling-block-id") || npc.data().has("item-type-id")) {
            id = CraftMagicNumbers.getBlock((Material)Material.getMaterial((String)npc.data().get("item-type-id", (String)npc.data().get("falling-block-id")), (boolean)false));
        }
        EntityFallingBlockNPC handle = new EntityFallingBlockNPC((EntityTypes<? extends EntityFallingBlock>)EntityTypes.E, (World)ws, npc);
        handle.e(at.getX(), at.getY(), at.getZ());
        handle.f(Vec3D.b);
        NMSImpl.setFallingBlockState(handle, id.m());
        return handle.getBukkitEntity();
    }

    public FallingBlock getBukkitEntity() {
        return (FallingBlock)super.getBukkitEntity();
    }

    public static class EntityFallingBlockNPC
    extends EntityFallingBlock
    implements NPCHolder {
        private final CitizensNPC npc;
        private static final double EPSILON = 0.001;

        public EntityFallingBlockNPC(EntityTypes<? extends EntityFallingBlock> types, World level) {
            this(types, level, null);
        }

        public EntityFallingBlockNPC(EntityTypes<? extends EntityFallingBlock> types, World level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new FallingBlockNPC(this));
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public void i(double x, double y, double z) {
            Vector vector = Util.callPushEvent(this.npc, x, y, z);
            if (vector != null) {
                super.i(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public void g(net.minecraft.world.entity.Entity entity) {
            super.g(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public void z_() {
            if (this.npc == null) {
                super.z_();
            } else {
                NMSImpl.setSize((net.minecraft.world.entity.Entity)this, this.X);
            }
        }

        public boolean e(NBTTagCompound save) {
            return this.npc == null ? super.e(save) : false;
        }

        public net.minecraft.world.entity.Entity teleportTo(WorldServer worldserver, Position location) {
            if (this.npc == null) {
                return super.teleportTo(worldserver, location);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, worldserver, location);
        }

        public void k() {
            if (this.npc != null) {
                this.npc.update();
                Vec3D mot = this.dd();
                if (Math.abs(mot.c) > 0.001 || Math.abs(mot.d) > 0.001 || Math.abs(mot.e) > 0.001) {
                    mot = mot.d(0.98, 0.98, 0.98);
                    this.f(mot);
                    this.a(EnumMoveType.a, mot);
                }
            } else {
                super.k();
            }
        }

        public boolean a(TagKey<FluidType> tagkey, double d0) {
            Vec3D old = this.dd().b(0.0, 0.0, 0.0);
            boolean res = super.a(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.f(old);
            }
            return res;
        }
    }

    public static class FallingBlockNPC
    extends CraftFallingBlock
    implements NPCHolder {
        private final CitizensNPC npc;

        public FallingBlockNPC(EntityFallingBlockNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityFallingBlock)entity);
            this.npc = entity.npc;
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public void setType(Material material, int data) {
            this.npc.data().setPersistent("item-type-id", (Object)material.name());
            this.npc.data().setPersistent("item-type-data", (Object)data);
            if (this.npc.isSpawned()) {
                this.npc.despawn(DespawnReason.PENDING_RESPAWN);
                this.npc.spawn(this.npc.getStoredLocation(), SpawnReason.RESPAWN);
            }
        }
    }
}

