/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_19_R1.entity;

import net.citizensnpcs.api.event.NPCEnderTeleportEvent;
import net.citizensnpcs.api.event.NPCKnockbackEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_19_R1.entity.MobEntityController;
import net.citizensnpcs.nms.v1_19_R1.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_19_R1.util.NMSImpl;
import net.citizensnpcs.nms.v1_19_R1.util.PlayerMoveControl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Position;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.monster.EntityPhantom;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_19_R1.CraftServer;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftPhantom;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Phantom;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

public class PhantomController
extends MobEntityController {
    public PhantomController() {
        super(EntityPhantomNPC.class);
    }

    public Phantom getBukkitEntity() {
        return (Phantom)super.getBukkitEntity();
    }

    public static class EntityPhantomNPC
    extends EntityPhantom
    implements NPCHolder {
        boolean calledNMSHeight = false;
        private final CitizensNPC npc;
        private ControllerLook oldLookController;
        private ControllerMove oldMoveController;

        public EntityPhantomNPC(EntityTypes<? extends EntityPhantom> types, World level) {
            this(types, level, null);
        }

        public EntityPhantomNPC(EntityTypes<? extends EntityPhantom> types, World level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                this.s(true);
                this.oldMoveController = this.bP;
                this.oldLookController = this.bO;
                this.bP = new ControllerMove((EntityInsentient)this);
                this.bO = new ControllerLook((EntityInsentient)this);
            }
        }

        public void w_() {
            super.w_();
            if (this.npc != null) {
                NMSImpl.updateMinecraftAIState(this.npc, (EntityInsentient)this);
                if (this.npc.useMinecraftAI() && this.bP != this.oldMoveController) {
                    this.bP = this.oldMoveController;
                    this.bO = this.oldLookController;
                    this.s(false);
                }
                if (!this.npc.useMinecraftAI() && this.bP == this.oldMoveController) {
                    this.bP = new PlayerMoveControl((EntityLiving)this);
                    this.bO = new ControllerLook((EntityInsentient)this);
                    this.s(true);
                }
                if (this.npc.isProtected()) {
                    this.f(0);
                }
                this.npc.update();
            }
        }

        protected boolean l(net.minecraft.world.entity.Entity entity) {
            if (this.npc != null && (entity instanceof EntityBoat || entity instanceof EntityMinecartAbstract)) {
                return this.npc.data().get("protected", Boolean.valueOf(true)) == false;
            }
            return super.l(entity);
        }

        public boolean a(float f, float f1, DamageSource damagesource) {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.a(f, f1, damagesource);
            }
            return false;
        }

        public void dm() {
            if (this.npc == null) {
                super.dm();
            }
        }

        protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.a(d0, flag, iblockdata, blockposition);
            }
        }

        public void a(double d0, double d1, double d2) {
            if (this.npc == null) {
                super.a(d0, d1, d2);
                return;
            }
            NPCEnderTeleportEvent event = new NPCEnderTeleportEvent(this.npc);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                super.a(d0, d1, d2);
            }
        }

        protected SoundEffect r() {
            return NMSImpl.getSoundEffect(this.npc, super.r(), "ambient-sound");
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new PhantomNPC(this));
            }
            return super.getBukkitEntity();
        }

        protected SoundEffect x_() {
            return NMSImpl.getSoundEffect(this.npc, super.x_(), "death-sound");
        }

        protected SoundEffect c(DamageSource damagesource) {
            return NMSImpl.getSoundEffect(this.npc, super.c(damagesource), "hurt-sound");
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public boolean fy() {
            return NMSImpl.isLeashed((EntityInsentient)this, super.fy());
        }

        public boolean fD() {
            if (this.npc == null || !this.npc.isProtected()) {
                return super.fD();
            }
            return false;
        }

        public void p(double strength, double dx, double dz) {
            NPCKnockbackEvent event = new NPCKnockbackEvent(this.npc, strength, dx, dz);
            Bukkit.getPluginManager().callEvent((Event)event);
            Vector kb = event.getKnockbackVector();
            super.p(event.getStrength(), kb.getX(), kb.getZ());
        }

        public boolean b_() {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.b_();
            }
            return false;
        }

        public void a(DataWatcherObject<?> datawatcherobject) {
            if (this.npc != null && !this.calledNMSHeight) {
                this.calledNMSHeight = true;
                NMSImpl.checkAndUpdateHeight((EntityLiving)this, datawatcherobject);
                this.calledNMSHeight = false;
                return;
            }
            super.a(datawatcherobject);
        }

        public void i(double x, double y, double z) {
            Vector vector = Util.callPushEvent(this.npc, x, y, z);
            if (vector != null) {
                super.i(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public void g(net.minecraft.world.entity.Entity entity) {
            super.g(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean e(NBTTagCompound save) {
            return this.npc == null ? super.e(save) : false;
        }

        public net.minecraft.world.entity.Entity teleportTo(WorldServer worldserver, Position location) {
            if (this.npc == null) {
                return super.teleportTo(worldserver, location);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, worldserver, location);
        }

        public void k() {
            boolean resetDifficulty;
            boolean bl = resetDifficulty = this.npc != null && this.s.ag() == EnumDifficulty.a;
            if (resetDifficulty) {
                ((SaveData)this.s.n_()).a(EnumDifficulty.c);
            }
            super.k();
            if (resetDifficulty) {
                ((SaveData)this.s.n_()).a(EnumDifficulty.a);
            }
        }

        public void g(Vec3D vec3d) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.g(vec3d);
            } else {
                NMSImpl.flyingMoveLogic((EntityLiving)this, vec3d);
            }
        }

        public boolean a(TagKey<FluidType> tagkey, double d0) {
            Vec3D old = this.dd().b(0.0, 0.0, 0.0);
            boolean res = super.a(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.f(old);
            }
            return res;
        }
    }

    public static class PhantomNPC
    extends CraftPhantom
    implements ForwardingNPCHolder {
        public PhantomNPC(EntityPhantomNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityPhantom)entity);
        }
    }
}

