/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_19_R1.entity;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.NPCEnderTeleportEvent;
import net.citizensnpcs.api.event.NPCKnockbackEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_19_R1.entity.MobEntityController;
import net.citizensnpcs.nms.v1_19_R1.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_19_R1.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Position;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_19_R1.CraftServer;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftAllay;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftEntity;
import org.bukkit.entity.Allay;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

public class AllayController
extends MobEntityController {
    public AllayController() {
        super(EntityAllayNPC.class);
    }

    public Allay getBukkitEntity() {
        return (Allay)super.getBukkitEntity();
    }

    public static class EntityAllayNPC
    extends net.minecraft.world.entity.animal.allay.Allay
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityAllayNPC(EntityTypes<? extends net.minecraft.world.entity.animal.allay.Allay> types, World level) {
            this(types, level, null);
        }

        public EntityAllayNPC(EntityTypes<? extends net.minecraft.world.entity.animal.allay.Allay> types, World level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
        }

        protected boolean l(net.minecraft.world.entity.Entity entity) {
            if (this.npc != null && (entity instanceof EntityBoat || entity instanceof EntityMinecartAbstract)) {
                return this.npc.data().get("protected", Boolean.valueOf(true)) == false;
            }
            return super.l(entity);
        }

        public boolean a(float f, float f1, DamageSource damagesource) {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.a(f, f1, damagesource);
            }
            return false;
        }

        public void dm() {
            if (this.npc == null) {
                super.dm();
            }
        }

        protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.a(d0, flag, iblockdata, blockposition);
            }
        }

        public void T() {
            super.T();
            if (this.npc != null) {
                NMSImpl.updateMinecraftAIState(this.npc, (EntityInsentient)this);
                this.npc.update();
            }
        }

        public void a(double d0, double d1, double d2) {
            if (this.npc == null) {
                super.a(d0, d1, d2);
                return;
            }
            NPCEnderTeleportEvent event = new NPCEnderTeleportEvent(this.npc);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                super.a(d0, d1, d2);
            }
        }

        protected SoundEffect r() {
            return NMSImpl.getSoundEffect(this.npc, super.r(), "ambient-sound");
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new AllayNPC(this));
            }
            return super.getBukkitEntity();
        }

        protected SoundEffect x_() {
            return NMSImpl.getSoundEffect(this.npc, super.x_(), "death-sound");
        }

        protected SoundEffect c(DamageSource damagesource) {
            return NMSImpl.getSoundEffect(this.npc, super.c(damagesource), "hurt-sound");
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public boolean fy() {
            return NMSImpl.isLeashed((EntityInsentient)this, super.fy());
        }

        public void p(double strength, double dx, double dz) {
            NPCKnockbackEvent event = new NPCKnockbackEvent(this.npc, strength, dx, dz);
            Bukkit.getPluginManager().callEvent((Event)event);
            Vector kb = event.getKnockbackVector();
            super.p(event.getStrength(), kb.getX(), kb.getZ());
        }

        protected EnumInteractionResult b(EntityHuman var0, EnumHand var1) {
            if (this.npc != null && this.npc.isProtected()) {
                Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> NMSImpl.sendPacketNearby(null, this.getBukkitEntity().getLocation(), new PacketPlayOutEntityEquipment(this.ae(), (List)Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)EnumItemSlot.a, (Object)this.b(EnumHand.a))}))));
                return EnumInteractionResult.e;
            }
            return super.b(var0, var1);
        }

        public boolean b_() {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.b_();
            }
            return false;
        }

        public void i(double x, double y, double z) {
            Vector vector = Util.callPushEvent(this.npc, x, y, z);
            if (vector != null) {
                super.i(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public void g(net.minecraft.world.entity.Entity entity) {
            super.g(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean e(NBTTagCompound save) {
            return this.npc == null ? super.e(save) : false;
        }

        public net.minecraft.world.entity.Entity teleportTo(WorldServer worldserver, Position location) {
            if (this.npc == null) {
                return super.teleportTo(worldserver, location);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, worldserver, location);
        }

        public void g(Vec3D vec3d) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.g(vec3d);
            } else {
                NMSImpl.flyingMoveLogic((EntityLiving)this, vec3d);
            }
        }

        public boolean a(TagKey<FluidType> tagkey, double d0) {
            Vec3D old = this.dd().b(0.0, 0.0, 0.0);
            boolean res = super.a(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.f(old);
            }
            return res;
        }
    }

    public static class AllayNPC
    extends CraftAllay
    implements ForwardingNPCHolder {
        public AllayNPC(EntityAllayNPC entity) {
            super((CraftServer)Bukkit.getServer(), (net.minecraft.world.entity.animal.allay.Allay)entity);
        }
    }
}

